package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationBuilder extends IntegrationFluentImpl<IntegrationBuilder> implements VisitableBuilder<io.fabric8.camelk.v1.Integration,IntegrationBuilder>{
  public IntegrationBuilder() {
    this(false);
  }
  public IntegrationBuilder(Boolean validationEnabled) {
    this(new Integration(), validationEnabled);
  }
  public IntegrationBuilder(IntegrationFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationBuilder(io.fabric8.camelk.v1.IntegrationFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Integration(), validationEnabled);
  }
  public IntegrationBuilder(io.fabric8.camelk.v1.IntegrationFluent<?> fluent,io.fabric8.camelk.v1.Integration instance) {
    this(fluent, instance, false);
  }
  public IntegrationBuilder(io.fabric8.camelk.v1.IntegrationFluent<?> fluent,io.fabric8.camelk.v1.Integration instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationBuilder(io.fabric8.camelk.v1.Integration instance) {
    this(instance,false);
  }
  public IntegrationBuilder(io.fabric8.camelk.v1.Integration instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.IntegrationFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.Integration build() {
    Integration buildable = new Integration(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}