package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FailureBuilder extends FailureFluentImpl<FailureBuilder> implements VisitableBuilder<Failure,io.fabric8.camelk.v1.FailureBuilder>{
  public FailureBuilder() {
    this(false);
  }
  public FailureBuilder(Boolean validationEnabled) {
    this(new Failure(), validationEnabled);
  }
  public FailureBuilder(FailureFluent<?> fluent) {
    this(fluent, false);
  }
  public FailureBuilder(io.fabric8.camelk.v1.FailureFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Failure(), validationEnabled);
  }
  public FailureBuilder(io.fabric8.camelk.v1.FailureFluent<?> fluent,io.fabric8.camelk.v1.Failure instance) {
    this(fluent, instance, false);
  }
  public FailureBuilder(io.fabric8.camelk.v1.FailureFluent<?> fluent,io.fabric8.camelk.v1.Failure instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withReason(instance.getReason()); 
    fluent.withRecovery(instance.getRecovery()); 
    fluent.withTime(instance.getTime()); 
    this.validationEnabled = validationEnabled; 
  }
  public FailureBuilder(io.fabric8.camelk.v1.Failure instance) {
    this(instance,false);
  }
  public FailureBuilder(io.fabric8.camelk.v1.Failure instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withReason(instance.getReason()); 
    this.withRecovery(instance.getRecovery()); 
    this.withTime(instance.getTime()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.FailureFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.Failure build() {
    Failure buildable = new Failure(fluent.getReason(),fluent.getRecovery(),fluent.getTime());
    return buildable;
  }
  
}