package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigurationSpecBuilder extends ConfigurationSpecFluentImpl<ConfigurationSpecBuilder> implements VisitableBuilder<ConfigurationSpec,io.fabric8.camelk.v1.ConfigurationSpecBuilder>{
  public ConfigurationSpecBuilder() {
    this(false);
  }
  public ConfigurationSpecBuilder(Boolean validationEnabled) {
    this(new ConfigurationSpec(), validationEnabled);
  }
  public ConfigurationSpecBuilder(io.fabric8.camelk.v1.ConfigurationSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigurationSpecBuilder(io.fabric8.camelk.v1.ConfigurationSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConfigurationSpec(), validationEnabled);
  }
  public ConfigurationSpecBuilder(io.fabric8.camelk.v1.ConfigurationSpecFluent<?> fluent,io.fabric8.camelk.v1.ConfigurationSpec instance) {
    this(fluent, instance, false);
  }
  public ConfigurationSpecBuilder(io.fabric8.camelk.v1.ConfigurationSpecFluent<?> fluent,io.fabric8.camelk.v1.ConfigurationSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withResourceKey(instance.getResourceKey()); 
    fluent.withResourceMountPoint(instance.getResourceMountPoint()); 
    fluent.withResourceType(instance.getResourceType()); 
    fluent.withType(instance.getType()); 
    fluent.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  public ConfigurationSpecBuilder(io.fabric8.camelk.v1.ConfigurationSpec instance) {
    this(instance,false);
  }
  public ConfigurationSpecBuilder(io.fabric8.camelk.v1.ConfigurationSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withResourceKey(instance.getResourceKey()); 
    this.withResourceMountPoint(instance.getResourceMountPoint()); 
    this.withResourceType(instance.getResourceType()); 
    this.withType(instance.getType()); 
    this.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.ConfigurationSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.ConfigurationSpec build() {
    ConfigurationSpec buildable = new ConfigurationSpec(fluent.getResourceKey(),fluent.getResourceMountPoint(),fluent.getResourceType(),fluent.getType(),fluent.getValue());
    return buildable;
  }
  
}