package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CamelCatalogListBuilder extends CamelCatalogListFluentImpl<CamelCatalogListBuilder> implements VisitableBuilder<CamelCatalogList,io.fabric8.camelk.v1.CamelCatalogListBuilder>{
  public CamelCatalogListBuilder() {
    this(false);
  }
  public CamelCatalogListBuilder(Boolean validationEnabled) {
    this(new CamelCatalogList(), validationEnabled);
  }
  public CamelCatalogListBuilder(CamelCatalogListFluent<?> fluent) {
    this(fluent, false);
  }
  public CamelCatalogListBuilder(io.fabric8.camelk.v1.CamelCatalogListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CamelCatalogList(), validationEnabled);
  }
  public CamelCatalogListBuilder(io.fabric8.camelk.v1.CamelCatalogListFluent<?> fluent,io.fabric8.camelk.v1.CamelCatalogList instance) {
    this(fluent, instance, false);
  }
  public CamelCatalogListBuilder(io.fabric8.camelk.v1.CamelCatalogListFluent<?> fluent,io.fabric8.camelk.v1.CamelCatalogList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public CamelCatalogListBuilder(io.fabric8.camelk.v1.CamelCatalogList instance) {
    this(instance,false);
  }
  public CamelCatalogListBuilder(io.fabric8.camelk.v1.CamelCatalogList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.CamelCatalogListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.CamelCatalogList build() {
    CamelCatalogList buildable = new CamelCatalogList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}