package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CamelCatalogBuilder extends CamelCatalogFluentImpl<CamelCatalogBuilder> implements VisitableBuilder<io.fabric8.camelk.v1.CamelCatalog,CamelCatalogBuilder>{
  public CamelCatalogBuilder() {
    this(false);
  }
  public CamelCatalogBuilder(Boolean validationEnabled) {
    this(new CamelCatalog(), validationEnabled);
  }
  public CamelCatalogBuilder(CamelCatalogFluent<?> fluent) {
    this(fluent, false);
  }
  public CamelCatalogBuilder(io.fabric8.camelk.v1.CamelCatalogFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CamelCatalog(), validationEnabled);
  }
  public CamelCatalogBuilder(io.fabric8.camelk.v1.CamelCatalogFluent<?> fluent,io.fabric8.camelk.v1.CamelCatalog instance) {
    this(fluent, instance, false);
  }
  public CamelCatalogBuilder(io.fabric8.camelk.v1.CamelCatalogFluent<?> fluent,io.fabric8.camelk.v1.CamelCatalog instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public CamelCatalogBuilder(io.fabric8.camelk.v1.CamelCatalog instance) {
    this(instance,false);
  }
  public CamelCatalogBuilder(io.fabric8.camelk.v1.CamelCatalog instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.CamelCatalogFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.CamelCatalog build() {
    CamelCatalog buildable = new CamelCatalog(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}