package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuilderTaskFluentImpl<A extends BuilderTaskFluent<A>> extends BaseFluent<A> implements BuilderTaskFluent<A>{
  public BuilderTaskFluentImpl() {
  }
  public BuilderTaskFluentImpl(io.fabric8.camelk.v1.BuilderTask instance) {
    this.withBaseImage(instance.getBaseImage()); 
    this.withBuildDir(instance.getBuildDir()); 
    this.withDependencies(instance.getDependencies()); 
    this.withMaven(instance.getMaven()); 
    this.withName(instance.getName()); 
    this.withResources(instance.getResources()); 
    this.withRuntime(instance.getRuntime()); 
    this.withSources(instance.getSources()); 
    this.withSteps(instance.getSteps()); 
  }
  private String baseImage;
  private java.lang.String buildDir;
  private List<java.lang.String> dependencies = new ArrayList<java.lang.String>();
  private MavenBuildSpecBuilder maven;
  private java.lang.String name;
  private java.util.ArrayList<ResourceSpecBuilder> resources = new java.util.ArrayList<ResourceSpecBuilder>();
  private RuntimeSpecBuilder runtime;
  private java.util.ArrayList<SourceSpecBuilder> sources = new java.util.ArrayList<SourceSpecBuilder>();
  private java.util.List<java.lang.String> steps = new java.util.ArrayList<java.lang.String>();
  public java.lang.String getBaseImage() {
    return this.baseImage;
  }
  public A withBaseImage(java.lang.String baseImage) {
    this.baseImage=baseImage; return (A) this;
  }
  public Boolean hasBaseImage() {
    return this.baseImage != null;
  }
  public java.lang.String getBuildDir() {
    return this.buildDir;
  }
  public A withBuildDir(java.lang.String buildDir) {
    this.buildDir=buildDir; return (A) this;
  }
  public java.lang.Boolean hasBuildDir() {
    return this.buildDir != null;
  }
  public A addToDependencies(Integer index,java.lang.String item) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
    this.dependencies.add(index, item);
    return (A)this;
  }
  public A setToDependencies(java.lang.Integer index,java.lang.String item) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
    this.dependencies.set(index, item); return (A)this;
  }
  public A addToDependencies(java.lang.String... items) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A addAllToDependencies(Collection<java.lang.String> items) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A removeFromDependencies(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public A removeAllFromDependencies(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getDependencies() {
    return this.dependencies;
  }
  public java.lang.String getDependency(java.lang.Integer index) {
    return this.dependencies.get(index);
  }
  public java.lang.String getFirstDependency() {
    return this.dependencies.get(0);
  }
  public java.lang.String getLastDependency() {
    return this.dependencies.get(dependencies.size() - 1);
  }
  public java.lang.String getMatchingDependency(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingDependency(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(java.util.List<java.lang.String> dependencies) {
    if (dependencies != null) {this.dependencies = new java.util.ArrayList(); for (java.lang.String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(java.lang.String... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear();}
    if (dependencies != null) {for (java.lang.String item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public java.lang.Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildMaven instead.
   * @return The buildable object.
   */
  @Deprecated
  public MavenBuildSpec getMaven() {
    return this.maven!=null ?this.maven.build():null;
  }
  public io.fabric8.camelk.v1.MavenBuildSpec buildMaven() {
    return this.maven!=null ?this.maven.build():null;
  }
  public A withMaven(io.fabric8.camelk.v1.MavenBuildSpec maven) {
    _visitables.get("maven").remove(this.maven);
    if (maven!=null){ this.maven= new io.fabric8.camelk.v1.MavenBuildSpecBuilder(maven); _visitables.get("maven").add(this.maven);} return (A) this;
  }
  public java.lang.Boolean hasMaven() {
    return this.maven != null;
  }
  public BuilderTaskFluent.MavenNested<A> withNewMaven() {
    return new BuilderTaskFluentImpl.MavenNestedImpl();
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> withNewMavenLike(io.fabric8.camelk.v1.MavenBuildSpec item) {
    return new BuilderTaskFluentImpl.MavenNestedImpl(item);
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> editMaven() {
    return withNewMavenLike(getMaven());
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> editOrNewMaven() {
    return withNewMavenLike(getMaven() != null ? getMaven(): new io.fabric8.camelk.v1.MavenBuildSpecBuilder().build());
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> editOrNewMavenLike(io.fabric8.camelk.v1.MavenBuildSpec item) {
    return withNewMavenLike(getMaven() != null ? getMaven(): item);
  }
  public java.lang.String getName() {
    return this.name;
  }
  public A withName(java.lang.String name) {
    this.name=name; return (A) this;
  }
  public java.lang.Boolean hasName() {
    return this.name != null;
  }
  public A addToResources(java.lang.Integer index,io.fabric8.camelk.v1.ResourceSpec item) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
    io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
  }
  public A setToResources(java.lang.Integer index,io.fabric8.camelk.v1.ResourceSpec item) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
    io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
    if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
     return (A)this;
  }
  public A addToResources(io.fabric8.camelk.v1.ResourceSpec... items) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
    for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  public A addAllToResources(java.util.Collection<io.fabric8.camelk.v1.ResourceSpec> items) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
    for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  public A removeFromResources(io.fabric8.camelk.v1.ResourceSpec... items) {
    for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
  }
  public A removeAllFromResources(java.util.Collection<io.fabric8.camelk.v1.ResourceSpec> items) {
    for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResources(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
    if (resources == null) return (A) this;
    final Iterator<io.fabric8.camelk.v1.ResourceSpecBuilder> each = resources.iterator();
    final List visitables = _visitables.get("resources");
    while (each.hasNext()) {
      io.fabric8.camelk.v1.ResourceSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.camelk.v1.ResourceSpec> getResources() {
    return resources != null ? build(resources) : null;
  }
  public java.util.List<io.fabric8.camelk.v1.ResourceSpec> buildResources() {
    return resources != null ? build(resources) : null;
  }
  public io.fabric8.camelk.v1.ResourceSpec buildResource(java.lang.Integer index) {
    return this.resources.get(index).build();
  }
  public io.fabric8.camelk.v1.ResourceSpec buildFirstResource() {
    return this.resources.get(0).build();
  }
  public io.fabric8.camelk.v1.ResourceSpec buildLastResource() {
    return this.resources.get(resources.size() - 1).build();
  }
  public io.fabric8.camelk.v1.ResourceSpec buildMatchingResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.ResourceSpecBuilder item: resources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.ResourceSpecBuilder item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResources(java.util.List<io.fabric8.camelk.v1.ResourceSpec> resources) {
    if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
    if (resources != null) {this.resources = new java.util.ArrayList(); for (io.fabric8.camelk.v1.ResourceSpec item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(io.fabric8.camelk.v1.ResourceSpec... resources) {
    if (this.resources != null) {this.resources.clear();}
    if (resources != null) {for (io.fabric8.camelk.v1.ResourceSpec item :resources){ this.addToResources(item);}} return (A) this;
  }
  public java.lang.Boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public BuilderTaskFluent.ResourcesNested<A> addNewResource() {
    return new BuilderTaskFluentImpl.ResourcesNestedImpl();
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> addNewResourceLike(io.fabric8.camelk.v1.ResourceSpec item) {
    return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.ResourcesNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> setNewResourceLike(java.lang.Integer index,io.fabric8.camelk.v1.ResourceSpec item) {
    return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.ResourcesNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editResource(java.lang.Integer index) {
    if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
    return setNewResourceLike(index, buildResource(index));
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editFirstResource() {
    if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
    return setNewResourceLike(0, buildResource(0));
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editLastResource() {
    int index = resources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
    return setNewResourceLike(index, buildResource(index));
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editMatchingResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resources.size();i++) { 
    if (predicate.test(resources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
    return setNewResourceLike(index, buildResource(index));
  }
  
  /**
   * This method has been deprecated, please use method buildRuntime instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public RuntimeSpec getRuntime() {
    return this.runtime!=null ?this.runtime.build():null;
  }
  public io.fabric8.camelk.v1.RuntimeSpec buildRuntime() {
    return this.runtime!=null ?this.runtime.build():null;
  }
  public A withRuntime(io.fabric8.camelk.v1.RuntimeSpec runtime) {
    _visitables.get("runtime").remove(this.runtime);
    if (runtime!=null){ this.runtime= new io.fabric8.camelk.v1.RuntimeSpecBuilder(runtime); _visitables.get("runtime").add(this.runtime);} return (A) this;
  }
  public java.lang.Boolean hasRuntime() {
    return this.runtime != null;
  }
  public BuilderTaskFluent.RuntimeNested<A> withNewRuntime() {
    return new BuilderTaskFluentImpl.RuntimeNestedImpl();
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> withNewRuntimeLike(io.fabric8.camelk.v1.RuntimeSpec item) {
    return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.RuntimeNestedImpl(item);
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> editRuntime() {
    return withNewRuntimeLike(getRuntime());
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> editOrNewRuntime() {
    return withNewRuntimeLike(getRuntime() != null ? getRuntime(): new io.fabric8.camelk.v1.RuntimeSpecBuilder().build());
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> editOrNewRuntimeLike(io.fabric8.camelk.v1.RuntimeSpec item) {
    return withNewRuntimeLike(getRuntime() != null ? getRuntime(): item);
  }
  public A addToSources(java.lang.Integer index,io.fabric8.camelk.v1.SourceSpec item) {
    if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
    io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").add(index >= 0 ? index : _visitables.get("sources").size(), builder);this.sources.add(index >= 0 ? index : sources.size(), builder); return (A)this;
  }
  public A setToSources(java.lang.Integer index,io.fabric8.camelk.v1.SourceSpec item) {
    if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
    io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("sources").size()) { _visitables.get("sources").add(builder); } else { _visitables.get("sources").set(index, builder);}
    if (index < 0 || index >= sources.size()) { sources.add(builder); } else { sources.set(index, builder);}
     return (A)this;
  }
  public A addToSources(io.fabric8.camelk.v1.SourceSpec... items) {
    if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
    for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
  }
  public A addAllToSources(java.util.Collection<io.fabric8.camelk.v1.SourceSpec> items) {
    if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
    for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
  }
  public A removeFromSources(io.fabric8.camelk.v1.SourceSpec... items) {
    for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
  }
  public A removeAllFromSources(java.util.Collection<io.fabric8.camelk.v1.SourceSpec> items) {
    for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSources(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
    if (sources == null) return (A) this;
    final Iterator<io.fabric8.camelk.v1.SourceSpecBuilder> each = sources.iterator();
    final List visitables = _visitables.get("sources");
    while (each.hasNext()) {
      io.fabric8.camelk.v1.SourceSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSources instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.camelk.v1.SourceSpec> getSources() {
    return sources != null ? build(sources) : null;
  }
  public java.util.List<io.fabric8.camelk.v1.SourceSpec> buildSources() {
    return sources != null ? build(sources) : null;
  }
  public io.fabric8.camelk.v1.SourceSpec buildSource(java.lang.Integer index) {
    return this.sources.get(index).build();
  }
  public io.fabric8.camelk.v1.SourceSpec buildFirstSource() {
    return this.sources.get(0).build();
  }
  public io.fabric8.camelk.v1.SourceSpec buildLastSource() {
    return this.sources.get(sources.size() - 1).build();
  }
  public io.fabric8.camelk.v1.SourceSpec buildMatchingSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.SourceSpecBuilder item: sources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
    for (io.fabric8.camelk.v1.SourceSpecBuilder item: sources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSources(java.util.List<io.fabric8.camelk.v1.SourceSpec> sources) {
    if (this.sources != null) { _visitables.get("sources").removeAll(this.sources);}
    if (sources != null) {this.sources = new java.util.ArrayList(); for (io.fabric8.camelk.v1.SourceSpec item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
  }
  public A withSources(io.fabric8.camelk.v1.SourceSpec... sources) {
    if (this.sources != null) {this.sources.clear();}
    if (sources != null) {for (io.fabric8.camelk.v1.SourceSpec item :sources){ this.addToSources(item);}} return (A) this;
  }
  public java.lang.Boolean hasSources() {
    return sources != null && !sources.isEmpty();
  }
  public BuilderTaskFluent.SourcesNested<A> addNewSource() {
    return new BuilderTaskFluentImpl.SourcesNestedImpl();
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> addNewSourceLike(io.fabric8.camelk.v1.SourceSpec item) {
    return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.SourcesNestedImpl(-1, item);
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> setNewSourceLike(java.lang.Integer index,io.fabric8.camelk.v1.SourceSpec item) {
    return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.SourcesNestedImpl(index, item);
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editSource(java.lang.Integer index) {
    if (sources.size() <= index) throw new RuntimeException("Can't edit sources. Index exceeds size.");
    return setNewSourceLike(index, buildSource(index));
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editFirstSource() {
    if (sources.size() == 0) throw new RuntimeException("Can't edit first sources. The list is empty.");
    return setNewSourceLike(0, buildSource(0));
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editLastSource() {
    int index = sources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sources. The list is empty.");
    return setNewSourceLike(index, buildSource(index));
  }
  public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editMatchingSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sources.size();i++) { 
    if (predicate.test(sources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sources. No match found.");
    return setNewSourceLike(index, buildSource(index));
  }
  public A addToSteps(java.lang.Integer index,java.lang.String item) {
    if (this.steps == null) {this.steps = new java.util.ArrayList<java.lang.String>();}
    this.steps.add(index, item);
    return (A)this;
  }
  public A setToSteps(java.lang.Integer index,java.lang.String item) {
    if (this.steps == null) {this.steps = new java.util.ArrayList<java.lang.String>();}
    this.steps.set(index, item); return (A)this;
  }
  public A addToSteps(java.lang.String... items) {
    if (this.steps == null) {this.steps = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.steps.add(item);} return (A)this;
  }
  public A addAllToSteps(java.util.Collection<java.lang.String> items) {
    if (this.steps == null) {this.steps = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.steps.add(item);} return (A)this;
  }
  public A removeFromSteps(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.steps!= null){ this.steps.remove(item);}} return (A)this;
  }
  public A removeAllFromSteps(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.steps!= null){ this.steps.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getSteps() {
    return this.steps;
  }
  public java.lang.String getStep(java.lang.Integer index) {
    return this.steps.get(index);
  }
  public java.lang.String getFirstStep() {
    return this.steps.get(0);
  }
  public java.lang.String getLastStep() {
    return this.steps.get(steps.size() - 1);
  }
  public java.lang.String getMatchingStep(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: steps) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingStep(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: steps) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSteps(java.util.List<java.lang.String> steps) {
    if (steps != null) {this.steps = new java.util.ArrayList(); for (java.lang.String item : steps){this.addToSteps(item);}} else { this.steps = null;} return (A) this;
  }
  public A withSteps(java.lang.String... steps) {
    if (this.steps != null) {this.steps.clear();}
    if (steps != null) {for (java.lang.String item :steps){ this.addToSteps(item);}} return (A) this;
  }
  public java.lang.Boolean hasSteps() {
    return steps != null && !steps.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BuilderTaskFluentImpl that = (BuilderTaskFluentImpl) o;
    if (baseImage != null ? !baseImage.equals(that.baseImage) :that.baseImage != null) return false;
    if (buildDir != null ? !buildDir.equals(that.buildDir) :that.buildDir != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (maven != null ? !maven.equals(that.maven) :that.maven != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (runtime != null ? !runtime.equals(that.runtime) :that.runtime != null) return false;
    if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
    if (steps != null ? !steps.equals(that.steps) :that.steps != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(baseImage,  buildDir,  dependencies,  maven,  name,  resources,  runtime,  sources,  steps,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseImage != null) { sb.append("baseImage:"); sb.append(baseImage + ","); }
    if (buildDir != null) { sb.append("buildDir:"); sb.append(buildDir + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (maven != null) { sb.append("maven:"); sb.append(maven + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (runtime != null) { sb.append("runtime:"); sb.append(runtime + ","); }
    if (sources != null && !sources.isEmpty()) { sb.append("sources:"); sb.append(sources + ","); }
    if (steps != null && !steps.isEmpty()) { sb.append("steps:"); sb.append(steps); }
    sb.append("}");
    return sb.toString();
  }
  class MavenNestedImpl<N> extends MavenBuildSpecFluentImpl<BuilderTaskFluent.MavenNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<N>,Nested<N>{
    MavenNestedImpl(MavenBuildSpec item) {
      this.builder = new MavenBuildSpecBuilder(this, item);
    }
    MavenNestedImpl() {
      this.builder = new io.fabric8.camelk.v1.MavenBuildSpecBuilder(this);
    }
    io.fabric8.camelk.v1.MavenBuildSpecBuilder builder;
    public N and() {
      return (N) BuilderTaskFluentImpl.this.withMaven(builder.build());
    }
    public N endMaven() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceSpecFluentImpl<BuilderTaskFluent.ResourcesNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ResourcesNestedImpl(java.lang.Integer index,io.fabric8.camelk.v1.ResourceSpec item) {
      this.index = index;
      this.builder = new ResourceSpecBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(this);
    }
    io.fabric8.camelk.v1.ResourceSpecBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuilderTaskFluentImpl.this.setToResources(index,builder.build());
    }
    public N endResource() {
      return and();
    }
    
  }
  class RuntimeNestedImpl<N> extends RuntimeSpecFluentImpl<BuilderTaskFluent.RuntimeNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RuntimeNestedImpl(RuntimeSpec item) {
      this.builder = new RuntimeSpecBuilder(this, item);
    }
    RuntimeNestedImpl() {
      this.builder = new io.fabric8.camelk.v1.RuntimeSpecBuilder(this);
    }
    io.fabric8.camelk.v1.RuntimeSpecBuilder builder;
    public N and() {
      return (N) BuilderTaskFluentImpl.this.withRuntime(builder.build());
    }
    public N endRuntime() {
      return and();
    }
    
  }
  class SourcesNestedImpl<N> extends SourceSpecFluentImpl<BuilderTaskFluent.SourcesNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SourcesNestedImpl(java.lang.Integer index,SourceSpec item) {
      this.index = index;
      this.builder = new SourceSpecBuilder(this, item);
    }
    SourcesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.camelk.v1.SourceSpecBuilder(this);
    }
    io.fabric8.camelk.v1.SourceSpecBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuilderTaskFluentImpl.this.setToSources(index,builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  
}