package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildahTaskBuilder extends BuildahTaskFluentImpl<BuildahTaskBuilder> implements VisitableBuilder<io.fabric8.camelk.v1.BuildahTask,BuildahTaskBuilder>{
  public BuildahTaskBuilder() {
    this(false);
  }
  public BuildahTaskBuilder(Boolean validationEnabled) {
    this(new BuildahTask(), validationEnabled);
  }
  public BuildahTaskBuilder(BuildahTaskFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildahTaskBuilder(io.fabric8.camelk.v1.BuildahTaskFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildahTask(), validationEnabled);
  }
  public BuildahTaskBuilder(io.fabric8.camelk.v1.BuildahTaskFluent<?> fluent,io.fabric8.camelk.v1.BuildahTask instance) {
    this(fluent, instance, false);
  }
  public BuildahTaskBuilder(io.fabric8.camelk.v1.BuildahTaskFluent<?> fluent,io.fabric8.camelk.v1.BuildahTask instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBaseImage(instance.getBaseImage()); 
    fluent.withContextDir(instance.getContextDir()); 
    fluent.withImage(instance.getImage()); 
    fluent.withName(instance.getName()); 
    fluent.withRegistry(instance.getRegistry()); 
    fluent.withVerbose(instance.getVerbose()); 
    this.validationEnabled = validationEnabled; 
  }
  public BuildahTaskBuilder(io.fabric8.camelk.v1.BuildahTask instance) {
    this(instance,false);
  }
  public BuildahTaskBuilder(io.fabric8.camelk.v1.BuildahTask instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBaseImage(instance.getBaseImage()); 
    this.withContextDir(instance.getContextDir()); 
    this.withImage(instance.getImage()); 
    this.withName(instance.getName()); 
    this.withRegistry(instance.getRegistry()); 
    this.withVerbose(instance.getVerbose()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.BuildahTaskFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.BuildahTask build() {
    BuildahTask buildable = new BuildahTask(fluent.getBaseImage(),fluent.getContextDir(),fluent.getImage(),fluent.getName(),fluent.getRegistry(),fluent.getVerbose());
    return buildable;
  }
  
}