package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildBuilder extends BuildFluentImpl<BuildBuilder> implements VisitableBuilder<io.fabric8.camelk.v1.Build,io.fabric8.camelk.v1.BuildBuilder>{
  public BuildBuilder() {
    this(false);
  }
  public BuildBuilder(Boolean validationEnabled) {
    this(new Build(), validationEnabled);
  }
  public BuildBuilder(BuildFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildBuilder(io.fabric8.camelk.v1.BuildFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Build(), validationEnabled);
  }
  public BuildBuilder(io.fabric8.camelk.v1.BuildFluent<?> fluent,io.fabric8.camelk.v1.Build instance) {
    this(fluent, instance, false);
  }
  public BuildBuilder(io.fabric8.camelk.v1.BuildFluent<?> fluent,io.fabric8.camelk.v1.Build instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public BuildBuilder(io.fabric8.camelk.v1.Build instance) {
    this(instance,false);
  }
  public BuildBuilder(io.fabric8.camelk.v1.Build instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.BuildFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.Build build() {
    Build buildable = new Build(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}