package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ArtifactBuilder extends ArtifactFluentImpl<ArtifactBuilder> implements VisitableBuilder<Artifact,io.fabric8.camelk.v1.ArtifactBuilder>{
  public ArtifactBuilder() {
    this(false);
  }
  public ArtifactBuilder(Boolean validationEnabled) {
    this(new Artifact(), validationEnabled);
  }
  public ArtifactBuilder(ArtifactFluent<?> fluent) {
    this(fluent, false);
  }
  public ArtifactBuilder(io.fabric8.camelk.v1.ArtifactFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Artifact(), validationEnabled);
  }
  public ArtifactBuilder(io.fabric8.camelk.v1.ArtifactFluent<?> fluent,io.fabric8.camelk.v1.Artifact instance) {
    this(fluent, instance, false);
  }
  public ArtifactBuilder(io.fabric8.camelk.v1.ArtifactFluent<?> fluent,io.fabric8.camelk.v1.Artifact instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withChecksum(instance.getChecksum()); 
    fluent.withId(instance.getId()); 
    fluent.withLocation(instance.getLocation()); 
    fluent.withTarget(instance.getTarget()); 
    this.validationEnabled = validationEnabled; 
  }
  public ArtifactBuilder(io.fabric8.camelk.v1.Artifact instance) {
    this(instance,false);
  }
  public ArtifactBuilder(io.fabric8.camelk.v1.Artifact instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withChecksum(instance.getChecksum()); 
    this.withId(instance.getId()); 
    this.withLocation(instance.getLocation()); 
    this.withTarget(instance.getTarget()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.ArtifactFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.Artifact build() {
    Artifact buildable = new Artifact(fluent.getChecksum(),fluent.getId(),fluent.getLocation(),fluent.getTarget());
    return buildable;
  }
  
}