
package io.fabric8.camelk.v1;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "baseImage",
    "buildStrategy",
    "httpProxySecret",
    "kanikoBuildCache",
    "maven",
    "persistentVolumeClaim",
    "properties",
    "publishStrategy",
    "registry",
    "runtimeProvider",
    "runtimeVersion",
    "timeout"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class IntegrationPlatformBuildSpec implements KubernetesResource
{

    @JsonProperty("baseImage")
    private java.lang.String baseImage;
    @JsonProperty("buildStrategy")
    private java.lang.String buildStrategy;
    @JsonProperty("httpProxySecret")
    private java.lang.String httpProxySecret;
    @JsonProperty("kanikoBuildCache")
    private Boolean kanikoBuildCache;
    @JsonProperty("maven")
    private MavenSpec maven;
    @JsonProperty("persistentVolumeClaim")
    private java.lang.String persistentVolumeClaim;
    @JsonProperty("properties")
    private Map<String, String> properties;
    @JsonProperty("publishStrategy")
    private java.lang.String publishStrategy;
    @JsonProperty("registry")
    private IntegrationPlatformRegistrySpec registry;
    @JsonProperty("runtimeProvider")
    private java.lang.String runtimeProvider;
    @JsonProperty("runtimeVersion")
    private java.lang.String runtimeVersion;
    @JsonProperty("timeout")
    private Duration timeout;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public IntegrationPlatformBuildSpec() {
    }

    /**
     * 
     * @param registry
     * @param runtimeVersion
     * @param buildStrategy
     * @param maven
     * @param httpProxySecret
     * @param runtimeProvider
     * @param baseImage
     * @param kanikoBuildCache
     * @param publishStrategy
     * @param persistentVolumeClaim
     * @param properties
     * @param timeout
     */
    public IntegrationPlatformBuildSpec(java.lang.String baseImage, java.lang.String buildStrategy, java.lang.String httpProxySecret, Boolean kanikoBuildCache, MavenSpec maven, java.lang.String persistentVolumeClaim, Map<String, String> properties, java.lang.String publishStrategy, IntegrationPlatformRegistrySpec registry, java.lang.String runtimeProvider, java.lang.String runtimeVersion, Duration timeout) {
        super();
        this.baseImage = baseImage;
        this.buildStrategy = buildStrategy;
        this.httpProxySecret = httpProxySecret;
        this.kanikoBuildCache = kanikoBuildCache;
        this.maven = maven;
        this.persistentVolumeClaim = persistentVolumeClaim;
        this.properties = properties;
        this.publishStrategy = publishStrategy;
        this.registry = registry;
        this.runtimeProvider = runtimeProvider;
        this.runtimeVersion = runtimeVersion;
        this.timeout = timeout;
    }

    @JsonProperty("baseImage")
    public java.lang.String getBaseImage() {
        return baseImage;
    }

    @JsonProperty("baseImage")
    public void setBaseImage(java.lang.String baseImage) {
        this.baseImage = baseImage;
    }

    @JsonProperty("buildStrategy")
    public java.lang.String getBuildStrategy() {
        return buildStrategy;
    }

    @JsonProperty("buildStrategy")
    public void setBuildStrategy(java.lang.String buildStrategy) {
        this.buildStrategy = buildStrategy;
    }

    @JsonProperty("httpProxySecret")
    public java.lang.String getHttpProxySecret() {
        return httpProxySecret;
    }

    @JsonProperty("httpProxySecret")
    public void setHttpProxySecret(java.lang.String httpProxySecret) {
        this.httpProxySecret = httpProxySecret;
    }

    @JsonProperty("kanikoBuildCache")
    public Boolean getKanikoBuildCache() {
        return kanikoBuildCache;
    }

    @JsonProperty("kanikoBuildCache")
    public void setKanikoBuildCache(Boolean kanikoBuildCache) {
        this.kanikoBuildCache = kanikoBuildCache;
    }

    @JsonProperty("maven")
    public MavenSpec getMaven() {
        return maven;
    }

    @JsonProperty("maven")
    public void setMaven(MavenSpec maven) {
        this.maven = maven;
    }

    @JsonProperty("persistentVolumeClaim")
    public java.lang.String getPersistentVolumeClaim() {
        return persistentVolumeClaim;
    }

    @JsonProperty("persistentVolumeClaim")
    public void setPersistentVolumeClaim(java.lang.String persistentVolumeClaim) {
        this.persistentVolumeClaim = persistentVolumeClaim;
    }

    @JsonProperty("properties")
    public Map<String, String> getProperties() {
        return properties;
    }

    @JsonProperty("properties")
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @JsonProperty("publishStrategy")
    public java.lang.String getPublishStrategy() {
        return publishStrategy;
    }

    @JsonProperty("publishStrategy")
    public void setPublishStrategy(java.lang.String publishStrategy) {
        this.publishStrategy = publishStrategy;
    }

    @JsonProperty("registry")
    public IntegrationPlatformRegistrySpec getRegistry() {
        return registry;
    }

    @JsonProperty("registry")
    public void setRegistry(IntegrationPlatformRegistrySpec registry) {
        this.registry = registry;
    }

    @JsonProperty("runtimeProvider")
    public java.lang.String getRuntimeProvider() {
        return runtimeProvider;
    }

    @JsonProperty("runtimeProvider")
    public void setRuntimeProvider(java.lang.String runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
    }

    @JsonProperty("runtimeVersion")
    public java.lang.String getRuntimeVersion() {
        return runtimeVersion;
    }

    @JsonProperty("runtimeVersion")
    public void setRuntimeVersion(java.lang.String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    @JsonProperty("timeout")
    public Duration getTimeout() {
        return timeout;
    }

    @JsonProperty("timeout")
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
