/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.CamelLoader;
import io.fabric8.camelk.v1.CamelLoaderFluent;
import io.fabric8.camelk.v1.MavenArtifact;
import io.fabric8.camelk.v1.MavenArtifactBuilder;
import io.fabric8.camelk.v1.MavenArtifactFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CamelLoaderFluentImpl<A extends CamelLoaderFluent<A>>
extends BaseFluent<A>
implements CamelLoaderFluent<A> {
    private String artifactId;
    private List<MavenArtifactBuilder> dependencies;
    private String groupId;
    private List<String> languages;
    private String version;

    public CamelLoaderFluentImpl() {
    }

    public CamelLoaderFluentImpl(CamelLoader instance) {
        this.withArtifactId(instance.getArtifactId());
        this.withDependencies(instance.getDependencies());
        this.withGroupId(instance.getGroupId());
        this.withLanguages(instance.getLanguages());
        this.withVersion(instance.getVersion());
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public A withArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return (A)this;
    }

    @Override
    public Boolean hasArtifactId() {
        return this.artifactId != null;
    }

    @Override
    @Deprecated
    public A withNewArtifactId(String arg0) {
        return this.withArtifactId(new String(arg0));
    }

    @Override
    public A addToDependencies(int index, MavenArtifact item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<MavenArtifactBuilder>();
        }
        MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
        this._visitables.get((Object)"dependencies").add(index >= 0 ? index : this._visitables.get((Object)"dependencies").size(), builder);
        this.dependencies.add(index >= 0 ? index : this.dependencies.size(), builder);
        return (A)this;
    }

    @Override
    public A setToDependencies(int index, MavenArtifact item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<MavenArtifactBuilder>();
        }
        MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"dependencies").size()) {
            this._visitables.get((Object)"dependencies").add(builder);
        } else {
            this._visitables.get((Object)"dependencies").set(index, builder);
        }
        if (index < 0 || index >= this.dependencies.size()) {
            this.dependencies.add(builder);
        } else {
            this.dependencies.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToDependencies(MavenArtifact ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<MavenArtifactBuilder>();
        }
        for (MavenArtifact item : items) {
            MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToDependencies(Collection<MavenArtifact> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<MavenArtifactBuilder>();
        }
        for (MavenArtifact item : items) {
            MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDependencies(MavenArtifact ... items) {
        for (MavenArtifact item : items) {
            MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
            this._visitables.get((Object)"dependencies").remove(builder);
            if (this.dependencies == null) continue;
            this.dependencies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDependencies(Collection<MavenArtifact> items) {
        for (MavenArtifact item : items) {
            MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
            this._visitables.get((Object)"dependencies").remove(builder);
            if (this.dependencies == null) continue;
            this.dependencies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromDependencies(Predicate<MavenArtifactBuilder> predicate) {
        if (this.dependencies == null) {
            return (A)this;
        }
        Iterator<MavenArtifactBuilder> each = this.dependencies.iterator();
        List visitables = this._visitables.get((Object)"dependencies");
        while (each.hasNext()) {
            MavenArtifactBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<MavenArtifact> getDependencies() {
        return CamelLoaderFluentImpl.build(this.dependencies);
    }

    @Override
    public List<MavenArtifact> buildDependencies() {
        return CamelLoaderFluentImpl.build(this.dependencies);
    }

    @Override
    public MavenArtifact buildDependency(int index) {
        return this.dependencies.get(index).build();
    }

    @Override
    public MavenArtifact buildFirstDependency() {
        return this.dependencies.get(0).build();
    }

    @Override
    public MavenArtifact buildLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1).build();
    }

    @Override
    public MavenArtifact buildMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
        for (MavenArtifactBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
        for (MavenArtifactBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDependencies(List<MavenArtifact> dependencies) {
        if (this.dependencies != null) {
            this._visitables.get((Object)"dependencies").removeAll(this.dependencies);
        }
        if (dependencies != null) {
            this.dependencies = new ArrayList<MavenArtifactBuilder>();
            for (MavenArtifact item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)this;
    }

    @Override
    public A withDependencies(MavenArtifact ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
        }
        if (dependencies != null) {
            for (MavenArtifact item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    @Override
    public A addNewDependency(String artifactId, String groupId, String version) {
        return this.addToDependencies(new MavenArtifact(artifactId, groupId, version));
    }

    @Override
    public CamelLoaderFluent.DependenciesNested<A> addNewDependency() {
        return new DependenciesNestedImpl();
    }

    @Override
    public CamelLoaderFluent.DependenciesNested<A> addNewDependencyLike(MavenArtifact item) {
        return new DependenciesNestedImpl(-1, item);
    }

    @Override
    public CamelLoaderFluent.DependenciesNested<A> setNewDependencyLike(int index, MavenArtifact item) {
        return new DependenciesNestedImpl(index, item);
    }

    @Override
    public CamelLoaderFluent.DependenciesNested<A> editDependency(int index) {
        if (this.dependencies.size() <= index) {
            throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    @Override
    public CamelLoaderFluent.DependenciesNested<A> editFirstDependency() {
        if (this.dependencies.size() == 0) {
            throw new RuntimeException("Can't edit first dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(0, this.buildDependency(0));
    }

    @Override
    public CamelLoaderFluent.DependenciesNested<A> editLastDependency() {
        int index = this.dependencies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    @Override
    public CamelLoaderFluent.DependenciesNested<A> editMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dependencies.size(); ++i) {
            if (!predicate.test(this.dependencies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dependencies. No match found.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public A withGroupId(String groupId) {
        this.groupId = groupId;
        return (A)this;
    }

    @Override
    public Boolean hasGroupId() {
        return this.groupId != null;
    }

    @Override
    @Deprecated
    public A withNewGroupId(String arg0) {
        return this.withGroupId(new String(arg0));
    }

    @Override
    public A addToLanguages(int index, String item) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        this.languages.add(index, item);
        return (A)this;
    }

    @Override
    public A setToLanguages(int index, String item) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        this.languages.set(index, item);
        return (A)this;
    }

    @Override
    public A addToLanguages(String ... items) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        for (String item : items) {
            this.languages.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToLanguages(Collection<String> items) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        for (String item : items) {
            this.languages.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromLanguages(String ... items) {
        for (String item : items) {
            if (this.languages == null) continue;
            this.languages.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLanguages(Collection<String> items) {
        for (String item : items) {
            if (this.languages == null) continue;
            this.languages.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getLanguages() {
        return this.languages;
    }

    @Override
    public String getLanguage(int index) {
        return this.languages.get(index);
    }

    @Override
    public String getFirstLanguage() {
        return this.languages.get(0);
    }

    @Override
    public String getLastLanguage() {
        return this.languages.get(this.languages.size() - 1);
    }

    @Override
    public String getMatchingLanguage(Predicate<String> predicate) {
        for (String item : this.languages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLanguage(Predicate<String> predicate) {
        for (String item : this.languages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withLanguages(List<String> languages) {
        if (this.languages != null) {
            this._visitables.get((Object)"languages").removeAll(this.languages);
        }
        if (languages != null) {
            this.languages = new ArrayList<String>();
            for (String item : languages) {
                this.addToLanguages(item);
            }
        } else {
            this.languages = null;
        }
        return (A)this;
    }

    @Override
    public A withLanguages(String ... languages) {
        if (this.languages != null) {
            this.languages.clear();
        }
        if (languages != null) {
            for (String item : languages) {
                this.addToLanguages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLanguages() {
        return this.languages != null && !this.languages.isEmpty();
    }

    @Override
    public A addNewLanguage(String arg0) {
        return this.addToLanguages(new String(arg0));
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    @Deprecated
    public A withNewVersion(String arg0) {
        return this.withVersion(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CamelLoaderFluentImpl that = (CamelLoaderFluentImpl)o;
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        if (this.dependencies != null ? !this.dependencies.equals(that.dependencies) : that.dependencies != null) {
            return false;
        }
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        if (this.languages != null ? !this.languages.equals(that.languages) : that.languages != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.dependencies, this.groupId, this.languages, this.version, super.hashCode());
    }

    public class DependenciesNestedImpl<N>
    extends MavenArtifactFluentImpl<CamelLoaderFluent.DependenciesNested<N>>
    implements CamelLoaderFluent.DependenciesNested<N>,
    Nested<N> {
        private final MavenArtifactBuilder builder;
        private final int index;

        DependenciesNestedImpl(int index, MavenArtifact item) {
            this.index = index;
            this.builder = new MavenArtifactBuilder(this, item);
        }

        DependenciesNestedImpl() {
            this.index = -1;
            this.builder = new MavenArtifactBuilder(this);
        }

        @Override
        public N and() {
            return (N)CamelLoaderFluentImpl.this.setToDependencies(this.index, this.builder.build());
        }

        @Override
        public N endDependency() {
            return this.and();
        }
    }
}

