package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FailureRecoveryBuilder extends io.fabric8.camelk.v1.FailureRecoveryFluentImpl<io.fabric8.camelk.v1.FailureRecoveryBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.FailureRecovery,io.fabric8.camelk.v1.FailureRecoveryBuilder> {

    io.fabric8.camelk.v1.FailureRecoveryFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public FailureRecoveryBuilder() {
        this(true);
    }

    public FailureRecoveryBuilder(java.lang.Boolean validationEnabled) {
        this(new FailureRecovery(), validationEnabled);
    }

    public FailureRecoveryBuilder(io.fabric8.camelk.v1.FailureRecoveryFluent<?> fluent) {
        this(fluent, true);
    }

    public FailureRecoveryBuilder(io.fabric8.camelk.v1.FailureRecoveryFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new FailureRecovery(), validationEnabled);
    }

    public FailureRecoveryBuilder(io.fabric8.camelk.v1.FailureRecoveryFluent<?> fluent,io.fabric8.camelk.v1.FailureRecovery instance) {
        this(fluent, instance, true);
    }

    public FailureRecoveryBuilder(io.fabric8.camelk.v1.FailureRecoveryFluent<?> fluent,io.fabric8.camelk.v1.FailureRecovery instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAttempt(instance.getAttempt()); 
        fluent.withAttemptMax(instance.getAttemptMax()); 
        fluent.withAttemptTime(instance.getAttemptTime()); 
        this.validationEnabled = validationEnabled; 
    }

    public FailureRecoveryBuilder(io.fabric8.camelk.v1.FailureRecovery instance) {
        this(instance,true);
    }

    public FailureRecoveryBuilder(io.fabric8.camelk.v1.FailureRecovery instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAttempt(instance.getAttempt()); 
        this.withAttemptMax(instance.getAttemptMax()); 
        this.withAttemptTime(instance.getAttemptTime()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableFailureRecovery build() {
        EditableFailureRecovery buildable = new EditableFailureRecovery(fluent.getAttempt(),fluent.getAttemptMax(),fluent.getAttemptTime());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        FailureRecoveryBuilder that = (FailureRecoveryBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
