package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface CamelArtifactFluent<A extends io.fabric8.camelk.v1.CamelArtifactFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.String getArtifactId();
    public A withArtifactId(java.lang.String artifactId);
    public java.lang.Boolean hasArtifactId();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withArtifactId instead.
     */
        public A withNewArtifactId(java.lang.String arg0);
    public A addToDataformats(int index,java.lang.String item);
    public A setToDataformats(int index,java.lang.String item);
    public A addToDataformats(java.lang.String... items);
    public A addAllToDataformats(java.util.Collection<java.lang.String> items);
    public A removeFromDataformats(java.lang.String... items);
    public A removeAllFromDataformats(java.util.Collection<java.lang.String> items);
    public java.util.List<java.lang.String> getDataformats();
    public java.lang.String getDataformat(int index);
    public java.lang.String getFirstDataformat();
    public java.lang.String getLastDataformat();
    public java.lang.String getMatchingDataformat(java.util.function.Predicate<java.lang.String> predicate);
    public java.lang.Boolean hasMatchingDataformat(java.util.function.Predicate<java.lang.String> predicate);
    public A withDataformats(java.util.List<java.lang.String> dataformats);
    public A withDataformats(java.lang.String... dataformats);
    public java.lang.Boolean hasDataformats();
    public A addNewDataformat(java.lang.String arg0);
    public A addToDependencies(int index,io.fabric8.camelk.v1.CamelArtifactDependency item);
    public A setToDependencies(int index,io.fabric8.camelk.v1.CamelArtifactDependency item);
    public A addToDependencies(io.fabric8.camelk.v1.CamelArtifactDependency... items);
    public A addAllToDependencies(java.util.Collection<io.fabric8.camelk.v1.CamelArtifactDependency> items);
    public A removeFromDependencies(io.fabric8.camelk.v1.CamelArtifactDependency... items);
    public A removeAllFromDependencies(java.util.Collection<io.fabric8.camelk.v1.CamelArtifactDependency> items);
    public A removeMatchingFromDependencies(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildDependencies instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.camelk.v1.CamelArtifactDependency> getDependencies();
    public java.util.List<io.fabric8.camelk.v1.CamelArtifactDependency> buildDependencies();
    public io.fabric8.camelk.v1.CamelArtifactDependency buildDependency(int index);
    public io.fabric8.camelk.v1.CamelArtifactDependency buildFirstDependency();
    public io.fabric8.camelk.v1.CamelArtifactDependency buildLastDependency();
    public io.fabric8.camelk.v1.CamelArtifactDependency buildMatchingDependency(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder> predicate);
    public java.lang.Boolean hasMatchingDependency(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder> predicate);
    public A withDependencies(java.util.List<io.fabric8.camelk.v1.CamelArtifactDependency> dependencies);
    public A withDependencies(io.fabric8.camelk.v1.CamelArtifactDependency... dependencies);
    public java.lang.Boolean hasDependencies();
    public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> addNewDependency();
    public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> addNewDependencyLike(io.fabric8.camelk.v1.CamelArtifactDependency item);
    public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> setNewDependencyLike(int index,io.fabric8.camelk.v1.CamelArtifactDependency item);
    public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> editDependency(int index);
    public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> editFirstDependency();
    public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> editLastDependency();
    public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> editMatchingDependency(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactDependencyBuilder> predicate);
    public A addToExclusions(int index,io.fabric8.camelk.v1.CamelArtifactExclusion item);
    public A setToExclusions(int index,io.fabric8.camelk.v1.CamelArtifactExclusion item);
    public A addToExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... items);
    public A addAllToExclusions(java.util.Collection<io.fabric8.camelk.v1.CamelArtifactExclusion> items);
    public A removeFromExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... items);
    public A removeAllFromExclusions(java.util.Collection<io.fabric8.camelk.v1.CamelArtifactExclusion> items);
    public A removeMatchingFromExclusions(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildExclusions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.camelk.v1.CamelArtifactExclusion> getExclusions();
    public java.util.List<io.fabric8.camelk.v1.CamelArtifactExclusion> buildExclusions();
    public io.fabric8.camelk.v1.CamelArtifactExclusion buildExclusion(int index);
    public io.fabric8.camelk.v1.CamelArtifactExclusion buildFirstExclusion();
    public io.fabric8.camelk.v1.CamelArtifactExclusion buildLastExclusion();
    public io.fabric8.camelk.v1.CamelArtifactExclusion buildMatchingExclusion(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> predicate);
    public java.lang.Boolean hasMatchingExclusion(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> predicate);
    public A withExclusions(java.util.List<io.fabric8.camelk.v1.CamelArtifactExclusion> exclusions);
    public A withExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... exclusions);
    public java.lang.Boolean hasExclusions();
    public A addNewExclusion(java.lang.String artifactId,java.lang.String groupId);
    public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> addNewExclusion();
    public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> addNewExclusionLike(io.fabric8.camelk.v1.CamelArtifactExclusion item);
    public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> setNewExclusionLike(int index,io.fabric8.camelk.v1.CamelArtifactExclusion item);
    public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> editExclusion(int index);
    public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> editFirstExclusion();
    public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> editLastExclusion();
    public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> editMatchingExclusion(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> predicate);
    public java.lang.String getGroupId();
    public A withGroupId(java.lang.String groupId);
    public java.lang.Boolean hasGroupId();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withGroupId instead.
     */
        public A withNewGroupId(java.lang.String arg0);
    public A addToJavaTypes(int index,java.lang.String item);
    public A setToJavaTypes(int index,java.lang.String item);
    public A addToJavaTypes(java.lang.String... items);
    public A addAllToJavaTypes(java.util.Collection<java.lang.String> items);
    public A removeFromJavaTypes(java.lang.String... items);
    public A removeAllFromJavaTypes(java.util.Collection<java.lang.String> items);
    public java.util.List<java.lang.String> getJavaTypes();
    public java.lang.String getJavaType(int index);
    public java.lang.String getFirstJavaType();
    public java.lang.String getLastJavaType();
    public java.lang.String getMatchingJavaType(java.util.function.Predicate<java.lang.String> predicate);
    public java.lang.Boolean hasMatchingJavaType(java.util.function.Predicate<java.lang.String> predicate);
    public A withJavaTypes(java.util.List<java.lang.String> javaTypes);
    public A withJavaTypes(java.lang.String... javaTypes);
    public java.lang.Boolean hasJavaTypes();
    public A addNewJavaType(java.lang.String arg0);
    public A addToLanguages(int index,java.lang.String item);
    public A setToLanguages(int index,java.lang.String item);
    public A addToLanguages(java.lang.String... items);
    public A addAllToLanguages(java.util.Collection<java.lang.String> items);
    public A removeFromLanguages(java.lang.String... items);
    public A removeAllFromLanguages(java.util.Collection<java.lang.String> items);
    public java.util.List<java.lang.String> getLanguages();
    public java.lang.String getLanguage(int index);
    public java.lang.String getFirstLanguage();
    public java.lang.String getLastLanguage();
    public java.lang.String getMatchingLanguage(java.util.function.Predicate<java.lang.String> predicate);
    public java.lang.Boolean hasMatchingLanguage(java.util.function.Predicate<java.lang.String> predicate);
    public A withLanguages(java.util.List<java.lang.String> languages);
    public A withLanguages(java.lang.String... languages);
    public java.lang.Boolean hasLanguages();
    public A addNewLanguage(java.lang.String arg0);
    public A addToSchemes(int index,io.fabric8.camelk.v1.CamelScheme item);
    public A setToSchemes(int index,io.fabric8.camelk.v1.CamelScheme item);
    public A addToSchemes(io.fabric8.camelk.v1.CamelScheme... items);
    public A addAllToSchemes(java.util.Collection<io.fabric8.camelk.v1.CamelScheme> items);
    public A removeFromSchemes(io.fabric8.camelk.v1.CamelScheme... items);
    public A removeAllFromSchemes(java.util.Collection<io.fabric8.camelk.v1.CamelScheme> items);
    public A removeMatchingFromSchemes(java.util.function.Predicate<io.fabric8.camelk.v1.CamelSchemeBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSchemes instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.camelk.v1.CamelScheme> getSchemes();
    public java.util.List<io.fabric8.camelk.v1.CamelScheme> buildSchemes();
    public io.fabric8.camelk.v1.CamelScheme buildScheme(int index);
    public io.fabric8.camelk.v1.CamelScheme buildFirstScheme();
    public io.fabric8.camelk.v1.CamelScheme buildLastScheme();
    public io.fabric8.camelk.v1.CamelScheme buildMatchingScheme(java.util.function.Predicate<io.fabric8.camelk.v1.CamelSchemeBuilder> predicate);
    public java.lang.Boolean hasMatchingScheme(java.util.function.Predicate<io.fabric8.camelk.v1.CamelSchemeBuilder> predicate);
    public A withSchemes(java.util.List<io.fabric8.camelk.v1.CamelScheme> schemes);
    public A withSchemes(io.fabric8.camelk.v1.CamelScheme... schemes);
    public java.lang.Boolean hasSchemes();
    public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> addNewScheme();
    public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> addNewSchemeLike(io.fabric8.camelk.v1.CamelScheme item);
    public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> setNewSchemeLike(int index,io.fabric8.camelk.v1.CamelScheme item);
    public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> editScheme(int index);
    public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> editFirstScheme();
    public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> editLastScheme();
    public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> editMatchingScheme(java.util.function.Predicate<io.fabric8.camelk.v1.CamelSchemeBuilder> predicate);
    public java.lang.String getVersion();
    public A withVersion(java.lang.String version);
    public java.lang.Boolean hasVersion();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withVersion instead.
     */
        public A withNewVersion(java.lang.String arg0);
    public interface DependenciesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.camelk.v1.CamelArtifactDependencyFluent<io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<N>> {

            public N and();
            public N endDependency();    }


    public interface ExclusionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.camelk.v1.CamelArtifactExclusionFluent<io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<N>> {

            public N and();
            public N endExclusion();    }


    public interface SchemesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.camelk.v1.CamelSchemeFluent<io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<N>> {

            public N and();
            public N endScheme();    }


}
