
package io.fabric8.camelk.v1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "affinity",
    "baseImage",
    "buildDir",
    "dependencies",
    "image",
    "maven",
    "meta",
    "name",
    "properties",
    "resources",
    "runtime",
    "sources",
    "steps",
    "timeout",
    "volumeMounts",
    "volumes"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectMeta.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.Volume.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.VolumeMount.class)
})
public class BuilderTask implements KubernetesResource
{

    @JsonProperty("affinity")
    private Affinity affinity;
    @JsonProperty("baseImage")
    private java.lang.String baseImage;
    @JsonProperty("buildDir")
    private java.lang.String buildDir;
    @JsonProperty("dependencies")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<java.lang.String> dependencies = new ArrayList<java.lang.String>();
    @JsonProperty("image")
    private java.lang.String image;
    @JsonProperty("maven")
    private MavenSpec maven;
    @JsonProperty("meta")
    private io.fabric8.kubernetes.api.model.ObjectMeta meta;
    @JsonProperty("name")
    private java.lang.String name;
    @JsonProperty("properties")
    private Map<String, String> properties;
    @JsonProperty("resources")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<ResourceSpec> resources = new ArrayList<ResourceSpec>();
    @JsonProperty("runtime")
    private RuntimeSpec runtime;
    @JsonProperty("sources")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<SourceSpec> sources = new ArrayList<SourceSpec>();
    @JsonProperty("steps")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<java.lang.String> steps = new ArrayList<java.lang.String>();
    @JsonProperty("timeout")
    private Duration timeout;
    @JsonProperty("volumeMounts")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<io.fabric8.kubernetes.api.model.VolumeMount> volumeMounts = new ArrayList<io.fabric8.kubernetes.api.model.VolumeMount>();
    @JsonProperty("volumes")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<io.fabric8.kubernetes.api.model.Volume> volumes = new ArrayList<io.fabric8.kubernetes.api.model.Volume>();
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public BuilderTask() {
    }

    /**
     * 
     * @param image
     * @param sources
     * @param buildDir
     * @param maven
     * @param baseImage
     * @param volumes
     * @param resources
     * @param runtime
     * @param steps
     * @param timeout
     * @param dependencies
     * @param volumeMounts
     * @param meta
     * @param name
     * @param properties
     * @param affinity
     */
    public BuilderTask(Affinity affinity, java.lang.String baseImage, java.lang.String buildDir, List<java.lang.String> dependencies, java.lang.String image, MavenSpec maven, io.fabric8.kubernetes.api.model.ObjectMeta meta, java.lang.String name, Map<String, String> properties, List<ResourceSpec> resources, RuntimeSpec runtime, List<SourceSpec> sources, List<java.lang.String> steps, Duration timeout, List<io.fabric8.kubernetes.api.model.VolumeMount> volumeMounts, List<io.fabric8.kubernetes.api.model.Volume> volumes) {
        super();
        this.affinity = affinity;
        this.baseImage = baseImage;
        this.buildDir = buildDir;
        this.dependencies = dependencies;
        this.image = image;
        this.maven = maven;
        this.meta = meta;
        this.name = name;
        this.properties = properties;
        this.resources = resources;
        this.runtime = runtime;
        this.sources = sources;
        this.steps = steps;
        this.timeout = timeout;
        this.volumeMounts = volumeMounts;
        this.volumes = volumes;
    }

    @JsonProperty("affinity")
    public Affinity getAffinity() {
        return affinity;
    }

    @JsonProperty("affinity")
    public void setAffinity(Affinity affinity) {
        this.affinity = affinity;
    }

    @JsonProperty("baseImage")
    public java.lang.String getBaseImage() {
        return baseImage;
    }

    @JsonProperty("baseImage")
    public void setBaseImage(java.lang.String baseImage) {
        this.baseImage = baseImage;
    }

    @JsonProperty("buildDir")
    public java.lang.String getBuildDir() {
        return buildDir;
    }

    @JsonProperty("buildDir")
    public void setBuildDir(java.lang.String buildDir) {
        this.buildDir = buildDir;
    }

    @JsonProperty("dependencies")
    public List<java.lang.String> getDependencies() {
        return dependencies;
    }

    @JsonProperty("dependencies")
    public void setDependencies(List<java.lang.String> dependencies) {
        this.dependencies = dependencies;
    }

    @JsonProperty("image")
    public java.lang.String getImage() {
        return image;
    }

    @JsonProperty("image")
    public void setImage(java.lang.String image) {
        this.image = image;
    }

    @JsonProperty("maven")
    public MavenSpec getMaven() {
        return maven;
    }

    @JsonProperty("maven")
    public void setMaven(MavenSpec maven) {
        this.maven = maven;
    }

    @JsonProperty("meta")
    public io.fabric8.kubernetes.api.model.ObjectMeta getMeta() {
        return meta;
    }

    @JsonProperty("meta")
    public void setMeta(io.fabric8.kubernetes.api.model.ObjectMeta meta) {
        this.meta = meta;
    }

    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    @JsonProperty("properties")
    public Map<String, String> getProperties() {
        return properties;
    }

    @JsonProperty("properties")
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @JsonProperty("resources")
    public List<ResourceSpec> getResources() {
        return resources;
    }

    @JsonProperty("resources")
    public void setResources(List<ResourceSpec> resources) {
        this.resources = resources;
    }

    @JsonProperty("runtime")
    public RuntimeSpec getRuntime() {
        return runtime;
    }

    @JsonProperty("runtime")
    public void setRuntime(RuntimeSpec runtime) {
        this.runtime = runtime;
    }

    @JsonProperty("sources")
    public List<SourceSpec> getSources() {
        return sources;
    }

    @JsonProperty("sources")
    public void setSources(List<SourceSpec> sources) {
        this.sources = sources;
    }

    @JsonProperty("steps")
    public List<java.lang.String> getSteps() {
        return steps;
    }

    @JsonProperty("steps")
    public void setSteps(List<java.lang.String> steps) {
        this.steps = steps;
    }

    @JsonProperty("timeout")
    public Duration getTimeout() {
        return timeout;
    }

    @JsonProperty("timeout")
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @JsonProperty("volumeMounts")
    public List<io.fabric8.kubernetes.api.model.VolumeMount> getVolumeMounts() {
        return volumeMounts;
    }

    @JsonProperty("volumeMounts")
    public void setVolumeMounts(List<io.fabric8.kubernetes.api.model.VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    @JsonProperty("volumes")
    public List<io.fabric8.kubernetes.api.model.Volume> getVolumes() {
        return volumes;
    }

    @JsonProperty("volumes")
    public void setVolumes(List<io.fabric8.kubernetes.api.model.Volume> volumes) {
        this.volumes = volumes;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
