package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationKitConditionBuilder extends io.fabric8.camelk.v1.IntegrationKitConditionFluentImpl<io.fabric8.camelk.v1.IntegrationKitConditionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.IntegrationKitCondition,io.fabric8.camelk.v1.IntegrationKitConditionBuilder> {

    io.fabric8.camelk.v1.IntegrationKitConditionFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IntegrationKitConditionBuilder() {
        this(true);
    }

    public IntegrationKitConditionBuilder(java.lang.Boolean validationEnabled) {
        this(new IntegrationKitCondition(), validationEnabled);
    }

    public IntegrationKitConditionBuilder(io.fabric8.camelk.v1.IntegrationKitConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationKitConditionBuilder(io.fabric8.camelk.v1.IntegrationKitConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IntegrationKitCondition(), validationEnabled);
    }

    public IntegrationKitConditionBuilder(io.fabric8.camelk.v1.IntegrationKitConditionFluent<?> fluent,io.fabric8.camelk.v1.IntegrationKitCondition instance) {
        this(fluent, instance, true);
    }

    public IntegrationKitConditionBuilder(io.fabric8.camelk.v1.IntegrationKitConditionFluent<?> fluent,io.fabric8.camelk.v1.IntegrationKitCondition instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationKitConditionBuilder(io.fabric8.camelk.v1.IntegrationKitCondition instance) {
        this(instance,true);
    }

    public IntegrationKitConditionBuilder(io.fabric8.camelk.v1.IntegrationKitCondition instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withLastUpdateTime(instance.getLastUpdateTime()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationKitCondition build() {
        EditableIntegrationKitCondition buildable = new EditableIntegrationKitCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationKitConditionBuilder that = (IntegrationKitConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
