package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class BuildStatusFluentImpl<A extends io.fabric8.camelk.v1.BuildStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.camelk.v1.BuildStatusFluent<A> {

    private java.util.List<io.fabric8.camelk.v1.ArtifactBuilder> artifacts;
    private java.lang.String baseImage;
    private java.util.List<io.fabric8.camelk.v1.BuildConditionBuilder> conditions;
    private java.lang.String digest;
    private java.lang.String duration;
    private java.lang.String error;
    private io.fabric8.camelk.v1.FailureBuilder failure;
    private java.lang.String image;
    private java.lang.String phase;
    private java.lang.String platform;
    private java.lang.String startedAt;

    public BuildStatusFluentImpl() {
    }

    public BuildStatusFluentImpl(io.fabric8.camelk.v1.BuildStatus instance) {
        this.withArtifacts(instance.getArtifacts()); 
        this.withBaseImage(instance.getBaseImage()); 
        this.withConditions(instance.getConditions()); 
        this.withDigest(instance.getDigest()); 
        this.withDuration(instance.getDuration()); 
        this.withError(instance.getError()); 
        this.withFailure(instance.getFailure()); 
        this.withImage(instance.getImage()); 
        this.withPhase(instance.getPhase()); 
        this.withPlatform(instance.getPlatform()); 
        this.withStartedAt(instance.getStartedAt()); 
    }

    public A addToArtifacts(int index,io.fabric8.camelk.v1.Artifact item) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.camelk.v1.ArtifactBuilder>();}
        io.fabric8.camelk.v1.ArtifactBuilder builder = new io.fabric8.camelk.v1.ArtifactBuilder(item);_visitables.get("artifacts").add(index >= 0 ? index : _visitables.get("artifacts").size(), builder);this.artifacts.add(index >= 0 ? index : artifacts.size(), builder); return (A)this;
    }

    public A setToArtifacts(int index,io.fabric8.camelk.v1.Artifact item) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.camelk.v1.ArtifactBuilder>();}
        io.fabric8.camelk.v1.ArtifactBuilder builder = new io.fabric8.camelk.v1.ArtifactBuilder(item);
        if (index < 0 || index >= _visitables.get("artifacts").size()) { _visitables.get("artifacts").add(builder); } else { _visitables.get("artifacts").set(index, builder);}
        if (index < 0 || index >= artifacts.size()) { artifacts.add(builder); } else { artifacts.set(index, builder);}
         return (A)this;
    }

    public A addToArtifacts(io.fabric8.camelk.v1.Artifact... items) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.camelk.v1.ArtifactBuilder>();}
        for (io.fabric8.camelk.v1.Artifact item : items) {io.fabric8.camelk.v1.ArtifactBuilder builder = new io.fabric8.camelk.v1.ArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A addAllToArtifacts(java.util.Collection<io.fabric8.camelk.v1.Artifact> items) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.camelk.v1.ArtifactBuilder>();}
        for (io.fabric8.camelk.v1.Artifact item : items) {io.fabric8.camelk.v1.ArtifactBuilder builder = new io.fabric8.camelk.v1.ArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A removeFromArtifacts(io.fabric8.camelk.v1.Artifact... items) {
        for (io.fabric8.camelk.v1.Artifact item : items) {io.fabric8.camelk.v1.ArtifactBuilder builder = new io.fabric8.camelk.v1.ArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeAllFromArtifacts(java.util.Collection<io.fabric8.camelk.v1.Artifact> items) {
        for (io.fabric8.camelk.v1.Artifact item : items) {io.fabric8.camelk.v1.ArtifactBuilder builder = new io.fabric8.camelk.v1.ArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromArtifacts(java.util.function.Predicate<io.fabric8.camelk.v1.ArtifactBuilder> predicate) {
        if (artifacts == null) return (A) this;
        final Iterator<io.fabric8.camelk.v1.ArtifactBuilder> each = artifacts.iterator();
        final List visitables = _visitables.get("artifacts");
        while (each.hasNext()) {
          io.fabric8.camelk.v1.ArtifactBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildArtifacts instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.camelk.v1.Artifact> getArtifacts() {
        return build(artifacts);
    }

    public java.util.List<io.fabric8.camelk.v1.Artifact> buildArtifacts() {
        return build(artifacts);
    }

    public io.fabric8.camelk.v1.Artifact buildArtifact(int index) {
        return this.artifacts.get(index).build();
    }

    public io.fabric8.camelk.v1.Artifact buildFirstArtifact() {
        return this.artifacts.get(0).build();
    }

    public io.fabric8.camelk.v1.Artifact buildLastArtifact() {
        return this.artifacts.get(artifacts.size() - 1).build();
    }

    public io.fabric8.camelk.v1.Artifact buildMatchingArtifact(java.util.function.Predicate<io.fabric8.camelk.v1.ArtifactBuilder> predicate) {
        for (io.fabric8.camelk.v1.ArtifactBuilder item: artifacts) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingArtifact(java.util.function.Predicate<io.fabric8.camelk.v1.ArtifactBuilder> predicate) {
        for (io.fabric8.camelk.v1.ArtifactBuilder item: artifacts) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withArtifacts(java.util.List<io.fabric8.camelk.v1.Artifact> artifacts) {
        if (this.artifacts != null) { _visitables.get("artifacts").removeAll(this.artifacts);}
        if (artifacts != null) {this.artifacts = new java.util.ArrayList<io.fabric8.camelk.v1.ArtifactBuilder>(); for (io.fabric8.camelk.v1.Artifact item : artifacts){this.addToArtifacts(item);}} else { this.artifacts = null;} return (A) this;
    }

    public A withArtifacts(io.fabric8.camelk.v1.Artifact... artifacts) {
        if (this.artifacts != null) {this.artifacts.clear();}
        if (artifacts != null) {for (io.fabric8.camelk.v1.Artifact item :artifacts){ this.addToArtifacts(item);}} return (A) this;
    }

    public java.lang.Boolean hasArtifacts() {
        return artifacts != null && !artifacts.isEmpty();
    }

    public A addNewArtifact(java.lang.String checksum,java.lang.String id,java.lang.String location,java.lang.String target) {
        return (A)addToArtifacts(new Artifact(checksum, id, location, target));
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.ArtifactsNested<A> addNewArtifact() {
        return new io.fabric8.camelk.v1.BuildStatusFluentImpl.ArtifactsNestedImpl();
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.ArtifactsNested<A> addNewArtifactLike(io.fabric8.camelk.v1.Artifact item) {
        return new io.fabric8.camelk.v1.BuildStatusFluentImpl.ArtifactsNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.ArtifactsNested<A> setNewArtifactLike(int index,io.fabric8.camelk.v1.Artifact item) {
        return new io.fabric8.camelk.v1.BuildStatusFluentImpl.ArtifactsNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.ArtifactsNested<A> editArtifact(int index) {
        if (artifacts.size() <= index) throw new RuntimeException("Can't edit artifacts. Index exceeds size.");
        return setNewArtifactLike(index, buildArtifact(index));
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.ArtifactsNested<A> editFirstArtifact() {
        if (artifacts.size() == 0) throw new RuntimeException("Can't edit first artifacts. The list is empty.");
        return setNewArtifactLike(0, buildArtifact(0));
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.ArtifactsNested<A> editLastArtifact() {
        int index = artifacts.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last artifacts. The list is empty.");
        return setNewArtifactLike(index, buildArtifact(index));
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.ArtifactsNested<A> editMatchingArtifact(java.util.function.Predicate<io.fabric8.camelk.v1.ArtifactBuilder> predicate) {
        int index = -1;
        for (int i=0;i<artifacts.size();i++) { 
        if (predicate.test(artifacts.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching artifacts. No match found.");
        return setNewArtifactLike(index, buildArtifact(index));
    }

    public java.lang.String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(java.lang.String baseImage) {
        this.baseImage=baseImage; return (A) this;
    }

    public java.lang.Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withBaseImage instead.
     */
        public A withNewBaseImage(java.lang.String arg0) {
        return (A)withBaseImage(new String(arg0));
    }

    public A addToConditions(int index,io.fabric8.camelk.v1.BuildCondition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.BuildConditionBuilder>();}
        io.fabric8.camelk.v1.BuildConditionBuilder builder = new io.fabric8.camelk.v1.BuildConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.fabric8.camelk.v1.BuildCondition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.BuildConditionBuilder>();}
        io.fabric8.camelk.v1.BuildConditionBuilder builder = new io.fabric8.camelk.v1.BuildConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(io.fabric8.camelk.v1.BuildCondition... items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.BuildConditionBuilder>();}
        for (io.fabric8.camelk.v1.BuildCondition item : items) {io.fabric8.camelk.v1.BuildConditionBuilder builder = new io.fabric8.camelk.v1.BuildConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(java.util.Collection<io.fabric8.camelk.v1.BuildCondition> items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.BuildConditionBuilder>();}
        for (io.fabric8.camelk.v1.BuildCondition item : items) {io.fabric8.camelk.v1.BuildConditionBuilder builder = new io.fabric8.camelk.v1.BuildConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.camelk.v1.BuildCondition... items) {
        for (io.fabric8.camelk.v1.BuildCondition item : items) {io.fabric8.camelk.v1.BuildConditionBuilder builder = new io.fabric8.camelk.v1.BuildConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(java.util.Collection<io.fabric8.camelk.v1.BuildCondition> items) {
        for (io.fabric8.camelk.v1.BuildCondition item : items) {io.fabric8.camelk.v1.BuildConditionBuilder builder = new io.fabric8.camelk.v1.BuildConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.camelk.v1.BuildConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<io.fabric8.camelk.v1.BuildConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          io.fabric8.camelk.v1.BuildConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConditions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.camelk.v1.BuildCondition> getConditions() {
        return build(conditions);
    }

    public java.util.List<io.fabric8.camelk.v1.BuildCondition> buildConditions() {
        return build(conditions);
    }

    public io.fabric8.camelk.v1.BuildCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public io.fabric8.camelk.v1.BuildCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public io.fabric8.camelk.v1.BuildCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public io.fabric8.camelk.v1.BuildCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.camelk.v1.BuildConditionBuilder> predicate) {
        for (io.fabric8.camelk.v1.BuildConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.camelk.v1.BuildConditionBuilder> predicate) {
        for (io.fabric8.camelk.v1.BuildConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(java.util.List<io.fabric8.camelk.v1.BuildCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.BuildConditionBuilder>(); for (io.fabric8.camelk.v1.BuildCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.camelk.v1.BuildCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.camelk.v1.BuildCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public java.lang.Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.ConditionsNested<A> addNewCondition() {
        return new io.fabric8.camelk.v1.BuildStatusFluentImpl.ConditionsNestedImpl();
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.camelk.v1.BuildCondition item) {
        return new io.fabric8.camelk.v1.BuildStatusFluentImpl.ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.camelk.v1.BuildCondition item) {
        return new io.fabric8.camelk.v1.BuildStatusFluentImpl.ConditionsNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.camelk.v1.BuildConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public java.lang.String getDigest() {
        return this.digest;
    }

    public A withDigest(java.lang.String digest) {
        this.digest=digest; return (A) this;
    }

    public java.lang.Boolean hasDigest() {
        return this.digest != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withDigest instead.
     */
        public A withNewDigest(java.lang.String arg0) {
        return (A)withDigest(new String(arg0));
    }

    public java.lang.String getDuration() {
        return this.duration;
    }

    public A withDuration(java.lang.String duration) {
        this.duration=duration; return (A) this;
    }

    public java.lang.Boolean hasDuration() {
        return this.duration != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withDuration instead.
     */
        public A withNewDuration(java.lang.String arg0) {
        return (A)withDuration(new String(arg0));
    }

    public java.lang.String getError() {
        return this.error;
    }

    public A withError(java.lang.String error) {
        this.error=error; return (A) this;
    }

    public java.lang.Boolean hasError() {
        return this.error != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withError instead.
     */
        public A withNewError(java.lang.String arg0) {
        return (A)withError(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildFailure instead.
     * @return The buildable object.
     */
        public io.fabric8.camelk.v1.Failure getFailure() {
        return this.failure!=null?this.failure.build():null;
    }

    public io.fabric8.camelk.v1.Failure buildFailure() {
        return this.failure!=null?this.failure.build():null;
    }

    public A withFailure(io.fabric8.camelk.v1.Failure failure) {
        _visitables.get("failure").remove(this.failure);
        if (failure!=null){ this.failure= new io.fabric8.camelk.v1.FailureBuilder(failure); _visitables.get("failure").add(this.failure);} return (A) this;
    }

    public java.lang.Boolean hasFailure() {
        return this.failure != null;
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.FailureNested<A> withNewFailure() {
        return new io.fabric8.camelk.v1.BuildStatusFluentImpl.FailureNestedImpl();
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.FailureNested<A> withNewFailureLike(io.fabric8.camelk.v1.Failure item) {
        return new io.fabric8.camelk.v1.BuildStatusFluentImpl.FailureNestedImpl(item);
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.FailureNested<A> editFailure() {
        return withNewFailureLike(getFailure());
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.FailureNested<A> editOrNewFailure() {
        return withNewFailureLike(getFailure() != null ? getFailure(): new io.fabric8.camelk.v1.FailureBuilder().build());
    }

    public io.fabric8.camelk.v1.BuildStatusFluent.FailureNested<A> editOrNewFailureLike(io.fabric8.camelk.v1.Failure item) {
        return withNewFailureLike(getFailure() != null ? getFailure(): item);
    }

    public java.lang.String getImage() {
        return this.image;
    }

    public A withImage(java.lang.String image) {
        this.image=image; return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String arg0) {
        return (A)withImage(new String(arg0));
    }

    public java.lang.String getPhase() {
        return this.phase;
    }

    public A withPhase(java.lang.String phase) {
        this.phase=phase; return (A) this;
    }

    public java.lang.Boolean hasPhase() {
        return this.phase != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPhase instead.
     */
        public A withNewPhase(java.lang.String arg0) {
        return (A)withPhase(new String(arg0));
    }

    public java.lang.String getPlatform() {
        return this.platform;
    }

    public A withPlatform(java.lang.String platform) {
        this.platform=platform; return (A) this;
    }

    public java.lang.Boolean hasPlatform() {
        return this.platform != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPlatform instead.
     */
        public A withNewPlatform(java.lang.String arg0) {
        return (A)withPlatform(new String(arg0));
    }

    public java.lang.String getStartedAt() {
        return this.startedAt;
    }

    public A withStartedAt(java.lang.String startedAt) {
        this.startedAt=startedAt; return (A) this;
    }

    public java.lang.Boolean hasStartedAt() {
        return this.startedAt != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withStartedAt instead.
     */
        public A withNewStartedAt(java.lang.String arg0) {
        return (A)withStartedAt(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BuildStatusFluentImpl that = (BuildStatusFluentImpl) o;
        if (artifacts != null ? !artifacts.equals(that.artifacts) :that.artifacts != null) return false;
        if (baseImage != null ? !baseImage.equals(that.baseImage) :that.baseImage != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (digest != null ? !digest.equals(that.digest) :that.digest != null) return false;
        if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
        if (error != null ? !error.equals(that.error) :that.error != null) return false;
        if (failure != null ? !failure.equals(that.failure) :that.failure != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        if (platform != null ? !platform.equals(that.platform) :that.platform != null) return false;
        if (startedAt != null ? !startedAt.equals(that.startedAt) :that.startedAt != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(artifacts,  baseImage,  conditions,  digest,  duration,  error,  failure,  image,  phase,  platform,  startedAt,  super.hashCode());
    }

    public class ArtifactsNestedImpl<N> extends io.fabric8.camelk.v1.ArtifactFluentImpl<io.fabric8.camelk.v1.BuildStatusFluent.ArtifactsNested<N>> implements io.fabric8.camelk.v1.BuildStatusFluent.ArtifactsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.ArtifactBuilder builder;
        private final int index;

            ArtifactsNestedImpl(int index,io.fabric8.camelk.v1.Artifact item) {
                this.index = index;
                this.builder = new io.fabric8.camelk.v1.ArtifactBuilder(this, item);
                        
            }

            ArtifactsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.camelk.v1.ArtifactBuilder(this);
                        
            }

            public N and() {
                return (N) BuildStatusFluentImpl.this.setToArtifacts(index,builder.build());
            }

            public N endArtifact() {
                return and();
            }
    }


    public class ConditionsNestedImpl<N> extends io.fabric8.camelk.v1.BuildConditionFluentImpl<io.fabric8.camelk.v1.BuildStatusFluent.ConditionsNested<N>> implements io.fabric8.camelk.v1.BuildStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.BuildConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,io.fabric8.camelk.v1.BuildCondition item) {
                this.index = index;
                this.builder = new io.fabric8.camelk.v1.BuildConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.camelk.v1.BuildConditionBuilder(this);
                        
            }

            public N and() {
                return (N) BuildStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class FailureNestedImpl<N> extends io.fabric8.camelk.v1.FailureFluentImpl<io.fabric8.camelk.v1.BuildStatusFluent.FailureNested<N>> implements io.fabric8.camelk.v1.BuildStatusFluent.FailureNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.FailureBuilder builder;

            FailureNestedImpl(io.fabric8.camelk.v1.Failure item) {
                this.builder = new io.fabric8.camelk.v1.FailureBuilder(this, item);
                        
            }

            FailureNestedImpl() {
                this.builder = new io.fabric8.camelk.v1.FailureBuilder(this);
                        
            }

            public N and() {
                return (N) BuildStatusFluentImpl.this.withFailure(builder.build());
            }

            public N endFailure() {
                return and();
            }
    }


}
