/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.IntegrationPlatform;
import io.fabric8.camelk.v1.IntegrationPlatformBuilder;
import io.fabric8.camelk.v1.IntegrationPlatformFluentImpl;
import io.fabric8.camelk.v1.IntegrationPlatformList;
import io.fabric8.camelk.v1.IntegrationPlatformListFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IntegrationPlatformListFluentImpl<A extends IntegrationPlatformListFluent<A>>
extends BaseFluent<A>
implements IntegrationPlatformListFluent<A> {
    private String apiVersion;
    private List<IntegrationPlatformBuilder> items;
    private String kind;
    private ListMeta metadata;

    public IntegrationPlatformListFluentImpl() {
    }

    public IntegrationPlatformListFluentImpl(IntegrationPlatformList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(int index, IntegrationPlatform item) {
        if (this.items == null) {
            this.items = new ArrayList<IntegrationPlatformBuilder>();
        }
        IntegrationPlatformBuilder builder = new IntegrationPlatformBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, IntegrationPlatform item) {
        if (this.items == null) {
            this.items = new ArrayList<IntegrationPlatformBuilder>();
        }
        IntegrationPlatformBuilder builder = new IntegrationPlatformBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(IntegrationPlatform ... items) {
        if (this.items == null) {
            this.items = new ArrayList<IntegrationPlatformBuilder>();
        }
        for (IntegrationPlatform item : items) {
            IntegrationPlatformBuilder builder = new IntegrationPlatformBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<IntegrationPlatform> items) {
        if (this.items == null) {
            this.items = new ArrayList<IntegrationPlatformBuilder>();
        }
        for (IntegrationPlatform item : items) {
            IntegrationPlatformBuilder builder = new IntegrationPlatformBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(IntegrationPlatform ... items) {
        for (IntegrationPlatform item : items) {
            IntegrationPlatformBuilder builder = new IntegrationPlatformBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<IntegrationPlatform> items) {
        for (IntegrationPlatform item : items) {
            IntegrationPlatformBuilder builder = new IntegrationPlatformBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<IntegrationPlatformBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<IntegrationPlatformBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            IntegrationPlatformBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IntegrationPlatform> getItems() {
        return IntegrationPlatformListFluentImpl.build(this.items);
    }

    @Override
    public List<IntegrationPlatform> buildItems() {
        return IntegrationPlatformListFluentImpl.build(this.items);
    }

    @Override
    public IntegrationPlatform buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public IntegrationPlatform buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public IntegrationPlatform buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public IntegrationPlatform buildMatchingItem(Predicate<IntegrationPlatformBuilder> predicate) {
        for (IntegrationPlatformBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<IntegrationPlatformBuilder> predicate) {
        for (IntegrationPlatformBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<IntegrationPlatform> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<IntegrationPlatformBuilder>();
            for (IntegrationPlatform item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(IntegrationPlatform ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (IntegrationPlatform item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public IntegrationPlatformListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public IntegrationPlatformListFluent.ItemsNested<A> addNewItemLike(IntegrationPlatform item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public IntegrationPlatformListFluent.ItemsNested<A> setNewItemLike(int index, IntegrationPlatform item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public IntegrationPlatformListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public IntegrationPlatformListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public IntegrationPlatformListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public IntegrationPlatformListFluent.ItemsNested<A> editMatchingItem(Predicate<IntegrationPlatformBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationPlatformListFluentImpl that = (IntegrationPlatformListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends IntegrationPlatformFluentImpl<IntegrationPlatformListFluent.ItemsNested<N>>
    implements IntegrationPlatformListFluent.ItemsNested<N>,
    Nested<N> {
        private final IntegrationPlatformBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, IntegrationPlatform item) {
            this.index = index;
            this.builder = new IntegrationPlatformBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new IntegrationPlatformBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationPlatformListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

