package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationPlatformBuilder extends io.fabric8.camelk.v1.IntegrationPlatformFluentImpl<io.fabric8.camelk.v1.IntegrationPlatformBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.IntegrationPlatform,io.fabric8.camelk.v1.IntegrationPlatformBuilder> {

    io.fabric8.camelk.v1.IntegrationPlatformFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IntegrationPlatformBuilder() {
        this(true);
    }

    public IntegrationPlatformBuilder(java.lang.Boolean validationEnabled) {
        this(new IntegrationPlatform(), validationEnabled);
    }

    public IntegrationPlatformBuilder(io.fabric8.camelk.v1.IntegrationPlatformFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationPlatformBuilder(io.fabric8.camelk.v1.IntegrationPlatformFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IntegrationPlatform(), validationEnabled);
    }

    public IntegrationPlatformBuilder(io.fabric8.camelk.v1.IntegrationPlatformFluent<?> fluent,io.fabric8.camelk.v1.IntegrationPlatform instance) {
        this(fluent, instance, true);
    }

    public IntegrationPlatformBuilder(io.fabric8.camelk.v1.IntegrationPlatformFluent<?> fluent,io.fabric8.camelk.v1.IntegrationPlatform instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationPlatformBuilder(io.fabric8.camelk.v1.IntegrationPlatform instance) {
        this(instance,true);
    }

    public IntegrationPlatformBuilder(io.fabric8.camelk.v1.IntegrationPlatform instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationPlatform build() {
        EditableIntegrationPlatform buildable = new EditableIntegrationPlatform(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationPlatformBuilder that = (IntegrationPlatformBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
