package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CamelArtifactExclusionBuilder extends io.fabric8.camelk.v1.CamelArtifactExclusionFluentImpl<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.CamelArtifactExclusion,io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> {

    io.fabric8.camelk.v1.CamelArtifactExclusionFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public CamelArtifactExclusionBuilder() {
        this(true);
    }

    public CamelArtifactExclusionBuilder(java.lang.Boolean validationEnabled) {
        this(new CamelArtifactExclusion(), validationEnabled);
    }

    public CamelArtifactExclusionBuilder(io.fabric8.camelk.v1.CamelArtifactExclusionFluent<?> fluent) {
        this(fluent, true);
    }

    public CamelArtifactExclusionBuilder(io.fabric8.camelk.v1.CamelArtifactExclusionFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new CamelArtifactExclusion(), validationEnabled);
    }

    public CamelArtifactExclusionBuilder(io.fabric8.camelk.v1.CamelArtifactExclusionFluent<?> fluent,io.fabric8.camelk.v1.CamelArtifactExclusion instance) {
        this(fluent, instance, true);
    }

    public CamelArtifactExclusionBuilder(io.fabric8.camelk.v1.CamelArtifactExclusionFluent<?> fluent,io.fabric8.camelk.v1.CamelArtifactExclusion instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withArtifactId(instance.getArtifactId()); 
        fluent.withGroupId(instance.getGroupId()); 
        this.validationEnabled = validationEnabled; 
    }

    public CamelArtifactExclusionBuilder(io.fabric8.camelk.v1.CamelArtifactExclusion instance) {
        this(instance,true);
    }

    public CamelArtifactExclusionBuilder(io.fabric8.camelk.v1.CamelArtifactExclusion instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withArtifactId(instance.getArtifactId()); 
        this.withGroupId(instance.getGroupId()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableCamelArtifactExclusion build() {
        EditableCamelArtifactExclusion buildable = new EditableCamelArtifactExclusion(fluent.getArtifactId(),fluent.getGroupId());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CamelArtifactExclusionBuilder that = (CamelArtifactExclusionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
