package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;

public class BuilderTaskFluentImpl<A extends io.fabric8.camelk.v1.BuilderTaskFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.camelk.v1.BuilderTaskFluent<A> {

    private io.fabric8.kubernetes.api.model.Affinity affinity;
    private java.lang.String baseImage;
    private java.lang.String buildDir;
    private java.util.List<java.lang.String> dependencies;
    private java.lang.String image;
    private io.fabric8.camelk.v1.MavenSpecBuilder maven;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder meta;
    private java.lang.String name;
    private java.util.Map<java.lang.String,java.lang.String> properties;
    private java.util.List<io.fabric8.camelk.v1.ResourceSpecBuilder> resources;
    private io.fabric8.camelk.v1.RuntimeSpecBuilder runtime;
    private java.util.List<io.fabric8.camelk.v1.SourceSpecBuilder> sources;
    private java.util.List<java.lang.String> steps;
    private io.fabric8.kubernetes.api.model.Duration timeout;
    private java.util.List<io.fabric8.kubernetes.api.model.VolumeMountBuilder> volumeMounts;
    private java.util.List<io.fabric8.kubernetes.api.model.VolumeBuilder> volumes;

    public BuilderTaskFluentImpl() {
    }

    public BuilderTaskFluentImpl(io.fabric8.camelk.v1.BuilderTask instance) {
        this.withAffinity(instance.getAffinity()); 
        this.withBaseImage(instance.getBaseImage()); 
        this.withBuildDir(instance.getBuildDir()); 
        this.withDependencies(instance.getDependencies()); 
        this.withImage(instance.getImage()); 
        this.withMaven(instance.getMaven()); 
        this.withMeta(instance.getMeta()); 
        this.withName(instance.getName()); 
        this.withProperties(instance.getProperties()); 
        this.withResources(instance.getResources()); 
        this.withRuntime(instance.getRuntime()); 
        this.withSources(instance.getSources()); 
        this.withSteps(instance.getSteps()); 
        this.withTimeout(instance.getTimeout()); 
        this.withVolumeMounts(instance.getVolumeMounts()); 
        this.withVolumes(instance.getVolumes()); 
    }

    public io.fabric8.kubernetes.api.model.Affinity getAffinity() {
        return this.affinity;
    }

    public A withAffinity(io.fabric8.kubernetes.api.model.Affinity affinity) {
        this.affinity=affinity; return (A) this;
    }

    public java.lang.Boolean hasAffinity() {
        return this.affinity != null;
    }

    public java.lang.String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(java.lang.String baseImage) {
        this.baseImage=baseImage; return (A) this;
    }

    public java.lang.Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withBaseImage instead.
     */
        public A withNewBaseImage(java.lang.String arg0) {
        return (A)withBaseImage(new String(arg0));
    }

    public java.lang.String getBuildDir() {
        return this.buildDir;
    }

    public A withBuildDir(java.lang.String buildDir) {
        this.buildDir=buildDir; return (A) this;
    }

    public java.lang.Boolean hasBuildDir() {
        return this.buildDir != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withBuildDir instead.
     */
        public A withNewBuildDir(java.lang.String arg0) {
        return (A)withBuildDir(new String(arg0));
    }

    public A addToDependencies(int index,java.lang.String item) {
        if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
        this.dependencies.add(index, item);
        return (A)this;
    }

    public A setToDependencies(int index,java.lang.String item) {
        if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
        this.dependencies.set(index, item); return (A)this;
    }

    public A addToDependencies(java.lang.String... items) {
        if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.dependencies.add(item);} return (A)this;
    }

    public A addAllToDependencies(java.util.Collection<java.lang.String> items) {
        if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.dependencies.add(item);} return (A)this;
    }

    public A removeFromDependencies(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
    }

    public A removeAllFromDependencies(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getDependencies() {
        return this.dependencies;
    }

    public java.lang.String getDependency(int index) {
        return this.dependencies.get(index);
    }

    public java.lang.String getFirstDependency() {
        return this.dependencies.get(0);
    }

    public java.lang.String getLastDependency() {
        return this.dependencies.get(dependencies.size() - 1);
    }

    public java.lang.String getMatchingDependency(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingDependency(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDependencies(java.util.List<java.lang.String> dependencies) {
        if (this.dependencies != null) { _visitables.get("dependencies").removeAll(this.dependencies);}
        if (dependencies != null) {this.dependencies = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
    }

    public A withDependencies(java.lang.String... dependencies) {
        if (this.dependencies != null) {this.dependencies.clear();}
        if (dependencies != null) {for (java.lang.String item :dependencies){ this.addToDependencies(item);}} return (A) this;
    }

    public java.lang.Boolean hasDependencies() {
        return dependencies != null && !dependencies.isEmpty();
    }

    public A addNewDependency(java.lang.String arg0) {
        return (A)addToDependencies(new String(arg0));
    }

    public java.lang.String getImage() {
        return this.image;
    }

    public A withImage(java.lang.String image) {
        this.image=image; return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String arg0) {
        return (A)withImage(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMaven instead.
     * @return The buildable object.
     */
        public io.fabric8.camelk.v1.MavenSpec getMaven() {
        return this.maven!=null?this.maven.build():null;
    }

    public io.fabric8.camelk.v1.MavenSpec buildMaven() {
        return this.maven!=null?this.maven.build():null;
    }

    public A withMaven(io.fabric8.camelk.v1.MavenSpec maven) {
        _visitables.get("maven").remove(this.maven);
        if (maven!=null){ this.maven= new io.fabric8.camelk.v1.MavenSpecBuilder(maven); _visitables.get("maven").add(this.maven);} return (A) this;
    }

    public java.lang.Boolean hasMaven() {
        return this.maven != null;
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> withNewMaven() {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.MavenNestedImpl();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> withNewMavenLike(io.fabric8.camelk.v1.MavenSpec item) {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.MavenNestedImpl(item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> editMaven() {
        return withNewMavenLike(getMaven());
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> editOrNewMaven() {
        return withNewMavenLike(getMaven() != null ? getMaven(): new io.fabric8.camelk.v1.MavenSpecBuilder().build());
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> editOrNewMavenLike(io.fabric8.camelk.v1.MavenSpec item) {
        return withNewMavenLike(getMaven() != null ? getMaven(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMeta instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMeta() {
        return this.meta!=null?this.meta.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMeta() {
        return this.meta!=null?this.meta.build():null;
    }

    public A withMeta(io.fabric8.kubernetes.api.model.ObjectMeta meta) {
        _visitables.get("meta").remove(this.meta);
        if (meta!=null){ this.meta= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(meta); _visitables.get("meta").add(this.meta);} return (A) this;
    }

    public java.lang.Boolean hasMeta() {
        return this.meta != null;
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> withNewMeta() {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.MetaNestedImpl();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> withNewMetaLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.MetaNestedImpl(item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> editMeta() {
        return withNewMetaLike(getMeta());
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> editOrNewMeta() {
        return withNewMetaLike(getMeta() != null ? getMeta(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> editOrNewMetaLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetaLike(getMeta() != null ? getMeta(): item);
    }

    public java.lang.String getName() {
        return this.name;
    }

    public A withName(java.lang.String name) {
        this.name=name; return (A) this;
    }

    public java.lang.Boolean hasName() {
        return this.name != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String arg0) {
        return (A)withName(new String(arg0));
    }

    public A addToProperties(java.lang.String key,java.lang.String value) {
        if(this.properties == null && key != null && value != null) { this.properties = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(key != null && value != null) {this.properties.put(key, value);} return (A)this;
    }

    public A addToProperties(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.properties == null && map != null) { this.properties = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(map != null) { this.properties.putAll(map);} return (A)this;
    }

    public A removeFromProperties(java.lang.String key) {
        if(this.properties == null) { return (A) this; }
        if(key != null && this.properties != null) {this.properties.remove(key);} return (A)this;
    }

    public A removeFromProperties(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.properties == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.properties != null){this.properties.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.String> getProperties() {
        return this.properties;
    }

    public <K,V>A withProperties(java.util.Map<java.lang.String,java.lang.String> properties) {
        if (properties == null) { this.properties =  null;} else {this.properties = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(properties);} return (A) this;
    }

    public java.lang.Boolean hasProperties() {
        return this.properties != null;
    }

    public A addToResources(int index,io.fabric8.camelk.v1.ResourceSpec item) {
        if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
        io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
    }

    public A setToResources(int index,io.fabric8.camelk.v1.ResourceSpec item) {
        if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
        io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
        if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
         return (A)this;
    }

    public A addToResources(io.fabric8.camelk.v1.ResourceSpec... items) {
        if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
        for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A addAllToResources(java.util.Collection<io.fabric8.camelk.v1.ResourceSpec> items) {
        if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
        for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A removeFromResources(io.fabric8.camelk.v1.ResourceSpec... items) {
        for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeAllFromResources(java.util.Collection<io.fabric8.camelk.v1.ResourceSpec> items) {
        for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromResources(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
        if (resources == null) return (A) this;
        final Iterator<io.fabric8.camelk.v1.ResourceSpecBuilder> each = resources.iterator();
        final List visitables = _visitables.get("resources");
        while (each.hasNext()) {
          io.fabric8.camelk.v1.ResourceSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildResources instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.camelk.v1.ResourceSpec> getResources() {
        return build(resources);
    }

    public java.util.List<io.fabric8.camelk.v1.ResourceSpec> buildResources() {
        return build(resources);
    }

    public io.fabric8.camelk.v1.ResourceSpec buildResource(int index) {
        return this.resources.get(index).build();
    }

    public io.fabric8.camelk.v1.ResourceSpec buildFirstResource() {
        return this.resources.get(0).build();
    }

    public io.fabric8.camelk.v1.ResourceSpec buildLastResource() {
        return this.resources.get(resources.size() - 1).build();
    }

    public io.fabric8.camelk.v1.ResourceSpec buildMatchingResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
        for (io.fabric8.camelk.v1.ResourceSpecBuilder item: resources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
        for (io.fabric8.camelk.v1.ResourceSpecBuilder item: resources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withResources(java.util.List<io.fabric8.camelk.v1.ResourceSpec> resources) {
        if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
        if (resources != null) {this.resources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>(); for (io.fabric8.camelk.v1.ResourceSpec item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
    }

    public A withResources(io.fabric8.camelk.v1.ResourceSpec... resources) {
        if (this.resources != null) {this.resources.clear();}
        if (resources != null) {for (io.fabric8.camelk.v1.ResourceSpec item :resources){ this.addToResources(item);}} return (A) this;
    }

    public java.lang.Boolean hasResources() {
        return resources != null && !resources.isEmpty();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> addNewResource() {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.ResourcesNestedImpl();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> addNewResourceLike(io.fabric8.camelk.v1.ResourceSpec item) {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.ResourcesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> setNewResourceLike(int index,io.fabric8.camelk.v1.ResourceSpec item) {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.ResourcesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editResource(int index) {
        if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
        return setNewResourceLike(index, buildResource(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editFirstResource() {
        if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
        return setNewResourceLike(0, buildResource(0));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editLastResource() {
        int index = resources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
        return setNewResourceLike(index, buildResource(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editMatchingResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<resources.size();i++) { 
        if (predicate.test(resources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
        return setNewResourceLike(index, buildResource(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRuntime instead.
     * @return The buildable object.
     */
        public io.fabric8.camelk.v1.RuntimeSpec getRuntime() {
        return this.runtime!=null?this.runtime.build():null;
    }

    public io.fabric8.camelk.v1.RuntimeSpec buildRuntime() {
        return this.runtime!=null?this.runtime.build():null;
    }

    public A withRuntime(io.fabric8.camelk.v1.RuntimeSpec runtime) {
        _visitables.get("runtime").remove(this.runtime);
        if (runtime!=null){ this.runtime= new io.fabric8.camelk.v1.RuntimeSpecBuilder(runtime); _visitables.get("runtime").add(this.runtime);} return (A) this;
    }

    public java.lang.Boolean hasRuntime() {
        return this.runtime != null;
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> withNewRuntime() {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.RuntimeNestedImpl();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> withNewRuntimeLike(io.fabric8.camelk.v1.RuntimeSpec item) {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.RuntimeNestedImpl(item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> editRuntime() {
        return withNewRuntimeLike(getRuntime());
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> editOrNewRuntime() {
        return withNewRuntimeLike(getRuntime() != null ? getRuntime(): new io.fabric8.camelk.v1.RuntimeSpecBuilder().build());
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> editOrNewRuntimeLike(io.fabric8.camelk.v1.RuntimeSpec item) {
        return withNewRuntimeLike(getRuntime() != null ? getRuntime(): item);
    }

    public A addToSources(int index,io.fabric8.camelk.v1.SourceSpec item) {
        if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
        io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").add(index >= 0 ? index : _visitables.get("sources").size(), builder);this.sources.add(index >= 0 ? index : sources.size(), builder); return (A)this;
    }

    public A setToSources(int index,io.fabric8.camelk.v1.SourceSpec item) {
        if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
        io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("sources").size()) { _visitables.get("sources").add(builder); } else { _visitables.get("sources").set(index, builder);}
        if (index < 0 || index >= sources.size()) { sources.add(builder); } else { sources.set(index, builder);}
         return (A)this;
    }

    public A addToSources(io.fabric8.camelk.v1.SourceSpec... items) {
        if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
        for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
    }

    public A addAllToSources(java.util.Collection<io.fabric8.camelk.v1.SourceSpec> items) {
        if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
        for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
    }

    public A removeFromSources(io.fabric8.camelk.v1.SourceSpec... items) {
        for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
    }

    public A removeAllFromSources(java.util.Collection<io.fabric8.camelk.v1.SourceSpec> items) {
        for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSources(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
        if (sources == null) return (A) this;
        final Iterator<io.fabric8.camelk.v1.SourceSpecBuilder> each = sources.iterator();
        final List visitables = _visitables.get("sources");
        while (each.hasNext()) {
          io.fabric8.camelk.v1.SourceSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSources instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.camelk.v1.SourceSpec> getSources() {
        return build(sources);
    }

    public java.util.List<io.fabric8.camelk.v1.SourceSpec> buildSources() {
        return build(sources);
    }

    public io.fabric8.camelk.v1.SourceSpec buildSource(int index) {
        return this.sources.get(index).build();
    }

    public io.fabric8.camelk.v1.SourceSpec buildFirstSource() {
        return this.sources.get(0).build();
    }

    public io.fabric8.camelk.v1.SourceSpec buildLastSource() {
        return this.sources.get(sources.size() - 1).build();
    }

    public io.fabric8.camelk.v1.SourceSpec buildMatchingSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
        for (io.fabric8.camelk.v1.SourceSpecBuilder item: sources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
        for (io.fabric8.camelk.v1.SourceSpecBuilder item: sources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSources(java.util.List<io.fabric8.camelk.v1.SourceSpec> sources) {
        if (this.sources != null) { _visitables.get("sources").removeAll(this.sources);}
        if (sources != null) {this.sources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>(); for (io.fabric8.camelk.v1.SourceSpec item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
    }

    public A withSources(io.fabric8.camelk.v1.SourceSpec... sources) {
        if (this.sources != null) {this.sources.clear();}
        if (sources != null) {for (io.fabric8.camelk.v1.SourceSpec item :sources){ this.addToSources(item);}} return (A) this;
    }

    public java.lang.Boolean hasSources() {
        return sources != null && !sources.isEmpty();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> addNewSource() {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.SourcesNestedImpl();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> addNewSourceLike(io.fabric8.camelk.v1.SourceSpec item) {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.SourcesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> setNewSourceLike(int index,io.fabric8.camelk.v1.SourceSpec item) {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.SourcesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editSource(int index) {
        if (sources.size() <= index) throw new RuntimeException("Can't edit sources. Index exceeds size.");
        return setNewSourceLike(index, buildSource(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editFirstSource() {
        if (sources.size() == 0) throw new RuntimeException("Can't edit first sources. The list is empty.");
        return setNewSourceLike(0, buildSource(0));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editLastSource() {
        int index = sources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last sources. The list is empty.");
        return setNewSourceLike(index, buildSource(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editMatchingSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<sources.size();i++) { 
        if (predicate.test(sources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching sources. No match found.");
        return setNewSourceLike(index, buildSource(index));
    }

    public A addToSteps(int index,java.lang.String item) {
        if (this.steps == null) {this.steps = new java.util.ArrayList<java.lang.String>();}
        this.steps.add(index, item);
        return (A)this;
    }

    public A setToSteps(int index,java.lang.String item) {
        if (this.steps == null) {this.steps = new java.util.ArrayList<java.lang.String>();}
        this.steps.set(index, item); return (A)this;
    }

    public A addToSteps(java.lang.String... items) {
        if (this.steps == null) {this.steps = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.steps.add(item);} return (A)this;
    }

    public A addAllToSteps(java.util.Collection<java.lang.String> items) {
        if (this.steps == null) {this.steps = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.steps.add(item);} return (A)this;
    }

    public A removeFromSteps(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.steps!= null){ this.steps.remove(item);}} return (A)this;
    }

    public A removeAllFromSteps(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.steps!= null){ this.steps.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getSteps() {
        return this.steps;
    }

    public java.lang.String getStep(int index) {
        return this.steps.get(index);
    }

    public java.lang.String getFirstStep() {
        return this.steps.get(0);
    }

    public java.lang.String getLastStep() {
        return this.steps.get(steps.size() - 1);
    }

    public java.lang.String getMatchingStep(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: steps) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingStep(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: steps) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSteps(java.util.List<java.lang.String> steps) {
        if (this.steps != null) { _visitables.get("steps").removeAll(this.steps);}
        if (steps != null) {this.steps = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : steps){this.addToSteps(item);}} else { this.steps = null;} return (A) this;
    }

    public A withSteps(java.lang.String... steps) {
        if (this.steps != null) {this.steps.clear();}
        if (steps != null) {for (java.lang.String item :steps){ this.addToSteps(item);}} return (A) this;
    }

    public java.lang.Boolean hasSteps() {
        return steps != null && !steps.isEmpty();
    }

    public A addNewStep(java.lang.String arg0) {
        return (A)addToSteps(new String(arg0));
    }

    public io.fabric8.kubernetes.api.model.Duration getTimeout() {
        return this.timeout;
    }

    public A withTimeout(io.fabric8.kubernetes.api.model.Duration timeout) {
        this.timeout=timeout; return (A) this;
    }

    public java.lang.Boolean hasTimeout() {
        return this.timeout != null;
    }

    public A addToVolumeMounts(int index,io.fabric8.kubernetes.api.model.VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMountBuilder>();}
        io.fabric8.kubernetes.api.model.VolumeMountBuilder builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(item);_visitables.get("volumeMounts").add(index >= 0 ? index : _visitables.get("volumeMounts").size(), builder);this.volumeMounts.add(index >= 0 ? index : volumeMounts.size(), builder); return (A)this;
    }

    public A setToVolumeMounts(int index,io.fabric8.kubernetes.api.model.VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMountBuilder>();}
        io.fabric8.kubernetes.api.model.VolumeMountBuilder builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(item);
        if (index < 0 || index >= _visitables.get("volumeMounts").size()) { _visitables.get("volumeMounts").add(builder); } else { _visitables.get("volumeMounts").set(index, builder);}
        if (index < 0 || index >= volumeMounts.size()) { volumeMounts.add(builder); } else { volumeMounts.set(index, builder);}
         return (A)this;
    }

    public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
        if (this.volumeMounts == null) {this.volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMountBuilder>();}
        for (io.fabric8.kubernetes.api.model.VolumeMount item : items) {io.fabric8.kubernetes.api.model.VolumeMountBuilder builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
    }

    public A addAllToVolumeMounts(java.util.Collection<io.fabric8.kubernetes.api.model.VolumeMount> items) {
        if (this.volumeMounts == null) {this.volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMountBuilder>();}
        for (io.fabric8.kubernetes.api.model.VolumeMount item : items) {io.fabric8.kubernetes.api.model.VolumeMountBuilder builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
    }

    public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
        for (io.fabric8.kubernetes.api.model.VolumeMount item : items) {io.fabric8.kubernetes.api.model.VolumeMountBuilder builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumeMounts(java.util.Collection<io.fabric8.kubernetes.api.model.VolumeMount> items) {
        for (io.fabric8.kubernetes.api.model.VolumeMount item : items) {io.fabric8.kubernetes.api.model.VolumeMountBuilder builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumeMounts(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeMountBuilder> predicate) {
        if (volumeMounts == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.VolumeMountBuilder> each = volumeMounts.iterator();
        final List visitables = _visitables.get("volumeMounts");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.VolumeMountBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildVolumeMounts instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.VolumeMount> getVolumeMounts() {
        return build(volumeMounts);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.VolumeMount> buildVolumeMounts() {
        return build(volumeMounts);
    }

    public io.fabric8.kubernetes.api.model.VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(volumeMounts.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.VolumeMount buildMatchingVolumeMount(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeMountBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.VolumeMountBuilder item: volumeMounts) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingVolumeMount(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeMountBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.VolumeMountBuilder item: volumeMounts) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumeMounts(java.util.List<io.fabric8.kubernetes.api.model.VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) { _visitables.get("volumeMounts").removeAll(this.volumeMounts);}
        if (volumeMounts != null) {this.volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMountBuilder>(); for (io.fabric8.kubernetes.api.model.VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
    }

    public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... volumeMounts) {
        if (this.volumeMounts != null) {this.volumeMounts.clear();}
        if (volumeMounts != null) {for (io.fabric8.kubernetes.api.model.VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
    }

    public java.lang.Boolean hasVolumeMounts() {
        return volumeMounts != null && !volumeMounts.isEmpty();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> addNewVolumeMount() {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.VolumeMountsNestedImpl();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> addNewVolumeMountLike(io.fabric8.kubernetes.api.model.VolumeMount item) {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.VolumeMountsNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index,io.fabric8.kubernetes.api.model.VolumeMount item) {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.VolumeMountsNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> editVolumeMount(int index) {
        if (volumeMounts.size() <= index) throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> editFirstVolumeMount() {
        if (volumeMounts.size() == 0) throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        return setNewVolumeMountLike(0, buildVolumeMount(0));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> editLastVolumeMount() {
        int index = volumeMounts.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> editMatchingVolumeMount(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i=0;i<volumeMounts.size();i++) { 
        if (predicate.test(volumeMounts.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public A addToVolumes(int index,io.fabric8.kubernetes.api.model.Volume item) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeBuilder>();}
        io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
    }

    public A setToVolumes(int index,io.fabric8.kubernetes.api.model.Volume item) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeBuilder>();}
        io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);
        if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
        if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
         return (A)this;
    }

    public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeBuilder>();}
        for (io.fabric8.kubernetes.api.model.Volume item : items) {io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A addAllToVolumes(java.util.Collection<io.fabric8.kubernetes.api.model.Volume> items) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeBuilder>();}
        for (io.fabric8.kubernetes.api.model.Volume item : items) {io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
        for (io.fabric8.kubernetes.api.model.Volume item : items) {io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumes(java.util.Collection<io.fabric8.kubernetes.api.model.Volume> items) {
        for (io.fabric8.kubernetes.api.model.Volume item : items) {io.fabric8.kubernetes.api.model.VolumeBuilder builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumes(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate) {
        if (volumes == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.VolumeBuilder> each = volumes.iterator();
        final List visitables = _visitables.get("volumes");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.VolumeBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildVolumes instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.Volume> getVolumes() {
        return build(volumes);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.Volume> buildVolumes() {
        return build(volumes);
    }

    public io.fabric8.kubernetes.api.model.Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.Volume buildLastVolume() {
        return this.volumes.get(volumes.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.Volume buildMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.VolumeBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.VolumeBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumes(java.util.List<io.fabric8.kubernetes.api.model.Volume> volumes) {
        if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
        if (volumes != null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeBuilder>(); for (io.fabric8.kubernetes.api.model.Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes) {
        if (this.volumes != null) {this.volumes.clear();}
        if (volumes != null) {for (io.fabric8.kubernetes.api.model.Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public java.lang.Boolean hasVolumes() {
        return volumes != null && !volumes.isEmpty();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> addNewVolume() {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.VolumesNestedImpl();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> addNewVolumeLike(io.fabric8.kubernetes.api.model.Volume item) {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.VolumesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> setNewVolumeLike(int index,io.fabric8.kubernetes.api.model.Volume item) {
        return new io.fabric8.camelk.v1.BuilderTaskFluentImpl.VolumesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> editVolume(int index) {
        if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> editFirstVolume() {
        if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
        return setNewVolumeLike(0, buildVolume(0));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> editLastVolume() {
        int index = volumes.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> editMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate) {
        int index = -1;
        for (int i=0;i<volumes.size();i++) { 
        if (predicate.test(volumes.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BuilderTaskFluentImpl that = (BuilderTaskFluentImpl) o;
        if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
        if (baseImage != null ? !baseImage.equals(that.baseImage) :that.baseImage != null) return false;
        if (buildDir != null ? !buildDir.equals(that.buildDir) :that.buildDir != null) return false;
        if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (maven != null ? !maven.equals(that.maven) :that.maven != null) return false;
        if (meta != null ? !meta.equals(that.meta) :that.meta != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (properties != null ? !properties.equals(that.properties) :that.properties != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (runtime != null ? !runtime.equals(that.runtime) :that.runtime != null) return false;
        if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
        if (steps != null ? !steps.equals(that.steps) :that.steps != null) return false;
        if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
        if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
        if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(affinity,  baseImage,  buildDir,  dependencies,  image,  maven,  meta,  name,  properties,  resources,  runtime,  sources,  steps,  timeout,  volumeMounts,  volumes,  super.hashCode());
    }

    public class MavenNestedImpl<N> extends io.fabric8.camelk.v1.MavenSpecFluentImpl<io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.MavenSpecBuilder builder;

            MavenNestedImpl(io.fabric8.camelk.v1.MavenSpec item) {
                this.builder = new io.fabric8.camelk.v1.MavenSpecBuilder(this, item);
                        
            }

            MavenNestedImpl() {
                this.builder = new io.fabric8.camelk.v1.MavenSpecBuilder(this);
                        
            }

            public N and() {
                return (N) BuilderTaskFluentImpl.this.withMaven(builder.build());
            }

            public N endMaven() {
                return and();
            }
    }


    public class MetaNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetaNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetaNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) BuilderTaskFluentImpl.this.withMeta(builder.build());
            }

            public N endMeta() {
                return and();
            }
    }


    public class ResourcesNestedImpl<N> extends io.fabric8.camelk.v1.ResourceSpecFluentImpl<io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.ResourceSpecBuilder builder;
        private final int index;

            ResourcesNestedImpl(int index,io.fabric8.camelk.v1.ResourceSpec item) {
                this.index = index;
                this.builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(this, item);
                        
            }

            ResourcesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) BuilderTaskFluentImpl.this.setToResources(index,builder.build());
            }

            public N endResource() {
                return and();
            }
    }


    public class RuntimeNestedImpl<N> extends io.fabric8.camelk.v1.RuntimeSpecFluentImpl<io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.RuntimeSpecBuilder builder;

            RuntimeNestedImpl(io.fabric8.camelk.v1.RuntimeSpec item) {
                this.builder = new io.fabric8.camelk.v1.RuntimeSpecBuilder(this, item);
                        
            }

            RuntimeNestedImpl() {
                this.builder = new io.fabric8.camelk.v1.RuntimeSpecBuilder(this);
                        
            }

            public N and() {
                return (N) BuilderTaskFluentImpl.this.withRuntime(builder.build());
            }

            public N endRuntime() {
                return and();
            }
    }


    public class SourcesNestedImpl<N> extends io.fabric8.camelk.v1.SourceSpecFluentImpl<io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.SourceSpecBuilder builder;
        private final int index;

            SourcesNestedImpl(int index,io.fabric8.camelk.v1.SourceSpec item) {
                this.index = index;
                this.builder = new io.fabric8.camelk.v1.SourceSpecBuilder(this, item);
                        
            }

            SourcesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.camelk.v1.SourceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) BuilderTaskFluentImpl.this.setToSources(index,builder.build());
            }

            public N endSource() {
                return and();
            }
    }


    public class VolumeMountsNestedImpl<N> extends io.fabric8.kubernetes.api.model.VolumeMountFluentImpl<io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.VolumeMountBuilder builder;
        private final int index;

            VolumeMountsNestedImpl(int index,io.fabric8.kubernetes.api.model.VolumeMount item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(this, item);
                        
            }

            VolumeMountsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(this);
                        
            }

            public N and() {
                return (N) BuilderTaskFluentImpl.this.setToVolumeMounts(index,builder.build());
            }

            public N endVolumeMount() {
                return and();
            }
    }


    public class VolumesNestedImpl<N> extends io.fabric8.kubernetes.api.model.VolumeFluentImpl<io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.VolumeBuilder builder;
        private final int index;

            VolumesNestedImpl(int index,io.fabric8.kubernetes.api.model.Volume item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(this, item);
                        
            }

            VolumesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.VolumeBuilder(this);
                        
            }

            public N and() {
                return (N) BuilderTaskFluentImpl.this.setToVolumes(index,builder.build());
            }

            public N endVolume() {
                return and();
            }
    }


}
