package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationConditionBuilder extends io.fabric8.camelk.v1.IntegrationConditionFluentImpl<io.fabric8.camelk.v1.IntegrationConditionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.IntegrationCondition,io.fabric8.camelk.v1.IntegrationConditionBuilder> {

    io.fabric8.camelk.v1.IntegrationConditionFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IntegrationConditionBuilder() {
        this(true);
    }

    public IntegrationConditionBuilder(java.lang.Boolean validationEnabled) {
        this(new IntegrationCondition(), validationEnabled);
    }

    public IntegrationConditionBuilder(io.fabric8.camelk.v1.IntegrationConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationConditionBuilder(io.fabric8.camelk.v1.IntegrationConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IntegrationCondition(), validationEnabled);
    }

    public IntegrationConditionBuilder(io.fabric8.camelk.v1.IntegrationConditionFluent<?> fluent,io.fabric8.camelk.v1.IntegrationCondition instance) {
        this(fluent, instance, true);
    }

    public IntegrationConditionBuilder(io.fabric8.camelk.v1.IntegrationConditionFluent<?> fluent,io.fabric8.camelk.v1.IntegrationCondition instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFirstTruthyTime(instance.getFirstTruthyTime()); 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationConditionBuilder(io.fabric8.camelk.v1.IntegrationCondition instance) {
        this(instance,true);
    }

    public IntegrationConditionBuilder(io.fabric8.camelk.v1.IntegrationCondition instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withFirstTruthyTime(instance.getFirstTruthyTime()); 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withLastUpdateTime(instance.getLastUpdateTime()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationCondition build() {
        EditableIntegrationCondition buildable = new EditableIntegrationCondition(fluent.getFirstTruthyTime(),fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationConditionBuilder that = (IntegrationConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
