package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CamelCatalogBuilder extends io.fabric8.camelk.v1.CamelCatalogFluentImpl<io.fabric8.camelk.v1.CamelCatalogBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.CamelCatalog,io.fabric8.camelk.v1.CamelCatalogBuilder> {

    io.fabric8.camelk.v1.CamelCatalogFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public CamelCatalogBuilder() {
        this(true);
    }

    public CamelCatalogBuilder(java.lang.Boolean validationEnabled) {
        this(new CamelCatalog(), validationEnabled);
    }

    public CamelCatalogBuilder(io.fabric8.camelk.v1.CamelCatalogFluent<?> fluent) {
        this(fluent, true);
    }

    public CamelCatalogBuilder(io.fabric8.camelk.v1.CamelCatalogFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new CamelCatalog(), validationEnabled);
    }

    public CamelCatalogBuilder(io.fabric8.camelk.v1.CamelCatalogFluent<?> fluent,io.fabric8.camelk.v1.CamelCatalog instance) {
        this(fluent, instance, true);
    }

    public CamelCatalogBuilder(io.fabric8.camelk.v1.CamelCatalogFluent<?> fluent,io.fabric8.camelk.v1.CamelCatalog instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public CamelCatalogBuilder(io.fabric8.camelk.v1.CamelCatalog instance) {
        this(instance,true);
    }

    public CamelCatalogBuilder(io.fabric8.camelk.v1.CamelCatalog instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableCamelCatalog build() {
        EditableCamelCatalog buildable = new EditableCamelCatalog(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CamelCatalogBuilder that = (CamelCatalogBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
