package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationBuilder extends io.fabric8.camelk.v1.IntegrationFluentImpl<io.fabric8.camelk.v1.IntegrationBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.Integration,io.fabric8.camelk.v1.IntegrationBuilder> {

    io.fabric8.camelk.v1.IntegrationFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IntegrationBuilder() {
        this(true);
    }

    public IntegrationBuilder(java.lang.Boolean validationEnabled) {
        this(new Integration(), validationEnabled);
    }

    public IntegrationBuilder(io.fabric8.camelk.v1.IntegrationFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationBuilder(io.fabric8.camelk.v1.IntegrationFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Integration(), validationEnabled);
    }

    public IntegrationBuilder(io.fabric8.camelk.v1.IntegrationFluent<?> fluent,io.fabric8.camelk.v1.Integration instance) {
        this(fluent, instance, true);
    }

    public IntegrationBuilder(io.fabric8.camelk.v1.IntegrationFluent<?> fluent,io.fabric8.camelk.v1.Integration instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationBuilder(io.fabric8.camelk.v1.Integration instance) {
        this(instance,true);
    }

    public IntegrationBuilder(io.fabric8.camelk.v1.Integration instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegration build() {
        EditableIntegration buildable = new EditableIntegration(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationBuilder that = (IntegrationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
