package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CamelArtifactDependencyFluentImpl<A extends io.fabric8.camelk.v1.CamelArtifactDependencyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.camelk.v1.CamelArtifactDependencyFluent<A> {

    private java.lang.String artifactId;
    private java.util.List<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> exclusions;
    private java.lang.String groupId;
    private java.lang.String version;

    public CamelArtifactDependencyFluentImpl() {
    }

    public CamelArtifactDependencyFluentImpl(io.fabric8.camelk.v1.CamelArtifactDependency instance) {
        this.withArtifactId(instance.getArtifactId()); 
        this.withExclusions(instance.getExclusions()); 
        this.withGroupId(instance.getGroupId()); 
        this.withVersion(instance.getVersion()); 
    }

    public java.lang.String getArtifactId() {
        return this.artifactId;
    }

    public A withArtifactId(java.lang.String artifactId) {
        this.artifactId=artifactId; return (A) this;
    }

    public java.lang.Boolean hasArtifactId() {
        return this.artifactId != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withArtifactId instead.
     */
        public A withNewArtifactId(java.lang.String arg0) {
        return (A)withArtifactId(new String(arg0));
    }

    public A addToExclusions(int index,io.fabric8.camelk.v1.CamelArtifactExclusion item) {
        if (this.exclusions == null) {this.exclusions = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder>();}
        io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").add(index >= 0 ? index : _visitables.get("exclusions").size(), builder);this.exclusions.add(index >= 0 ? index : exclusions.size(), builder); return (A)this;
    }

    public A setToExclusions(int index,io.fabric8.camelk.v1.CamelArtifactExclusion item) {
        if (this.exclusions == null) {this.exclusions = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder>();}
        io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(item);
        if (index < 0 || index >= _visitables.get("exclusions").size()) { _visitables.get("exclusions").add(builder); } else { _visitables.get("exclusions").set(index, builder);}
        if (index < 0 || index >= exclusions.size()) { exclusions.add(builder); } else { exclusions.set(index, builder);}
         return (A)this;
    }

    public A addToExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... items) {
        if (this.exclusions == null) {this.exclusions = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder>();}
        for (io.fabric8.camelk.v1.CamelArtifactExclusion item : items) {io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").add(builder);this.exclusions.add(builder);} return (A)this;
    }

    public A addAllToExclusions(java.util.Collection<io.fabric8.camelk.v1.CamelArtifactExclusion> items) {
        if (this.exclusions == null) {this.exclusions = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder>();}
        for (io.fabric8.camelk.v1.CamelArtifactExclusion item : items) {io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").add(builder);this.exclusions.add(builder);} return (A)this;
    }

    public A removeFromExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... items) {
        for (io.fabric8.camelk.v1.CamelArtifactExclusion item : items) {io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").remove(builder);if (this.exclusions != null) {this.exclusions.remove(builder);}} return (A)this;
    }

    public A removeAllFromExclusions(java.util.Collection<io.fabric8.camelk.v1.CamelArtifactExclusion> items) {
        for (io.fabric8.camelk.v1.CamelArtifactExclusion item : items) {io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").remove(builder);if (this.exclusions != null) {this.exclusions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromExclusions(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> predicate) {
        if (exclusions == null) return (A) this;
        final Iterator<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> each = exclusions.iterator();
        final List visitables = _visitables.get("exclusions");
        while (each.hasNext()) {
          io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildExclusions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.camelk.v1.CamelArtifactExclusion> getExclusions() {
        return build(exclusions);
    }

    public java.util.List<io.fabric8.camelk.v1.CamelArtifactExclusion> buildExclusions() {
        return build(exclusions);
    }

    public io.fabric8.camelk.v1.CamelArtifactExclusion buildExclusion(int index) {
        return this.exclusions.get(index).build();
    }

    public io.fabric8.camelk.v1.CamelArtifactExclusion buildFirstExclusion() {
        return this.exclusions.get(0).build();
    }

    public io.fabric8.camelk.v1.CamelArtifactExclusion buildLastExclusion() {
        return this.exclusions.get(exclusions.size() - 1).build();
    }

    public io.fabric8.camelk.v1.CamelArtifactExclusion buildMatchingExclusion(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> predicate) {
        for (io.fabric8.camelk.v1.CamelArtifactExclusionBuilder item: exclusions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingExclusion(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> predicate) {
        for (io.fabric8.camelk.v1.CamelArtifactExclusionBuilder item: exclusions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withExclusions(java.util.List<io.fabric8.camelk.v1.CamelArtifactExclusion> exclusions) {
        if (this.exclusions != null) { _visitables.get("exclusions").removeAll(this.exclusions);}
        if (exclusions != null) {this.exclusions = new java.util.ArrayList<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder>(); for (io.fabric8.camelk.v1.CamelArtifactExclusion item : exclusions){this.addToExclusions(item);}} else { this.exclusions = null;} return (A) this;
    }

    public A withExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... exclusions) {
        if (this.exclusions != null) {this.exclusions.clear();}
        if (exclusions != null) {for (io.fabric8.camelk.v1.CamelArtifactExclusion item :exclusions){ this.addToExclusions(item);}} return (A) this;
    }

    public java.lang.Boolean hasExclusions() {
        return exclusions != null && !exclusions.isEmpty();
    }

    public A addNewExclusion(java.lang.String artifactId,java.lang.String groupId) {
        return (A)addToExclusions(new CamelArtifactExclusion(artifactId, groupId));
    }

    public io.fabric8.camelk.v1.CamelArtifactDependencyFluent.ExclusionsNested<A> addNewExclusion() {
        return new io.fabric8.camelk.v1.CamelArtifactDependencyFluentImpl.ExclusionsNestedImpl();
    }

    public io.fabric8.camelk.v1.CamelArtifactDependencyFluent.ExclusionsNested<A> addNewExclusionLike(io.fabric8.camelk.v1.CamelArtifactExclusion item) {
        return new io.fabric8.camelk.v1.CamelArtifactDependencyFluentImpl.ExclusionsNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.CamelArtifactDependencyFluent.ExclusionsNested<A> setNewExclusionLike(int index,io.fabric8.camelk.v1.CamelArtifactExclusion item) {
        return new io.fabric8.camelk.v1.CamelArtifactDependencyFluentImpl.ExclusionsNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.CamelArtifactDependencyFluent.ExclusionsNested<A> editExclusion(int index) {
        if (exclusions.size() <= index) throw new RuntimeException("Can't edit exclusions. Index exceeds size.");
        return setNewExclusionLike(index, buildExclusion(index));
    }

    public io.fabric8.camelk.v1.CamelArtifactDependencyFluent.ExclusionsNested<A> editFirstExclusion() {
        if (exclusions.size() == 0) throw new RuntimeException("Can't edit first exclusions. The list is empty.");
        return setNewExclusionLike(0, buildExclusion(0));
    }

    public io.fabric8.camelk.v1.CamelArtifactDependencyFluent.ExclusionsNested<A> editLastExclusion() {
        int index = exclusions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last exclusions. The list is empty.");
        return setNewExclusionLike(index, buildExclusion(index));
    }

    public io.fabric8.camelk.v1.CamelArtifactDependencyFluent.ExclusionsNested<A> editMatchingExclusion(java.util.function.Predicate<io.fabric8.camelk.v1.CamelArtifactExclusionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<exclusions.size();i++) { 
        if (predicate.test(exclusions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching exclusions. No match found.");
        return setNewExclusionLike(index, buildExclusion(index));
    }

    public java.lang.String getGroupId() {
        return this.groupId;
    }

    public A withGroupId(java.lang.String groupId) {
        this.groupId=groupId; return (A) this;
    }

    public java.lang.Boolean hasGroupId() {
        return this.groupId != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withGroupId instead.
     */
        public A withNewGroupId(java.lang.String arg0) {
        return (A)withGroupId(new String(arg0));
    }

    public java.lang.String getVersion() {
        return this.version;
    }

    public A withVersion(java.lang.String version) {
        this.version=version; return (A) this;
    }

    public java.lang.Boolean hasVersion() {
        return this.version != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withVersion instead.
     */
        public A withNewVersion(java.lang.String arg0) {
        return (A)withVersion(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CamelArtifactDependencyFluentImpl that = (CamelArtifactDependencyFluentImpl) o;
        if (artifactId != null ? !artifactId.equals(that.artifactId) :that.artifactId != null) return false;
        if (exclusions != null ? !exclusions.equals(that.exclusions) :that.exclusions != null) return false;
        if (groupId != null ? !groupId.equals(that.groupId) :that.groupId != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(artifactId,  exclusions,  groupId,  version,  super.hashCode());
    }

    public class ExclusionsNestedImpl<N> extends io.fabric8.camelk.v1.CamelArtifactExclusionFluentImpl<io.fabric8.camelk.v1.CamelArtifactDependencyFluent.ExclusionsNested<N>> implements io.fabric8.camelk.v1.CamelArtifactDependencyFluent.ExclusionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.CamelArtifactExclusionBuilder builder;
        private final int index;

            ExclusionsNestedImpl(int index,io.fabric8.camelk.v1.CamelArtifactExclusion item) {
                this.index = index;
                this.builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(this, item);
                        
            }

            ExclusionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.camelk.v1.CamelArtifactExclusionBuilder(this);
                        
            }

            public N and() {
                return (N) CamelArtifactDependencyFluentImpl.this.setToExclusions(index,builder.build());
            }

            public N endExclusion() {
                return and();
            }
    }


}
