package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TraitSpecBuilder extends io.fabric8.camelk.v1.TraitSpecFluentImpl<io.fabric8.camelk.v1.TraitSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.TraitSpec,io.fabric8.camelk.v1.TraitSpecBuilder> {

    io.fabric8.camelk.v1.TraitSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public TraitSpecBuilder() {
        this(true);
    }

    public TraitSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new TraitSpec(), validationEnabled);
    }

    public TraitSpecBuilder(io.fabric8.camelk.v1.TraitSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public TraitSpecBuilder(io.fabric8.camelk.v1.TraitSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new TraitSpec(), validationEnabled);
    }

    public TraitSpecBuilder(io.fabric8.camelk.v1.TraitSpecFluent<?> fluent,io.fabric8.camelk.v1.TraitSpec instance) {
        this(fluent, instance, true);
    }

    public TraitSpecBuilder(io.fabric8.camelk.v1.TraitSpecFluent<?> fluent,io.fabric8.camelk.v1.TraitSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConfiguration(instance.getConfiguration()); 
        this.validationEnabled = validationEnabled; 
    }

    public TraitSpecBuilder(io.fabric8.camelk.v1.TraitSpec instance) {
        this(instance,true);
    }

    public TraitSpecBuilder(io.fabric8.camelk.v1.TraitSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConfiguration(instance.getConfiguration()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableTraitSpec build() {
        EditableTraitSpec buildable = new EditableTraitSpec(fluent.getConfiguration());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TraitSpecBuilder that = (TraitSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
