package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RuntimeSpecBuilder extends io.fabric8.camelk.v1.RuntimeSpecFluentImpl<io.fabric8.camelk.v1.RuntimeSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.RuntimeSpec,io.fabric8.camelk.v1.RuntimeSpecBuilder> {

    io.fabric8.camelk.v1.RuntimeSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RuntimeSpecBuilder() {
        this(true);
    }

    public RuntimeSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new RuntimeSpec(), validationEnabled);
    }

    public RuntimeSpecBuilder(io.fabric8.camelk.v1.RuntimeSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public RuntimeSpecBuilder(io.fabric8.camelk.v1.RuntimeSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RuntimeSpec(), validationEnabled);
    }

    public RuntimeSpecBuilder(io.fabric8.camelk.v1.RuntimeSpecFluent<?> fluent,io.fabric8.camelk.v1.RuntimeSpec instance) {
        this(fluent, instance, true);
    }

    public RuntimeSpecBuilder(io.fabric8.camelk.v1.RuntimeSpecFluent<?> fluent,io.fabric8.camelk.v1.RuntimeSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApplicationClass(instance.getApplicationClass()); 
        fluent.withCapabilities(instance.getCapabilities()); 
        fluent.withDependencies(instance.getDependencies()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withProvider(instance.getProvider()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public RuntimeSpecBuilder(io.fabric8.camelk.v1.RuntimeSpec instance) {
        this(instance,true);
    }

    public RuntimeSpecBuilder(io.fabric8.camelk.v1.RuntimeSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApplicationClass(instance.getApplicationClass()); 
        this.withCapabilities(instance.getCapabilities()); 
        this.withDependencies(instance.getDependencies()); 
        this.withMetadata(instance.getMetadata()); 
        this.withProvider(instance.getProvider()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableRuntimeSpec build() {
        EditableRuntimeSpec buildable = new EditableRuntimeSpec(fluent.getApplicationClass(),fluent.getCapabilities(),fluent.getDependencies(),fluent.getMetadata(),fluent.getProvider(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RuntimeSpecBuilder that = (RuntimeSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
