package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class IntegrationPlatformStatusFluentImpl<A extends io.fabric8.camelk.v1.IntegrationPlatformStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.camelk.v1.IntegrationPlatformStatusFluent<A> {

    private io.fabric8.camelk.v1.IntegrationPlatformBuildSpecBuilder build;
    private java.lang.String cluster;
    private java.util.List<io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder> conditions;
    private java.util.List<io.fabric8.camelk.v1.ConfigurationSpecBuilder> configuration;
    private io.fabric8.camelk.v1.IntegrationPlatformKameletSpecBuilder kamelet;
    private java.lang.String phase;
    private java.lang.String profile;
    private io.fabric8.camelk.v1.IntegrationPlatformResourcesSpecBuilder resources;
    private java.util.Map<java.lang.String,io.fabric8.camelk.v1.TraitSpec> traits;
    private java.lang.String version;

    public IntegrationPlatformStatusFluentImpl() {
    }

    public IntegrationPlatformStatusFluentImpl(io.fabric8.camelk.v1.IntegrationPlatformStatus instance) {
        this.withBuild(instance.getBuild()); 
        this.withCluster(instance.getCluster()); 
        this.withConditions(instance.getConditions()); 
        this.withConfiguration(instance.getConfiguration()); 
        this.withKamelet(instance.getKamelet()); 
        this.withPhase(instance.getPhase()); 
        this.withProfile(instance.getProfile()); 
        this.withResources(instance.getResources()); 
        this.withTraits(instance.getTraits()); 
        this.withVersion(instance.getVersion()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBuild instead.
     * @return The buildable object.
     */
        public io.fabric8.camelk.v1.IntegrationPlatformBuildSpec getBuild() {
        return this.build!=null?this.build.build():null;
    }

    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpec buildBuild() {
        return this.build!=null?this.build.build():null;
    }

    public A withBuild(io.fabric8.camelk.v1.IntegrationPlatformBuildSpec build) {
        _visitables.get("build").remove(this.build);
        if (build!=null){ this.build= new io.fabric8.camelk.v1.IntegrationPlatformBuildSpecBuilder(build); _visitables.get("build").add(this.build);} return (A) this;
    }

    public java.lang.Boolean hasBuild() {
        return this.build != null;
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.BuildNested<A> withNewBuild() {
        return new io.fabric8.camelk.v1.IntegrationPlatformStatusFluentImpl.BuildNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.BuildNested<A> withNewBuildLike(io.fabric8.camelk.v1.IntegrationPlatformBuildSpec item) {
        return new io.fabric8.camelk.v1.IntegrationPlatformStatusFluentImpl.BuildNestedImpl(item);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.BuildNested<A> editBuild() {
        return withNewBuildLike(getBuild());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.BuildNested<A> editOrNewBuild() {
        return withNewBuildLike(getBuild() != null ? getBuild(): new io.fabric8.camelk.v1.IntegrationPlatformBuildSpecBuilder().build());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.BuildNested<A> editOrNewBuildLike(io.fabric8.camelk.v1.IntegrationPlatformBuildSpec item) {
        return withNewBuildLike(getBuild() != null ? getBuild(): item);
    }

    public java.lang.String getCluster() {
        return this.cluster;
    }

    public A withCluster(java.lang.String cluster) {
        this.cluster=cluster; return (A) this;
    }

    public java.lang.Boolean hasCluster() {
        return this.cluster != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withCluster instead.
     */
        public A withNewCluster(java.lang.String arg0) {
        return (A)withCluster(new String(arg0));
    }

    public A addToConditions(int index,io.fabric8.camelk.v1.IntegrationPlatformCondition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder>();}
        io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.fabric8.camelk.v1.IntegrationPlatformCondition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder>();}
        io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(io.fabric8.camelk.v1.IntegrationPlatformCondition... items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder>();}
        for (io.fabric8.camelk.v1.IntegrationPlatformCondition item : items) {io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(java.util.Collection<io.fabric8.camelk.v1.IntegrationPlatformCondition> items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder>();}
        for (io.fabric8.camelk.v1.IntegrationPlatformCondition item : items) {io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.camelk.v1.IntegrationPlatformCondition... items) {
        for (io.fabric8.camelk.v1.IntegrationPlatformCondition item : items) {io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(java.util.Collection<io.fabric8.camelk.v1.IntegrationPlatformCondition> items) {
        for (io.fabric8.camelk.v1.IntegrationPlatformCondition item : items) {io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConditions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.camelk.v1.IntegrationPlatformCondition> getConditions() {
        return build(conditions);
    }

    public java.util.List<io.fabric8.camelk.v1.IntegrationPlatformCondition> buildConditions() {
        return build(conditions);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder> predicate) {
        for (io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder> predicate) {
        for (io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(java.util.List<io.fabric8.camelk.v1.IntegrationPlatformCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder>(); for (io.fabric8.camelk.v1.IntegrationPlatformCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.camelk.v1.IntegrationPlatformCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.camelk.v1.IntegrationPlatformCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public java.lang.Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConditionsNested<A> addNewCondition() {
        return new io.fabric8.camelk.v1.IntegrationPlatformStatusFluentImpl.ConditionsNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.camelk.v1.IntegrationPlatformCondition item) {
        return new io.fabric8.camelk.v1.IntegrationPlatformStatusFluentImpl.ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.camelk.v1.IntegrationPlatformCondition item) {
        return new io.fabric8.camelk.v1.IntegrationPlatformStatusFluentImpl.ConditionsNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public A addToConfiguration(int index,io.fabric8.camelk.v1.ConfigurationSpec item) {
        if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
        io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(index >= 0 ? index : _visitables.get("configuration").size(), builder);this.configuration.add(index >= 0 ? index : configuration.size(), builder); return (A)this;
    }

    public A setToConfiguration(int index,io.fabric8.camelk.v1.ConfigurationSpec item) {
        if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
        io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("configuration").size()) { _visitables.get("configuration").add(builder); } else { _visitables.get("configuration").set(index, builder);}
        if (index < 0 || index >= configuration.size()) { configuration.add(builder); } else { configuration.set(index, builder);}
         return (A)this;
    }

    public A addToConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
        if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
        for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
    }

    public A addAllToConfiguration(java.util.Collection<io.fabric8.camelk.v1.ConfigurationSpec> items) {
        if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
        for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
    }

    public A removeFromConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
        for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
    }

    public A removeAllFromConfiguration(java.util.Collection<io.fabric8.camelk.v1.ConfigurationSpec> items) {
        for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
        if (configuration == null) return (A) this;
        final Iterator<io.fabric8.camelk.v1.ConfigurationSpecBuilder> each = configuration.iterator();
        final List visitables = _visitables.get("configuration");
        while (each.hasNext()) {
          io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConfiguration instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.camelk.v1.ConfigurationSpec> getConfiguration() {
        return build(configuration);
    }

    public java.util.List<io.fabric8.camelk.v1.ConfigurationSpec> buildConfiguration() {
        return build(configuration);
    }

    public io.fabric8.camelk.v1.ConfigurationSpec buildConfiguration(int index) {
        return this.configuration.get(index).build();
    }

    public io.fabric8.camelk.v1.ConfigurationSpec buildFirstConfiguration() {
        return this.configuration.get(0).build();
    }

    public io.fabric8.camelk.v1.ConfigurationSpec buildLastConfiguration() {
        return this.configuration.get(configuration.size() - 1).build();
    }

    public io.fabric8.camelk.v1.ConfigurationSpec buildMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
        for (io.fabric8.camelk.v1.ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
        for (io.fabric8.camelk.v1.ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConfiguration(java.util.List<io.fabric8.camelk.v1.ConfigurationSpec> configuration) {
        if (this.configuration != null) { _visitables.get("configuration").removeAll(this.configuration);}
        if (configuration != null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>(); for (io.fabric8.camelk.v1.ConfigurationSpec item : configuration){this.addToConfiguration(item);}} else { this.configuration = null;} return (A) this;
    }

    public A withConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... configuration) {
        if (this.configuration != null) {this.configuration.clear();}
        if (configuration != null) {for (io.fabric8.camelk.v1.ConfigurationSpec item :configuration){ this.addToConfiguration(item);}} return (A) this;
    }

    public java.lang.Boolean hasConfiguration() {
        return configuration != null && !configuration.isEmpty();
    }

    public A addNewConfiguration(java.lang.String type,java.lang.String value) {
        return (A)addToConfiguration(new ConfigurationSpec(type, value));
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConfigurationNested<A> addNewConfiguration() {
        return new io.fabric8.camelk.v1.IntegrationPlatformStatusFluentImpl.ConfigurationNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConfigurationNested<A> addNewConfigurationLike(io.fabric8.camelk.v1.ConfigurationSpec item) {
        return new io.fabric8.camelk.v1.IntegrationPlatformStatusFluentImpl.ConfigurationNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConfigurationNested<A> setNewConfigurationLike(int index,io.fabric8.camelk.v1.ConfigurationSpec item) {
        return new io.fabric8.camelk.v1.IntegrationPlatformStatusFluentImpl.ConfigurationNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConfigurationNested<A> editConfiguration(int index) {
        if (configuration.size() <= index) throw new RuntimeException("Can't edit configuration. Index exceeds size.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConfigurationNested<A> editFirstConfiguration() {
        if (configuration.size() == 0) throw new RuntimeException("Can't edit first configuration. The list is empty.");
        return setNewConfigurationLike(0, buildConfiguration(0));
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConfigurationNested<A> editLastConfiguration() {
        int index = configuration.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last configuration. The list is empty.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConfigurationNested<A> editMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<configuration.size();i++) { 
        if (predicate.test(configuration.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching configuration. No match found.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildKamelet instead.
     * @return The buildable object.
     */
        public io.fabric8.camelk.v1.IntegrationPlatformKameletSpec getKamelet() {
        return this.kamelet!=null?this.kamelet.build():null;
    }

    public io.fabric8.camelk.v1.IntegrationPlatformKameletSpec buildKamelet() {
        return this.kamelet!=null?this.kamelet.build():null;
    }

    public A withKamelet(io.fabric8.camelk.v1.IntegrationPlatformKameletSpec kamelet) {
        _visitables.get("kamelet").remove(this.kamelet);
        if (kamelet!=null){ this.kamelet= new io.fabric8.camelk.v1.IntegrationPlatformKameletSpecBuilder(kamelet); _visitables.get("kamelet").add(this.kamelet);} return (A) this;
    }

    public java.lang.Boolean hasKamelet() {
        return this.kamelet != null;
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.KameletNested<A> withNewKamelet() {
        return new io.fabric8.camelk.v1.IntegrationPlatformStatusFluentImpl.KameletNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.KameletNested<A> withNewKameletLike(io.fabric8.camelk.v1.IntegrationPlatformKameletSpec item) {
        return new io.fabric8.camelk.v1.IntegrationPlatformStatusFluentImpl.KameletNestedImpl(item);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.KameletNested<A> editKamelet() {
        return withNewKameletLike(getKamelet());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.KameletNested<A> editOrNewKamelet() {
        return withNewKameletLike(getKamelet() != null ? getKamelet(): new io.fabric8.camelk.v1.IntegrationPlatformKameletSpecBuilder().build());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.KameletNested<A> editOrNewKameletLike(io.fabric8.camelk.v1.IntegrationPlatformKameletSpec item) {
        return withNewKameletLike(getKamelet() != null ? getKamelet(): item);
    }

    public java.lang.String getPhase() {
        return this.phase;
    }

    public A withPhase(java.lang.String phase) {
        this.phase=phase; return (A) this;
    }

    public java.lang.Boolean hasPhase() {
        return this.phase != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPhase instead.
     */
        public A withNewPhase(java.lang.String arg0) {
        return (A)withPhase(new String(arg0));
    }

    public java.lang.String getProfile() {
        return this.profile;
    }

    public A withProfile(java.lang.String profile) {
        this.profile=profile; return (A) this;
    }

    public java.lang.Boolean hasProfile() {
        return this.profile != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withProfile instead.
     */
        public A withNewProfile(java.lang.String arg0) {
        return (A)withProfile(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildResources instead.
     * @return The buildable object.
     */
        public io.fabric8.camelk.v1.IntegrationPlatformResourcesSpec getResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public io.fabric8.camelk.v1.IntegrationPlatformResourcesSpec buildResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public A withResources(io.fabric8.camelk.v1.IntegrationPlatformResourcesSpec resources) {
        _visitables.get("resources").remove(this.resources);
        if (resources!=null){ this.resources= new io.fabric8.camelk.v1.IntegrationPlatformResourcesSpecBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
    }

    public java.lang.Boolean hasResources() {
        return this.resources != null;
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ResourcesNested<A> withNewResources() {
        return new io.fabric8.camelk.v1.IntegrationPlatformStatusFluentImpl.ResourcesNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ResourcesNested<A> withNewResourcesLike(io.fabric8.camelk.v1.IntegrationPlatformResourcesSpec item) {
        return new io.fabric8.camelk.v1.IntegrationPlatformStatusFluentImpl.ResourcesNestedImpl(item);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ResourcesNested<A> editResources() {
        return withNewResourcesLike(getResources());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ResourcesNested<A> editOrNewResources() {
        return withNewResourcesLike(getResources() != null ? getResources(): new io.fabric8.camelk.v1.IntegrationPlatformResourcesSpecBuilder().build());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ResourcesNested<A> editOrNewResourcesLike(io.fabric8.camelk.v1.IntegrationPlatformResourcesSpec item) {
        return withNewResourcesLike(getResources() != null ? getResources(): item);
    }

    public A addToTraits(java.lang.String key,io.fabric8.camelk.v1.TraitSpec value) {
        if(this.traits == null && key != null && value != null) { this.traits = new java.util.LinkedHashMap<java.lang.String,io.fabric8.camelk.v1.TraitSpec>(); }
        if(key != null && value != null) {this.traits.put(key, value);} return (A)this;
    }

    public A addToTraits(java.util.Map<java.lang.String,io.fabric8.camelk.v1.TraitSpec> map) {
        if(this.traits == null && map != null) { this.traits = new java.util.LinkedHashMap<java.lang.String,io.fabric8.camelk.v1.TraitSpec>(); }
        if(map != null) { this.traits.putAll(map);} return (A)this;
    }

    public A removeFromTraits(java.lang.String key) {
        if(this.traits == null) { return (A) this; }
        if(key != null && this.traits != null) {this.traits.remove(key);} return (A)this;
    }

    public A removeFromTraits(java.util.Map<java.lang.String,io.fabric8.camelk.v1.TraitSpec> map) {
        if(this.traits == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.traits != null){this.traits.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,io.fabric8.camelk.v1.TraitSpec> getTraits() {
        return this.traits;
    }

    public <K,V>A withTraits(java.util.Map<java.lang.String,io.fabric8.camelk.v1.TraitSpec> traits) {
        if (traits == null) { this.traits =  null;} else {this.traits = new java.util.LinkedHashMap<java.lang.String,io.fabric8.camelk.v1.TraitSpec>(traits);} return (A) this;
    }

    public java.lang.Boolean hasTraits() {
        return this.traits != null;
    }

    public java.lang.String getVersion() {
        return this.version;
    }

    public A withVersion(java.lang.String version) {
        this.version=version; return (A) this;
    }

    public java.lang.Boolean hasVersion() {
        return this.version != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withVersion instead.
     */
        public A withNewVersion(java.lang.String arg0) {
        return (A)withVersion(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IntegrationPlatformStatusFluentImpl that = (IntegrationPlatformStatusFluentImpl) o;
        if (build != null ? !build.equals(that.build) :that.build != null) return false;
        if (cluster != null ? !cluster.equals(that.cluster) :that.cluster != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
        if (kamelet != null ? !kamelet.equals(that.kamelet) :that.kamelet != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (traits != null ? !traits.equals(that.traits) :that.traits != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(build,  cluster,  conditions,  configuration,  kamelet,  phase,  profile,  resources,  traits,  version,  super.hashCode());
    }

    public class BuildNestedImpl<N> extends io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluentImpl<io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.BuildNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.BuildNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.IntegrationPlatformBuildSpecBuilder builder;

            BuildNestedImpl(io.fabric8.camelk.v1.IntegrationPlatformBuildSpec item) {
                this.builder = new io.fabric8.camelk.v1.IntegrationPlatformBuildSpecBuilder(this, item);
                        
            }

            BuildNestedImpl() {
                this.builder = new io.fabric8.camelk.v1.IntegrationPlatformBuildSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformStatusFluentImpl.this.withBuild(builder.build());
            }

            public N endBuild() {
                return and();
            }
    }


    public class ConditionsNestedImpl<N> extends io.fabric8.camelk.v1.IntegrationPlatformConditionFluentImpl<io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConditionsNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,io.fabric8.camelk.v1.IntegrationPlatformCondition item) {
                this.index = index;
                this.builder = new io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.camelk.v1.IntegrationPlatformConditionBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class ConfigurationNestedImpl<N> extends io.fabric8.camelk.v1.ConfigurationSpecFluentImpl<io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConfigurationNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.ConfigurationSpecBuilder builder;
        private final int index;

            ConfigurationNestedImpl(int index,io.fabric8.camelk.v1.ConfigurationSpec item) {
                this.index = index;
                this.builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(this, item);
                        
            }

            ConfigurationNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformStatusFluentImpl.this.setToConfiguration(index,builder.build());
            }

            public N endConfiguration() {
                return and();
            }
    }


    public class KameletNestedImpl<N> extends io.fabric8.camelk.v1.IntegrationPlatformKameletSpecFluentImpl<io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.KameletNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.KameletNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.IntegrationPlatformKameletSpecBuilder builder;

            KameletNestedImpl(io.fabric8.camelk.v1.IntegrationPlatformKameletSpec item) {
                this.builder = new io.fabric8.camelk.v1.IntegrationPlatformKameletSpecBuilder(this, item);
                        
            }

            KameletNestedImpl() {
                this.builder = new io.fabric8.camelk.v1.IntegrationPlatformKameletSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformStatusFluentImpl.this.withKamelet(builder.build());
            }

            public N endKamelet() {
                return and();
            }
    }


    public class ResourcesNestedImpl<N> extends io.fabric8.camelk.v1.IntegrationPlatformResourcesSpecFluentImpl<io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ResourcesNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformStatusFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.IntegrationPlatformResourcesSpecBuilder builder;

            ResourcesNestedImpl(io.fabric8.camelk.v1.IntegrationPlatformResourcesSpec item) {
                this.builder = new io.fabric8.camelk.v1.IntegrationPlatformResourcesSpecBuilder(this, item);
                        
            }

            ResourcesNestedImpl() {
                this.builder = new io.fabric8.camelk.v1.IntegrationPlatformResourcesSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformStatusFluentImpl.this.withResources(builder.build());
            }

            public N endResources() {
                return and();
            }
    }


}
