package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationPlatformBuildSpecBuilder extends io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluentImpl<io.fabric8.camelk.v1.IntegrationPlatformBuildSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.IntegrationPlatformBuildSpec,io.fabric8.camelk.v1.IntegrationPlatformBuildSpecBuilder> {

    io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IntegrationPlatformBuildSpecBuilder() {
        this(true);
    }

    public IntegrationPlatformBuildSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new IntegrationPlatformBuildSpec(), validationEnabled);
    }

    public IntegrationPlatformBuildSpecBuilder(io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationPlatformBuildSpecBuilder(io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IntegrationPlatformBuildSpec(), validationEnabled);
    }

    public IntegrationPlatformBuildSpecBuilder(io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent<?> fluent,io.fabric8.camelk.v1.IntegrationPlatformBuildSpec instance) {
        this(fluent, instance, true);
    }

    public IntegrationPlatformBuildSpecBuilder(io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent<?> fluent,io.fabric8.camelk.v1.IntegrationPlatformBuildSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBaseImage(instance.getBaseImage()); 
        fluent.withBuildStrategy(instance.getBuildStrategy()); 
        fluent.withHttpProxySecret(instance.getHttpProxySecret()); 
        fluent.withKanikoBuildCache(instance.getKanikoBuildCache()); 
        fluent.withMaven(instance.getMaven()); 
        fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
        fluent.withProperties(instance.getProperties()); 
        fluent.withPublishStrategy(instance.getPublishStrategy()); 
        fluent.withRegistry(instance.getRegistry()); 
        fluent.withRuntimeProvider(instance.getRuntimeProvider()); 
        fluent.withRuntimeVersion(instance.getRuntimeVersion()); 
        fluent.withTimeout(instance.getTimeout()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationPlatformBuildSpecBuilder(io.fabric8.camelk.v1.IntegrationPlatformBuildSpec instance) {
        this(instance,true);
    }

    public IntegrationPlatformBuildSpecBuilder(io.fabric8.camelk.v1.IntegrationPlatformBuildSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withBaseImage(instance.getBaseImage()); 
        this.withBuildStrategy(instance.getBuildStrategy()); 
        this.withHttpProxySecret(instance.getHttpProxySecret()); 
        this.withKanikoBuildCache(instance.getKanikoBuildCache()); 
        this.withMaven(instance.getMaven()); 
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
        this.withProperties(instance.getProperties()); 
        this.withPublishStrategy(instance.getPublishStrategy()); 
        this.withRegistry(instance.getRegistry()); 
        this.withRuntimeProvider(instance.getRuntimeProvider()); 
        this.withRuntimeVersion(instance.getRuntimeVersion()); 
        this.withTimeout(instance.getTimeout()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationPlatformBuildSpec build() {
        EditableIntegrationPlatformBuildSpec buildable = new EditableIntegrationPlatformBuildSpec(fluent.getBaseImage(),fluent.getBuildStrategy(),fluent.getHttpProxySecret(),fluent.getKanikoBuildCache(),fluent.getMaven(),fluent.getPersistentVolumeClaim(),fluent.getProperties(),fluent.getPublishStrategy(),fluent.getRegistry(),fluent.getRuntimeProvider(),fluent.getRuntimeVersion(),fluent.getTimeout());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationPlatformBuildSpecBuilder that = (IntegrationPlatformBuildSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
