package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ArtifactBuilder extends io.fabric8.camelk.v1.ArtifactFluentImpl<io.fabric8.camelk.v1.ArtifactBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.Artifact,io.fabric8.camelk.v1.ArtifactBuilder> {

    io.fabric8.camelk.v1.ArtifactFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ArtifactBuilder() {
        this(true);
    }

    public ArtifactBuilder(java.lang.Boolean validationEnabled) {
        this(new Artifact(), validationEnabled);
    }

    public ArtifactBuilder(io.fabric8.camelk.v1.ArtifactFluent<?> fluent) {
        this(fluent, true);
    }

    public ArtifactBuilder(io.fabric8.camelk.v1.ArtifactFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Artifact(), validationEnabled);
    }

    public ArtifactBuilder(io.fabric8.camelk.v1.ArtifactFluent<?> fluent,io.fabric8.camelk.v1.Artifact instance) {
        this(fluent, instance, true);
    }

    public ArtifactBuilder(io.fabric8.camelk.v1.ArtifactFluent<?> fluent,io.fabric8.camelk.v1.Artifact instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withChecksum(instance.getChecksum()); 
        fluent.withId(instance.getId()); 
        fluent.withLocation(instance.getLocation()); 
        fluent.withTarget(instance.getTarget()); 
        this.validationEnabled = validationEnabled; 
    }

    public ArtifactBuilder(io.fabric8.camelk.v1.Artifact instance) {
        this(instance,true);
    }

    public ArtifactBuilder(io.fabric8.camelk.v1.Artifact instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withChecksum(instance.getChecksum()); 
        this.withId(instance.getId()); 
        this.withLocation(instance.getLocation()); 
        this.withTarget(instance.getTarget()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableArtifact build() {
        EditableArtifact buildable = new EditableArtifact(fluent.getChecksum(),fluent.getId(),fluent.getLocation(),fluent.getTarget());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ArtifactBuilder that = (ArtifactBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
