package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationKitListBuilder extends io.fabric8.camelk.v1.IntegrationKitListFluentImpl<io.fabric8.camelk.v1.IntegrationKitListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.IntegrationKitList,io.fabric8.camelk.v1.IntegrationKitListBuilder> {

    io.fabric8.camelk.v1.IntegrationKitListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IntegrationKitListBuilder() {
        this(true);
    }

    public IntegrationKitListBuilder(java.lang.Boolean validationEnabled) {
        this(new IntegrationKitList(), validationEnabled);
    }

    public IntegrationKitListBuilder(io.fabric8.camelk.v1.IntegrationKitListFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationKitListBuilder(io.fabric8.camelk.v1.IntegrationKitListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IntegrationKitList(), validationEnabled);
    }

    public IntegrationKitListBuilder(io.fabric8.camelk.v1.IntegrationKitListFluent<?> fluent,io.fabric8.camelk.v1.IntegrationKitList instance) {
        this(fluent, instance, true);
    }

    public IntegrationKitListBuilder(io.fabric8.camelk.v1.IntegrationKitListFluent<?> fluent,io.fabric8.camelk.v1.IntegrationKitList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationKitListBuilder(io.fabric8.camelk.v1.IntegrationKitList instance) {
        this(instance,true);
    }

    public IntegrationKitListBuilder(io.fabric8.camelk.v1.IntegrationKitList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationKitList build() {
        EditableIntegrationKitList buildable = new EditableIntegrationKitList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationKitListBuilder that = (IntegrationKitListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
