/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.Artifact;
import io.fabric8.camelk.v1.ArtifactBuilder;
import io.fabric8.camelk.v1.ArtifactFluentImpl;
import io.fabric8.camelk.v1.Failure;
import io.fabric8.camelk.v1.FailureBuilder;
import io.fabric8.camelk.v1.FailureFluentImpl;
import io.fabric8.camelk.v1.IntegrationKitCondition;
import io.fabric8.camelk.v1.IntegrationKitConditionBuilder;
import io.fabric8.camelk.v1.IntegrationKitConditionFluentImpl;
import io.fabric8.camelk.v1.IntegrationKitStatus;
import io.fabric8.camelk.v1.IntegrationKitStatusFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IntegrationKitStatusFluentImpl<A extends IntegrationKitStatusFluent<A>>
extends BaseFluent<A>
implements IntegrationKitStatusFluent<A> {
    private List<ArtifactBuilder> artifacts;
    private String baseImage;
    private List<IntegrationKitConditionBuilder> conditions;
    private String digest;
    private FailureBuilder failure;
    private String image;
    private String phase;
    private String platform;
    private String runtimeProvider;
    private String runtimeVersion;
    private String version;

    public IntegrationKitStatusFluentImpl() {
    }

    public IntegrationKitStatusFluentImpl(IntegrationKitStatus instance) {
        this.withArtifacts(instance.getArtifacts());
        this.withBaseImage(instance.getBaseImage());
        this.withConditions(instance.getConditions());
        this.withDigest(instance.getDigest());
        this.withFailure(instance.getFailure());
        this.withImage(instance.getImage());
        this.withPhase(instance.getPhase());
        this.withPlatform(instance.getPlatform());
        this.withRuntimeProvider(instance.getRuntimeProvider());
        this.withRuntimeVersion(instance.getRuntimeVersion());
        this.withVersion(instance.getVersion());
    }

    @Override
    public A addToArtifacts(int index, Artifact item) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<ArtifactBuilder>();
        }
        ArtifactBuilder builder = new ArtifactBuilder(item);
        this._visitables.get((Object)"artifacts").add(index >= 0 ? index : this._visitables.get((Object)"artifacts").size(), builder);
        this.artifacts.add(index >= 0 ? index : this.artifacts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToArtifacts(int index, Artifact item) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<ArtifactBuilder>();
        }
        ArtifactBuilder builder = new ArtifactBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"artifacts").size()) {
            this._visitables.get((Object)"artifacts").add(builder);
        } else {
            this._visitables.get((Object)"artifacts").set(index, builder);
        }
        if (index < 0 || index >= this.artifacts.size()) {
            this.artifacts.add(builder);
        } else {
            this.artifacts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToArtifacts(Artifact ... items) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<ArtifactBuilder>();
        }
        for (Artifact item : items) {
            ArtifactBuilder builder = new ArtifactBuilder(item);
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToArtifacts(Collection<Artifact> items) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<ArtifactBuilder>();
        }
        for (Artifact item : items) {
            ArtifactBuilder builder = new ArtifactBuilder(item);
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromArtifacts(Artifact ... items) {
        for (Artifact item : items) {
            ArtifactBuilder builder = new ArtifactBuilder(item);
            this._visitables.get((Object)"artifacts").remove(builder);
            if (this.artifacts == null) continue;
            this.artifacts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromArtifacts(Collection<Artifact> items) {
        for (Artifact item : items) {
            ArtifactBuilder builder = new ArtifactBuilder(item);
            this._visitables.get((Object)"artifacts").remove(builder);
            if (this.artifacts == null) continue;
            this.artifacts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromArtifacts(Predicate<ArtifactBuilder> predicate) {
        if (this.artifacts == null) {
            return (A)this;
        }
        Iterator<ArtifactBuilder> each = this.artifacts.iterator();
        List visitables = this._visitables.get((Object)"artifacts");
        while (each.hasNext()) {
            ArtifactBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Artifact> getArtifacts() {
        return IntegrationKitStatusFluentImpl.build(this.artifacts);
    }

    @Override
    public List<Artifact> buildArtifacts() {
        return IntegrationKitStatusFluentImpl.build(this.artifacts);
    }

    @Override
    public Artifact buildArtifact(int index) {
        return this.artifacts.get(index).build();
    }

    @Override
    public Artifact buildFirstArtifact() {
        return this.artifacts.get(0).build();
    }

    @Override
    public Artifact buildLastArtifact() {
        return this.artifacts.get(this.artifacts.size() - 1).build();
    }

    @Override
    public Artifact buildMatchingArtifact(Predicate<ArtifactBuilder> predicate) {
        for (ArtifactBuilder item : this.artifacts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingArtifact(Predicate<ArtifactBuilder> predicate) {
        for (ArtifactBuilder item : this.artifacts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withArtifacts(List<Artifact> artifacts) {
        if (this.artifacts != null) {
            this._visitables.get((Object)"artifacts").removeAll(this.artifacts);
        }
        if (artifacts != null) {
            this.artifacts = new ArrayList<ArtifactBuilder>();
            for (Artifact item : artifacts) {
                this.addToArtifacts(item);
            }
        } else {
            this.artifacts = null;
        }
        return (A)this;
    }

    @Override
    public A withArtifacts(Artifact ... artifacts) {
        if (this.artifacts != null) {
            this.artifacts.clear();
        }
        if (artifacts != null) {
            for (Artifact item : artifacts) {
                this.addToArtifacts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasArtifacts() {
        return this.artifacts != null && !this.artifacts.isEmpty();
    }

    @Override
    public A addNewArtifact(String checksum, String id, String location, String target) {
        return this.addToArtifacts(new Artifact(checksum, id, location, target));
    }

    @Override
    public IntegrationKitStatusFluent.ArtifactsNested<A> addNewArtifact() {
        return new ArtifactsNestedImpl();
    }

    @Override
    public IntegrationKitStatusFluent.ArtifactsNested<A> addNewArtifactLike(Artifact item) {
        return new ArtifactsNestedImpl(-1, item);
    }

    @Override
    public IntegrationKitStatusFluent.ArtifactsNested<A> setNewArtifactLike(int index, Artifact item) {
        return new ArtifactsNestedImpl(index, item);
    }

    @Override
    public IntegrationKitStatusFluent.ArtifactsNested<A> editArtifact(int index) {
        if (this.artifacts.size() <= index) {
            throw new RuntimeException("Can't edit artifacts. Index exceeds size.");
        }
        return this.setNewArtifactLike(index, this.buildArtifact(index));
    }

    @Override
    public IntegrationKitStatusFluent.ArtifactsNested<A> editFirstArtifact() {
        if (this.artifacts.size() == 0) {
            throw new RuntimeException("Can't edit first artifacts. The list is empty.");
        }
        return this.setNewArtifactLike(0, this.buildArtifact(0));
    }

    @Override
    public IntegrationKitStatusFluent.ArtifactsNested<A> editLastArtifact() {
        int index = this.artifacts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last artifacts. The list is empty.");
        }
        return this.setNewArtifactLike(index, this.buildArtifact(index));
    }

    @Override
    public IntegrationKitStatusFluent.ArtifactsNested<A> editMatchingArtifact(Predicate<ArtifactBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.artifacts.size(); ++i) {
            if (!predicate.test(this.artifacts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching artifacts. No match found.");
        }
        return this.setNewArtifactLike(index, this.buildArtifact(index));
    }

    @Override
    public String getBaseImage() {
        return this.baseImage;
    }

    @Override
    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)this;
    }

    @Override
    public Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    @Override
    @Deprecated
    public A withNewBaseImage(String arg0) {
        return this.withBaseImage(new String(arg0));
    }

    @Override
    public A addToConditions(int index, IntegrationKitCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IntegrationKitConditionBuilder>();
        }
        IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);
        this._visitables.get((Object)"conditions").add(index >= 0 ? index : this._visitables.get((Object)"conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, IntegrationKitCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IntegrationKitConditionBuilder>();
        }
        IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"conditions").size()) {
            this._visitables.get((Object)"conditions").add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(IntegrationKitCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IntegrationKitConditionBuilder>();
        }
        for (IntegrationKitCondition item : items) {
            IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<IntegrationKitCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IntegrationKitConditionBuilder>();
        }
        for (IntegrationKitCondition item : items) {
            IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(IntegrationKitCondition ... items) {
        for (IntegrationKitCondition item : items) {
            IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<IntegrationKitCondition> items) {
        for (IntegrationKitCondition item : items) {
            IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<IntegrationKitConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<IntegrationKitConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            IntegrationKitConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IntegrationKitCondition> getConditions() {
        return IntegrationKitStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<IntegrationKitCondition> buildConditions() {
        return IntegrationKitStatusFluentImpl.build(this.conditions);
    }

    @Override
    public IntegrationKitCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public IntegrationKitCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public IntegrationKitCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public IntegrationKitCondition buildMatchingCondition(Predicate<IntegrationKitConditionBuilder> predicate) {
        for (IntegrationKitConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<IntegrationKitConditionBuilder> predicate) {
        for (IntegrationKitConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<IntegrationKitCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<IntegrationKitConditionBuilder>();
            for (IntegrationKitCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(IntegrationKitCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (IntegrationKitCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public IntegrationKitStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public IntegrationKitStatusFluent.ConditionsNested<A> addNewConditionLike(IntegrationKitCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public IntegrationKitStatusFluent.ConditionsNested<A> setNewConditionLike(int index, IntegrationKitCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public IntegrationKitStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public IntegrationKitStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public IntegrationKitStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public IntegrationKitStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<IntegrationKitConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    @Override
    public A withDigest(String digest) {
        this.digest = digest;
        return (A)this;
    }

    @Override
    public Boolean hasDigest() {
        return this.digest != null;
    }

    @Override
    @Deprecated
    public A withNewDigest(String arg0) {
        return this.withDigest(new String(arg0));
    }

    @Override
    @Deprecated
    public Failure getFailure() {
        return this.failure != null ? this.failure.build() : null;
    }

    @Override
    public Failure buildFailure() {
        return this.failure != null ? this.failure.build() : null;
    }

    @Override
    public A withFailure(Failure failure) {
        this._visitables.get((Object)"failure").remove(this.failure);
        if (failure != null) {
            this.failure = new FailureBuilder(failure);
            this._visitables.get((Object)"failure").add(this.failure);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFailure() {
        return this.failure != null;
    }

    @Override
    public IntegrationKitStatusFluent.FailureNested<A> withNewFailure() {
        return new FailureNestedImpl();
    }

    @Override
    public IntegrationKitStatusFluent.FailureNested<A> withNewFailureLike(Failure item) {
        return new FailureNestedImpl(item);
    }

    @Override
    public IntegrationKitStatusFluent.FailureNested<A> editFailure() {
        return this.withNewFailureLike(this.getFailure());
    }

    @Override
    public IntegrationKitStatusFluent.FailureNested<A> editOrNewFailure() {
        return this.withNewFailureLike(this.getFailure() != null ? this.getFailure() : new FailureBuilder().build());
    }

    @Override
    public IntegrationKitStatusFluent.FailureNested<A> editOrNewFailureLike(Failure item) {
        return this.withNewFailureLike(this.getFailure() != null ? this.getFailure() : item);
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    @Deprecated
    public A withNewImage(String arg0) {
        return this.withImage(new String(arg0));
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    @Deprecated
    public A withNewPhase(String arg0) {
        return this.withPhase(new String(arg0));
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public A withPlatform(String platform) {
        this.platform = platform;
        return (A)this;
    }

    @Override
    public Boolean hasPlatform() {
        return this.platform != null;
    }

    @Override
    @Deprecated
    public A withNewPlatform(String arg0) {
        return this.withPlatform(new String(arg0));
    }

    @Override
    public String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    @Override
    public A withRuntimeProvider(String runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
        return (A)this;
    }

    @Override
    public Boolean hasRuntimeProvider() {
        return this.runtimeProvider != null;
    }

    @Override
    @Deprecated
    public A withNewRuntimeProvider(String arg0) {
        return this.withRuntimeProvider(new String(arg0));
    }

    @Override
    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    @Override
    public A withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return (A)this;
    }

    @Override
    public Boolean hasRuntimeVersion() {
        return this.runtimeVersion != null;
    }

    @Override
    @Deprecated
    public A withNewRuntimeVersion(String arg0) {
        return this.withRuntimeVersion(new String(arg0));
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    @Deprecated
    public A withNewVersion(String arg0) {
        return this.withVersion(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationKitStatusFluentImpl that = (IntegrationKitStatusFluentImpl)o;
        if (this.artifacts != null ? !this.artifacts.equals(that.artifacts) : that.artifacts != null) {
            return false;
        }
        if (this.baseImage != null ? !this.baseImage.equals(that.baseImage) : that.baseImage != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.digest != null ? !this.digest.equals(that.digest) : that.digest != null) {
            return false;
        }
        if (this.failure != null ? !this.failure.equals(that.failure) : that.failure != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) {
            return false;
        }
        if (this.runtimeProvider != null ? !this.runtimeProvider.equals(that.runtimeProvider) : that.runtimeProvider != null) {
            return false;
        }
        if (this.runtimeVersion != null ? !this.runtimeVersion.equals(that.runtimeVersion) : that.runtimeVersion != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return Objects.hash(this.artifacts, this.baseImage, this.conditions, this.digest, this.failure, this.image, this.phase, this.platform, this.runtimeProvider, this.runtimeVersion, this.version, super.hashCode());
    }

    public class FailureNestedImpl<N>
    extends FailureFluentImpl<IntegrationKitStatusFluent.FailureNested<N>>
    implements IntegrationKitStatusFluent.FailureNested<N>,
    Nested<N> {
        private final FailureBuilder builder;

        FailureNestedImpl(Failure item) {
            this.builder = new FailureBuilder(this, item);
        }

        FailureNestedImpl() {
            this.builder = new FailureBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationKitStatusFluentImpl.this.withFailure(this.builder.build());
        }

        @Override
        public N endFailure() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends IntegrationKitConditionFluentImpl<IntegrationKitStatusFluent.ConditionsNested<N>>
    implements IntegrationKitStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final IntegrationKitConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, IntegrationKitCondition item) {
            this.index = index;
            this.builder = new IntegrationKitConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new IntegrationKitConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationKitStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    public class ArtifactsNestedImpl<N>
    extends ArtifactFluentImpl<IntegrationKitStatusFluent.ArtifactsNested<N>>
    implements IntegrationKitStatusFluent.ArtifactsNested<N>,
    Nested<N> {
        private final ArtifactBuilder builder;
        private final int index;

        ArtifactsNestedImpl(int index, Artifact item) {
            this.index = index;
            this.builder = new ArtifactBuilder(this, item);
        }

        ArtifactsNestedImpl() {
            this.index = -1;
            this.builder = new ArtifactBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationKitStatusFluentImpl.this.setToArtifacts(this.index, this.builder.build());
        }

        @Override
        public N endArtifact() {
            return this.and();
        }
    }
}

