package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuildListBuilder extends io.fabric8.camelk.v1.BuildListFluentImpl<io.fabric8.camelk.v1.BuildListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.BuildList,io.fabric8.camelk.v1.BuildListBuilder> {

    io.fabric8.camelk.v1.BuildListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public BuildListBuilder() {
        this(true);
    }

    public BuildListBuilder(java.lang.Boolean validationEnabled) {
        this(new BuildList(), validationEnabled);
    }

    public BuildListBuilder(io.fabric8.camelk.v1.BuildListFluent<?> fluent) {
        this(fluent, true);
    }

    public BuildListBuilder(io.fabric8.camelk.v1.BuildListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new BuildList(), validationEnabled);
    }

    public BuildListBuilder(io.fabric8.camelk.v1.BuildListFluent<?> fluent,io.fabric8.camelk.v1.BuildList instance) {
        this(fluent, instance, true);
    }

    public BuildListBuilder(io.fabric8.camelk.v1.BuildListFluent<?> fluent,io.fabric8.camelk.v1.BuildList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuildListBuilder(io.fabric8.camelk.v1.BuildList instance) {
        this(instance,true);
    }

    public BuildListBuilder(io.fabric8.camelk.v1.BuildList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableBuildList build() {
        EditableBuildList buildable = new EditableBuildList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuildListBuilder that = (BuildListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
