package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceSpecBuilder extends io.fabric8.camelk.v1.ResourceSpecFluentImpl<io.fabric8.camelk.v1.ResourceSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.ResourceSpec,io.fabric8.camelk.v1.ResourceSpecBuilder> {

    io.fabric8.camelk.v1.ResourceSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ResourceSpecBuilder() {
        this(true);
    }

    public ResourceSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new ResourceSpec(), validationEnabled);
    }

    public ResourceSpecBuilder(io.fabric8.camelk.v1.ResourceSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ResourceSpecBuilder(io.fabric8.camelk.v1.ResourceSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ResourceSpec(), validationEnabled);
    }

    public ResourceSpecBuilder(io.fabric8.camelk.v1.ResourceSpecFluent<?> fluent,io.fabric8.camelk.v1.ResourceSpec instance) {
        this(fluent, instance, true);
    }

    public ResourceSpecBuilder(io.fabric8.camelk.v1.ResourceSpecFluent<?> fluent,io.fabric8.camelk.v1.ResourceSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCompression(instance.getCompression()); 
        fluent.withContent(instance.getContent()); 
        fluent.withContentKey(instance.getContentKey()); 
        fluent.withContentRef(instance.getContentRef()); 
        fluent.withMountPath(instance.getMountPath()); 
        fluent.withName(instance.getName()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public ResourceSpecBuilder(io.fabric8.camelk.v1.ResourceSpec instance) {
        this(instance,true);
    }

    public ResourceSpecBuilder(io.fabric8.camelk.v1.ResourceSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCompression(instance.getCompression()); 
        this.withContent(instance.getContent()); 
        this.withContentKey(instance.getContentKey()); 
        this.withContentRef(instance.getContentRef()); 
        this.withMountPath(instance.getMountPath()); 
        this.withName(instance.getName()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableResourceSpec build() {
        EditableResourceSpec buildable = new EditableResourceSpec(fluent.getCompression(),fluent.getContent(),fluent.getContentKey(),fluent.getContentRef(),fluent.getMountPath(),fluent.getName(),fluent.getType());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ResourceSpecBuilder that = (ResourceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
