package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

public class IntegrationStatusFluentImpl<A extends io.fabric8.camelk.v1.IntegrationStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.camelk.v1.IntegrationStatusFluent<A> {

    private java.util.List<java.lang.String> capabilities;
    private java.util.List<io.fabric8.camelk.v1.IntegrationConditionBuilder> conditions;
    private java.util.List<io.fabric8.camelk.v1.ConfigurationSpecBuilder> configuration;
    private java.util.List<java.lang.String> dependencies;
    private java.lang.String digest;
    private io.fabric8.camelk.v1.FailureBuilder failure;
    private java.util.List<io.fabric8.camelk.v1.ResourceSpecBuilder> generatedResources;
    private java.util.List<io.fabric8.camelk.v1.SourceSpecBuilder> generatedSources;
    private java.lang.String image;
    private java.lang.String kit;
    private java.lang.String lastInitTimestamp;
    private java.lang.String phase;
    private java.lang.String platform;
    private java.lang.String profile;
    private java.lang.Integer replicas;
    private java.lang.String runtimeProvider;
    private java.lang.String runtimeVersion;
    private java.lang.String selector;
    private java.lang.String version;

    public IntegrationStatusFluentImpl() {
    }

    public IntegrationStatusFluentImpl(io.fabric8.camelk.v1.IntegrationStatus instance) {
        this.withCapabilities(instance.getCapabilities()); 
        this.withConditions(instance.getConditions()); 
        this.withConfiguration(instance.getConfiguration()); 
        this.withDependencies(instance.getDependencies()); 
        this.withDigest(instance.getDigest()); 
        this.withFailure(instance.getFailure()); 
        this.withGeneratedResources(instance.getGeneratedResources()); 
        this.withGeneratedSources(instance.getGeneratedSources()); 
        this.withImage(instance.getImage()); 
        this.withKit(instance.getKit()); 
        this.withLastInitTimestamp(instance.getLastInitTimestamp()); 
        this.withPhase(instance.getPhase()); 
        this.withPlatform(instance.getPlatform()); 
        this.withProfile(instance.getProfile()); 
        this.withReplicas(instance.getReplicas()); 
        this.withRuntimeProvider(instance.getRuntimeProvider()); 
        this.withRuntimeVersion(instance.getRuntimeVersion()); 
        this.withSelector(instance.getSelector()); 
        this.withVersion(instance.getVersion()); 
    }

    public A addToCapabilities(int index,java.lang.String item) {
        if (this.capabilities == null) {this.capabilities = new java.util.ArrayList<java.lang.String>();}
        this.capabilities.add(index, item);
        return (A)this;
    }

    public A setToCapabilities(int index,java.lang.String item) {
        if (this.capabilities == null) {this.capabilities = new java.util.ArrayList<java.lang.String>();}
        this.capabilities.set(index, item); return (A)this;
    }

    public A addToCapabilities(java.lang.String... items) {
        if (this.capabilities == null) {this.capabilities = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.capabilities.add(item);} return (A)this;
    }

    public A addAllToCapabilities(java.util.Collection<java.lang.String> items) {
        if (this.capabilities == null) {this.capabilities = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.capabilities.add(item);} return (A)this;
    }

    public A removeFromCapabilities(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.capabilities!= null){ this.capabilities.remove(item);}} return (A)this;
    }

    public A removeAllFromCapabilities(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.capabilities!= null){ this.capabilities.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getCapabilities() {
        return this.capabilities;
    }

    public java.lang.String getCapability(int index) {
        return this.capabilities.get(index);
    }

    public java.lang.String getFirstCapability() {
        return this.capabilities.get(0);
    }

    public java.lang.String getLastCapability() {
        return this.capabilities.get(capabilities.size() - 1);
    }

    public java.lang.String getMatchingCapability(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: capabilities) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingCapability(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: capabilities) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withCapabilities(java.util.List<java.lang.String> capabilities) {
        if (this.capabilities != null) { _visitables.get("capabilities").removeAll(this.capabilities);}
        if (capabilities != null) {this.capabilities = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : capabilities){this.addToCapabilities(item);}} else { this.capabilities = null;} return (A) this;
    }

    public A withCapabilities(java.lang.String... capabilities) {
        if (this.capabilities != null) {this.capabilities.clear();}
        if (capabilities != null) {for (java.lang.String item :capabilities){ this.addToCapabilities(item);}} return (A) this;
    }

    public java.lang.Boolean hasCapabilities() {
        return capabilities != null && !capabilities.isEmpty();
    }

    public A addNewCapability(java.lang.String arg0) {
        return (A)addToCapabilities(new String(arg0));
    }

    public A addToConditions(int index,io.fabric8.camelk.v1.IntegrationCondition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.IntegrationConditionBuilder>();}
        io.fabric8.camelk.v1.IntegrationConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.fabric8.camelk.v1.IntegrationCondition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.IntegrationConditionBuilder>();}
        io.fabric8.camelk.v1.IntegrationConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(io.fabric8.camelk.v1.IntegrationCondition... items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.IntegrationConditionBuilder>();}
        for (io.fabric8.camelk.v1.IntegrationCondition item : items) {io.fabric8.camelk.v1.IntegrationConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(java.util.Collection<io.fabric8.camelk.v1.IntegrationCondition> items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.IntegrationConditionBuilder>();}
        for (io.fabric8.camelk.v1.IntegrationCondition item : items) {io.fabric8.camelk.v1.IntegrationConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.camelk.v1.IntegrationCondition... items) {
        for (io.fabric8.camelk.v1.IntegrationCondition item : items) {io.fabric8.camelk.v1.IntegrationConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(java.util.Collection<io.fabric8.camelk.v1.IntegrationCondition> items) {
        for (io.fabric8.camelk.v1.IntegrationCondition item : items) {io.fabric8.camelk.v1.IntegrationConditionBuilder builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.camelk.v1.IntegrationConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<io.fabric8.camelk.v1.IntegrationConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          io.fabric8.camelk.v1.IntegrationConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConditions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.camelk.v1.IntegrationCondition> getConditions() {
        return build(conditions);
    }

    public java.util.List<io.fabric8.camelk.v1.IntegrationCondition> buildConditions() {
        return build(conditions);
    }

    public io.fabric8.camelk.v1.IntegrationCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public io.fabric8.camelk.v1.IntegrationCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public io.fabric8.camelk.v1.IntegrationCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public io.fabric8.camelk.v1.IntegrationCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.camelk.v1.IntegrationConditionBuilder> predicate) {
        for (io.fabric8.camelk.v1.IntegrationConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.camelk.v1.IntegrationConditionBuilder> predicate) {
        for (io.fabric8.camelk.v1.IntegrationConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(java.util.List<io.fabric8.camelk.v1.IntegrationCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.camelk.v1.IntegrationConditionBuilder>(); for (io.fabric8.camelk.v1.IntegrationCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.camelk.v1.IntegrationCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.camelk.v1.IntegrationCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public java.lang.Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> addNewCondition() {
        return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.ConditionsNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.camelk.v1.IntegrationCondition item) {
        return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.camelk.v1.IntegrationCondition item) {
        return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.ConditionsNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.camelk.v1.IntegrationConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public A addToConfiguration(int index,io.fabric8.camelk.v1.ConfigurationSpec item) {
        if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
        io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(index >= 0 ? index : _visitables.get("configuration").size(), builder);this.configuration.add(index >= 0 ? index : configuration.size(), builder); return (A)this;
    }

    public A setToConfiguration(int index,io.fabric8.camelk.v1.ConfigurationSpec item) {
        if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
        io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("configuration").size()) { _visitables.get("configuration").add(builder); } else { _visitables.get("configuration").set(index, builder);}
        if (index < 0 || index >= configuration.size()) { configuration.add(builder); } else { configuration.set(index, builder);}
         return (A)this;
    }

    public A addToConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
        if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
        for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
    }

    public A addAllToConfiguration(java.util.Collection<io.fabric8.camelk.v1.ConfigurationSpec> items) {
        if (this.configuration == null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>();}
        for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
    }

    public A removeFromConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
        for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
    }

    public A removeAllFromConfiguration(java.util.Collection<io.fabric8.camelk.v1.ConfigurationSpec> items) {
        for (io.fabric8.camelk.v1.ConfigurationSpec item : items) {io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
        if (configuration == null) return (A) this;
        final Iterator<io.fabric8.camelk.v1.ConfigurationSpecBuilder> each = configuration.iterator();
        final List visitables = _visitables.get("configuration");
        while (each.hasNext()) {
          io.fabric8.camelk.v1.ConfigurationSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConfiguration instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.camelk.v1.ConfigurationSpec> getConfiguration() {
        return build(configuration);
    }

    public java.util.List<io.fabric8.camelk.v1.ConfigurationSpec> buildConfiguration() {
        return build(configuration);
    }

    public io.fabric8.camelk.v1.ConfigurationSpec buildConfiguration(int index) {
        return this.configuration.get(index).build();
    }

    public io.fabric8.camelk.v1.ConfigurationSpec buildFirstConfiguration() {
        return this.configuration.get(0).build();
    }

    public io.fabric8.camelk.v1.ConfigurationSpec buildLastConfiguration() {
        return this.configuration.get(configuration.size() - 1).build();
    }

    public io.fabric8.camelk.v1.ConfigurationSpec buildMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
        for (io.fabric8.camelk.v1.ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
        for (io.fabric8.camelk.v1.ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConfiguration(java.util.List<io.fabric8.camelk.v1.ConfigurationSpec> configuration) {
        if (this.configuration != null) { _visitables.get("configuration").removeAll(this.configuration);}
        if (configuration != null) {this.configuration = new java.util.ArrayList<io.fabric8.camelk.v1.ConfigurationSpecBuilder>(); for (io.fabric8.camelk.v1.ConfigurationSpec item : configuration){this.addToConfiguration(item);}} else { this.configuration = null;} return (A) this;
    }

    public A withConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... configuration) {
        if (this.configuration != null) {this.configuration.clear();}
        if (configuration != null) {for (io.fabric8.camelk.v1.ConfigurationSpec item :configuration){ this.addToConfiguration(item);}} return (A) this;
    }

    public java.lang.Boolean hasConfiguration() {
        return configuration != null && !configuration.isEmpty();
    }

    public A addNewConfiguration(java.lang.String type,java.lang.String value) {
        return (A)addToConfiguration(new ConfigurationSpec(type, value));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> addNewConfiguration() {
        return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.ConfigurationNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> addNewConfigurationLike(io.fabric8.camelk.v1.ConfigurationSpec item) {
        return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.ConfigurationNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> setNewConfigurationLike(int index,io.fabric8.camelk.v1.ConfigurationSpec item) {
        return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.ConfigurationNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> editConfiguration(int index) {
        if (configuration.size() <= index) throw new RuntimeException("Can't edit configuration. Index exceeds size.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> editFirstConfiguration() {
        if (configuration.size() == 0) throw new RuntimeException("Can't edit first configuration. The list is empty.");
        return setNewConfigurationLike(0, buildConfiguration(0));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> editLastConfiguration() {
        int index = configuration.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last configuration. The list is empty.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<A> editMatchingConfiguration(java.util.function.Predicate<io.fabric8.camelk.v1.ConfigurationSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<configuration.size();i++) { 
        if (predicate.test(configuration.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching configuration. No match found.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public A addToDependencies(int index,java.lang.String item) {
        if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
        this.dependencies.add(index, item);
        return (A)this;
    }

    public A setToDependencies(int index,java.lang.String item) {
        if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
        this.dependencies.set(index, item); return (A)this;
    }

    public A addToDependencies(java.lang.String... items) {
        if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.dependencies.add(item);} return (A)this;
    }

    public A addAllToDependencies(java.util.Collection<java.lang.String> items) {
        if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.dependencies.add(item);} return (A)this;
    }

    public A removeFromDependencies(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
    }

    public A removeAllFromDependencies(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getDependencies() {
        return this.dependencies;
    }

    public java.lang.String getDependency(int index) {
        return this.dependencies.get(index);
    }

    public java.lang.String getFirstDependency() {
        return this.dependencies.get(0);
    }

    public java.lang.String getLastDependency() {
        return this.dependencies.get(dependencies.size() - 1);
    }

    public java.lang.String getMatchingDependency(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingDependency(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDependencies(java.util.List<java.lang.String> dependencies) {
        if (this.dependencies != null) { _visitables.get("dependencies").removeAll(this.dependencies);}
        if (dependencies != null) {this.dependencies = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
    }

    public A withDependencies(java.lang.String... dependencies) {
        if (this.dependencies != null) {this.dependencies.clear();}
        if (dependencies != null) {for (java.lang.String item :dependencies){ this.addToDependencies(item);}} return (A) this;
    }

    public java.lang.Boolean hasDependencies() {
        return dependencies != null && !dependencies.isEmpty();
    }

    public A addNewDependency(java.lang.String arg0) {
        return (A)addToDependencies(new String(arg0));
    }

    public java.lang.String getDigest() {
        return this.digest;
    }

    public A withDigest(java.lang.String digest) {
        this.digest=digest; return (A) this;
    }

    public java.lang.Boolean hasDigest() {
        return this.digest != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withDigest instead.
     */
        public A withNewDigest(java.lang.String arg0) {
        return (A)withDigest(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildFailure instead.
     * @return The buildable object.
     */
        public io.fabric8.camelk.v1.Failure getFailure() {
        return this.failure!=null?this.failure.build():null;
    }

    public io.fabric8.camelk.v1.Failure buildFailure() {
        return this.failure!=null?this.failure.build():null;
    }

    public A withFailure(io.fabric8.camelk.v1.Failure failure) {
        _visitables.get("failure").remove(this.failure);
        if (failure!=null){ this.failure= new io.fabric8.camelk.v1.FailureBuilder(failure); _visitables.get("failure").add(this.failure);} return (A) this;
    }

    public java.lang.Boolean hasFailure() {
        return this.failure != null;
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.FailureNested<A> withNewFailure() {
        return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.FailureNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.FailureNested<A> withNewFailureLike(io.fabric8.camelk.v1.Failure item) {
        return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.FailureNestedImpl(item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.FailureNested<A> editFailure() {
        return withNewFailureLike(getFailure());
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.FailureNested<A> editOrNewFailure() {
        return withNewFailureLike(getFailure() != null ? getFailure(): new io.fabric8.camelk.v1.FailureBuilder().build());
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.FailureNested<A> editOrNewFailureLike(io.fabric8.camelk.v1.Failure item) {
        return withNewFailureLike(getFailure() != null ? getFailure(): item);
    }

    public A addToGeneratedResources(int index,io.fabric8.camelk.v1.ResourceSpec item) {
        if (this.generatedResources == null) {this.generatedResources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
        io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("generatedResources").add(index >= 0 ? index : _visitables.get("generatedResources").size(), builder);this.generatedResources.add(index >= 0 ? index : generatedResources.size(), builder); return (A)this;
    }

    public A setToGeneratedResources(int index,io.fabric8.camelk.v1.ResourceSpec item) {
        if (this.generatedResources == null) {this.generatedResources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
        io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("generatedResources").size()) { _visitables.get("generatedResources").add(builder); } else { _visitables.get("generatedResources").set(index, builder);}
        if (index < 0 || index >= generatedResources.size()) { generatedResources.add(builder); } else { generatedResources.set(index, builder);}
         return (A)this;
    }

    public A addToGeneratedResources(io.fabric8.camelk.v1.ResourceSpec... items) {
        if (this.generatedResources == null) {this.generatedResources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
        for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("generatedResources").add(builder);this.generatedResources.add(builder);} return (A)this;
    }

    public A addAllToGeneratedResources(java.util.Collection<io.fabric8.camelk.v1.ResourceSpec> items) {
        if (this.generatedResources == null) {this.generatedResources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>();}
        for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("generatedResources").add(builder);this.generatedResources.add(builder);} return (A)this;
    }

    public A removeFromGeneratedResources(io.fabric8.camelk.v1.ResourceSpec... items) {
        for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("generatedResources").remove(builder);if (this.generatedResources != null) {this.generatedResources.remove(builder);}} return (A)this;
    }

    public A removeAllFromGeneratedResources(java.util.Collection<io.fabric8.camelk.v1.ResourceSpec> items) {
        for (io.fabric8.camelk.v1.ResourceSpec item : items) {io.fabric8.camelk.v1.ResourceSpecBuilder builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(item);_visitables.get("generatedResources").remove(builder);if (this.generatedResources != null) {this.generatedResources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromGeneratedResources(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
        if (generatedResources == null) return (A) this;
        final Iterator<io.fabric8.camelk.v1.ResourceSpecBuilder> each = generatedResources.iterator();
        final List visitables = _visitables.get("generatedResources");
        while (each.hasNext()) {
          io.fabric8.camelk.v1.ResourceSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildGeneratedResources instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.camelk.v1.ResourceSpec> getGeneratedResources() {
        return build(generatedResources);
    }

    public java.util.List<io.fabric8.camelk.v1.ResourceSpec> buildGeneratedResources() {
        return build(generatedResources);
    }

    public io.fabric8.camelk.v1.ResourceSpec buildGeneratedResource(int index) {
        return this.generatedResources.get(index).build();
    }

    public io.fabric8.camelk.v1.ResourceSpec buildFirstGeneratedResource() {
        return this.generatedResources.get(0).build();
    }

    public io.fabric8.camelk.v1.ResourceSpec buildLastGeneratedResource() {
        return this.generatedResources.get(generatedResources.size() - 1).build();
    }

    public io.fabric8.camelk.v1.ResourceSpec buildMatchingGeneratedResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
        for (io.fabric8.camelk.v1.ResourceSpecBuilder item: generatedResources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingGeneratedResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
        for (io.fabric8.camelk.v1.ResourceSpecBuilder item: generatedResources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withGeneratedResources(java.util.List<io.fabric8.camelk.v1.ResourceSpec> generatedResources) {
        if (this.generatedResources != null) { _visitables.get("generatedResources").removeAll(this.generatedResources);}
        if (generatedResources != null) {this.generatedResources = new java.util.ArrayList<io.fabric8.camelk.v1.ResourceSpecBuilder>(); for (io.fabric8.camelk.v1.ResourceSpec item : generatedResources){this.addToGeneratedResources(item);}} else { this.generatedResources = null;} return (A) this;
    }

    public A withGeneratedResources(io.fabric8.camelk.v1.ResourceSpec... generatedResources) {
        if (this.generatedResources != null) {this.generatedResources.clear();}
        if (generatedResources != null) {for (io.fabric8.camelk.v1.ResourceSpec item :generatedResources){ this.addToGeneratedResources(item);}} return (A) this;
    }

    public java.lang.Boolean hasGeneratedResources() {
        return generatedResources != null && !generatedResources.isEmpty();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> addNewGeneratedResource() {
        return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.GeneratedResourcesNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> addNewGeneratedResourceLike(io.fabric8.camelk.v1.ResourceSpec item) {
        return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.GeneratedResourcesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> setNewGeneratedResourceLike(int index,io.fabric8.camelk.v1.ResourceSpec item) {
        return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.GeneratedResourcesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> editGeneratedResource(int index) {
        if (generatedResources.size() <= index) throw new RuntimeException("Can't edit generatedResources. Index exceeds size.");
        return setNewGeneratedResourceLike(index, buildGeneratedResource(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> editFirstGeneratedResource() {
        if (generatedResources.size() == 0) throw new RuntimeException("Can't edit first generatedResources. The list is empty.");
        return setNewGeneratedResourceLike(0, buildGeneratedResource(0));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> editLastGeneratedResource() {
        int index = generatedResources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last generatedResources. The list is empty.");
        return setNewGeneratedResourceLike(index, buildGeneratedResource(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<A> editMatchingGeneratedResource(java.util.function.Predicate<io.fabric8.camelk.v1.ResourceSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<generatedResources.size();i++) { 
        if (predicate.test(generatedResources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching generatedResources. No match found.");
        return setNewGeneratedResourceLike(index, buildGeneratedResource(index));
    }

    public A addToGeneratedSources(int index,io.fabric8.camelk.v1.SourceSpec item) {
        if (this.generatedSources == null) {this.generatedSources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
        io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("generatedSources").add(index >= 0 ? index : _visitables.get("generatedSources").size(), builder);this.generatedSources.add(index >= 0 ? index : generatedSources.size(), builder); return (A)this;
    }

    public A setToGeneratedSources(int index,io.fabric8.camelk.v1.SourceSpec item) {
        if (this.generatedSources == null) {this.generatedSources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
        io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("generatedSources").size()) { _visitables.get("generatedSources").add(builder); } else { _visitables.get("generatedSources").set(index, builder);}
        if (index < 0 || index >= generatedSources.size()) { generatedSources.add(builder); } else { generatedSources.set(index, builder);}
         return (A)this;
    }

    public A addToGeneratedSources(io.fabric8.camelk.v1.SourceSpec... items) {
        if (this.generatedSources == null) {this.generatedSources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
        for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("generatedSources").add(builder);this.generatedSources.add(builder);} return (A)this;
    }

    public A addAllToGeneratedSources(java.util.Collection<io.fabric8.camelk.v1.SourceSpec> items) {
        if (this.generatedSources == null) {this.generatedSources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>();}
        for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("generatedSources").add(builder);this.generatedSources.add(builder);} return (A)this;
    }

    public A removeFromGeneratedSources(io.fabric8.camelk.v1.SourceSpec... items) {
        for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("generatedSources").remove(builder);if (this.generatedSources != null) {this.generatedSources.remove(builder);}} return (A)this;
    }

    public A removeAllFromGeneratedSources(java.util.Collection<io.fabric8.camelk.v1.SourceSpec> items) {
        for (io.fabric8.camelk.v1.SourceSpec item : items) {io.fabric8.camelk.v1.SourceSpecBuilder builder = new io.fabric8.camelk.v1.SourceSpecBuilder(item);_visitables.get("generatedSources").remove(builder);if (this.generatedSources != null) {this.generatedSources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromGeneratedSources(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
        if (generatedSources == null) return (A) this;
        final Iterator<io.fabric8.camelk.v1.SourceSpecBuilder> each = generatedSources.iterator();
        final List visitables = _visitables.get("generatedSources");
        while (each.hasNext()) {
          io.fabric8.camelk.v1.SourceSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildGeneratedSources instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.camelk.v1.SourceSpec> getGeneratedSources() {
        return build(generatedSources);
    }

    public java.util.List<io.fabric8.camelk.v1.SourceSpec> buildGeneratedSources() {
        return build(generatedSources);
    }

    public io.fabric8.camelk.v1.SourceSpec buildGeneratedSource(int index) {
        return this.generatedSources.get(index).build();
    }

    public io.fabric8.camelk.v1.SourceSpec buildFirstGeneratedSource() {
        return this.generatedSources.get(0).build();
    }

    public io.fabric8.camelk.v1.SourceSpec buildLastGeneratedSource() {
        return this.generatedSources.get(generatedSources.size() - 1).build();
    }

    public io.fabric8.camelk.v1.SourceSpec buildMatchingGeneratedSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
        for (io.fabric8.camelk.v1.SourceSpecBuilder item: generatedSources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingGeneratedSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
        for (io.fabric8.camelk.v1.SourceSpecBuilder item: generatedSources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withGeneratedSources(java.util.List<io.fabric8.camelk.v1.SourceSpec> generatedSources) {
        if (this.generatedSources != null) { _visitables.get("generatedSources").removeAll(this.generatedSources);}
        if (generatedSources != null) {this.generatedSources = new java.util.ArrayList<io.fabric8.camelk.v1.SourceSpecBuilder>(); for (io.fabric8.camelk.v1.SourceSpec item : generatedSources){this.addToGeneratedSources(item);}} else { this.generatedSources = null;} return (A) this;
    }

    public A withGeneratedSources(io.fabric8.camelk.v1.SourceSpec... generatedSources) {
        if (this.generatedSources != null) {this.generatedSources.clear();}
        if (generatedSources != null) {for (io.fabric8.camelk.v1.SourceSpec item :generatedSources){ this.addToGeneratedSources(item);}} return (A) this;
    }

    public java.lang.Boolean hasGeneratedSources() {
        return generatedSources != null && !generatedSources.isEmpty();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> addNewGeneratedSource() {
        return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.GeneratedSourcesNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> addNewGeneratedSourceLike(io.fabric8.camelk.v1.SourceSpec item) {
        return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.GeneratedSourcesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> setNewGeneratedSourceLike(int index,io.fabric8.camelk.v1.SourceSpec item) {
        return new io.fabric8.camelk.v1.IntegrationStatusFluentImpl.GeneratedSourcesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> editGeneratedSource(int index) {
        if (generatedSources.size() <= index) throw new RuntimeException("Can't edit generatedSources. Index exceeds size.");
        return setNewGeneratedSourceLike(index, buildGeneratedSource(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> editFirstGeneratedSource() {
        if (generatedSources.size() == 0) throw new RuntimeException("Can't edit first generatedSources. The list is empty.");
        return setNewGeneratedSourceLike(0, buildGeneratedSource(0));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> editLastGeneratedSource() {
        int index = generatedSources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last generatedSources. The list is empty.");
        return setNewGeneratedSourceLike(index, buildGeneratedSource(index));
    }

    public io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<A> editMatchingGeneratedSource(java.util.function.Predicate<io.fabric8.camelk.v1.SourceSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<generatedSources.size();i++) { 
        if (predicate.test(generatedSources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching generatedSources. No match found.");
        return setNewGeneratedSourceLike(index, buildGeneratedSource(index));
    }

    public java.lang.String getImage() {
        return this.image;
    }

    public A withImage(java.lang.String image) {
        this.image=image; return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String arg0) {
        return (A)withImage(new String(arg0));
    }

    public java.lang.String getKit() {
        return this.kit;
    }

    public A withKit(java.lang.String kit) {
        this.kit=kit; return (A) this;
    }

    public java.lang.Boolean hasKit() {
        return this.kit != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKit instead.
     */
        public A withNewKit(java.lang.String arg0) {
        return (A)withKit(new String(arg0));
    }

    public java.lang.String getLastInitTimestamp() {
        return this.lastInitTimestamp;
    }

    public A withLastInitTimestamp(java.lang.String lastInitTimestamp) {
        this.lastInitTimestamp=lastInitTimestamp; return (A) this;
    }

    public java.lang.Boolean hasLastInitTimestamp() {
        return this.lastInitTimestamp != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLastInitTimestamp instead.
     */
        public A withNewLastInitTimestamp(java.lang.String arg0) {
        return (A)withLastInitTimestamp(new String(arg0));
    }

    public java.lang.String getPhase() {
        return this.phase;
    }

    public A withPhase(java.lang.String phase) {
        this.phase=phase; return (A) this;
    }

    public java.lang.Boolean hasPhase() {
        return this.phase != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPhase instead.
     */
        public A withNewPhase(java.lang.String arg0) {
        return (A)withPhase(new String(arg0));
    }

    public java.lang.String getPlatform() {
        return this.platform;
    }

    public A withPlatform(java.lang.String platform) {
        this.platform=platform; return (A) this;
    }

    public java.lang.Boolean hasPlatform() {
        return this.platform != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPlatform instead.
     */
        public A withNewPlatform(java.lang.String arg0) {
        return (A)withPlatform(new String(arg0));
    }

    public java.lang.String getProfile() {
        return this.profile;
    }

    public A withProfile(java.lang.String profile) {
        this.profile=profile; return (A) this;
    }

    public java.lang.Boolean hasProfile() {
        return this.profile != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withProfile instead.
     */
        public A withNewProfile(java.lang.String arg0) {
        return (A)withProfile(new String(arg0));
    }

    public java.lang.Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(java.lang.Integer replicas) {
        this.replicas=replicas; return (A) this;
    }

    public java.lang.Boolean hasReplicas() {
        return this.replicas != null;
    }

    public java.lang.String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    public A withRuntimeProvider(java.lang.String runtimeProvider) {
        this.runtimeProvider=runtimeProvider; return (A) this;
    }

    public java.lang.Boolean hasRuntimeProvider() {
        return this.runtimeProvider != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withRuntimeProvider instead.
     */
        public A withNewRuntimeProvider(java.lang.String arg0) {
        return (A)withRuntimeProvider(new String(arg0));
    }

    public java.lang.String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public A withRuntimeVersion(java.lang.String runtimeVersion) {
        this.runtimeVersion=runtimeVersion; return (A) this;
    }

    public java.lang.Boolean hasRuntimeVersion() {
        return this.runtimeVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withRuntimeVersion instead.
     */
        public A withNewRuntimeVersion(java.lang.String arg0) {
        return (A)withRuntimeVersion(new String(arg0));
    }

    public java.lang.String getSelector() {
        return this.selector;
    }

    public A withSelector(java.lang.String selector) {
        this.selector=selector; return (A) this;
    }

    public java.lang.Boolean hasSelector() {
        return this.selector != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withSelector instead.
     */
        public A withNewSelector(java.lang.String arg0) {
        return (A)withSelector(new String(arg0));
    }

    public java.lang.String getVersion() {
        return this.version;
    }

    public A withVersion(java.lang.String version) {
        this.version=version; return (A) this;
    }

    public java.lang.Boolean hasVersion() {
        return this.version != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withVersion instead.
     */
        public A withNewVersion(java.lang.String arg0) {
        return (A)withVersion(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IntegrationStatusFluentImpl that = (IntegrationStatusFluentImpl) o;
        if (capabilities != null ? !capabilities.equals(that.capabilities) :that.capabilities != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
        if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
        if (digest != null ? !digest.equals(that.digest) :that.digest != null) return false;
        if (failure != null ? !failure.equals(that.failure) :that.failure != null) return false;
        if (generatedResources != null ? !generatedResources.equals(that.generatedResources) :that.generatedResources != null) return false;
        if (generatedSources != null ? !generatedSources.equals(that.generatedSources) :that.generatedSources != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (kit != null ? !kit.equals(that.kit) :that.kit != null) return false;
        if (lastInitTimestamp != null ? !lastInitTimestamp.equals(that.lastInitTimestamp) :that.lastInitTimestamp != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        if (platform != null ? !platform.equals(that.platform) :that.platform != null) return false;
        if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
        if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
        if (runtimeProvider != null ? !runtimeProvider.equals(that.runtimeProvider) :that.runtimeProvider != null) return false;
        if (runtimeVersion != null ? !runtimeVersion.equals(that.runtimeVersion) :that.runtimeVersion != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(capabilities,  conditions,  configuration,  dependencies,  digest,  failure,  generatedResources,  generatedSources,  image,  kit,  lastInitTimestamp,  phase,  platform,  profile,  replicas,  runtimeProvider,  runtimeVersion,  selector,  version,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends io.fabric8.camelk.v1.IntegrationConditionFluentImpl<io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.IntegrationConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,io.fabric8.camelk.v1.IntegrationCondition item) {
                this.index = index;
                this.builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.camelk.v1.IntegrationConditionBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class ConfigurationNestedImpl<N> extends io.fabric8.camelk.v1.ConfigurationSpecFluentImpl<io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.ConfigurationSpecBuilder builder;
        private final int index;

            ConfigurationNestedImpl(int index,io.fabric8.camelk.v1.ConfigurationSpec item) {
                this.index = index;
                this.builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(this, item);
                        
            }

            ConfigurationNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.camelk.v1.ConfigurationSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationStatusFluentImpl.this.setToConfiguration(index,builder.build());
            }

            public N endConfiguration() {
                return and();
            }
    }


    public class FailureNestedImpl<N> extends io.fabric8.camelk.v1.FailureFluentImpl<io.fabric8.camelk.v1.IntegrationStatusFluent.FailureNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.FailureNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.FailureBuilder builder;

            FailureNestedImpl(io.fabric8.camelk.v1.Failure item) {
                this.builder = new io.fabric8.camelk.v1.FailureBuilder(this, item);
                        
            }

            FailureNestedImpl() {
                this.builder = new io.fabric8.camelk.v1.FailureBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationStatusFluentImpl.this.withFailure(builder.build());
            }

            public N endFailure() {
                return and();
            }
    }


    public class GeneratedResourcesNestedImpl<N> extends io.fabric8.camelk.v1.ResourceSpecFluentImpl<io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.ResourceSpecBuilder builder;
        private final int index;

            GeneratedResourcesNestedImpl(int index,io.fabric8.camelk.v1.ResourceSpec item) {
                this.index = index;
                this.builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(this, item);
                        
            }

            GeneratedResourcesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.camelk.v1.ResourceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationStatusFluentImpl.this.setToGeneratedResources(index,builder.build());
            }

            public N endGeneratedResource() {
                return and();
            }
    }


    public class GeneratedSourcesNestedImpl<N> extends io.fabric8.camelk.v1.SourceSpecFluentImpl<io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<N>> implements io.fabric8.camelk.v1.IntegrationStatusFluent.GeneratedSourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.camelk.v1.SourceSpecBuilder builder;
        private final int index;

            GeneratedSourcesNestedImpl(int index,io.fabric8.camelk.v1.SourceSpec item) {
                this.index = index;
                this.builder = new io.fabric8.camelk.v1.SourceSpecBuilder(this, item);
                        
            }

            GeneratedSourcesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.camelk.v1.SourceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationStatusFluentImpl.this.setToGeneratedSources(index,builder.build());
            }

            public N endGeneratedSource() {
                return and();
            }
    }


}
