package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceSpecBuilder extends ResourceSpecFluentImpl<ResourceSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ResourceSpec,ResourceSpecBuilder> {

    ResourceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceSpecBuilder() {
        this(true);
    }

    public ResourceSpecBuilder(Boolean validationEnabled) {
        this(new ResourceSpec(), validationEnabled);
    }

    public ResourceSpecBuilder(ResourceSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ResourceSpecBuilder(ResourceSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ResourceSpec(), validationEnabled);
    }

    public ResourceSpecBuilder(ResourceSpecFluent<?> fluent,ResourceSpec instance) {
        this(fluent, instance, true);
    }

    public ResourceSpecBuilder(ResourceSpecFluent<?> fluent,ResourceSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCompression(instance.getCompression()); 
        fluent.withContent(instance.getContent()); 
        fluent.withContentKey(instance.getContentKey()); 
        fluent.withContentRef(instance.getContentRef()); 
        fluent.withMountPath(instance.getMountPath()); 
        fluent.withName(instance.getName()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public ResourceSpecBuilder(ResourceSpec instance) {
        this(instance,true);
    }

    public ResourceSpecBuilder(ResourceSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCompression(instance.getCompression()); 
        this.withContent(instance.getContent()); 
        this.withContentKey(instance.getContentKey()); 
        this.withContentRef(instance.getContentRef()); 
        this.withMountPath(instance.getMountPath()); 
        this.withName(instance.getName()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableResourceSpec build() {
        EditableResourceSpec buildable = new EditableResourceSpec(fluent.getCompression(),fluent.getContent(),fluent.getContentKey(),fluent.getContentRef(),fluent.getMountPath(),fluent.getName(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ResourceSpecBuilder that = (ResourceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
