package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationPlatformRegistrySpecBuilder extends IntegrationPlatformRegistrySpecFluentImpl<IntegrationPlatformRegistrySpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IntegrationPlatformRegistrySpec,IntegrationPlatformRegistrySpecBuilder> {

    IntegrationPlatformRegistrySpecFluent<?> fluent;
    Boolean validationEnabled;

    public IntegrationPlatformRegistrySpecBuilder() {
        this(true);
    }

    public IntegrationPlatformRegistrySpecBuilder(Boolean validationEnabled) {
        this(new IntegrationPlatformRegistrySpec(), validationEnabled);
    }

    public IntegrationPlatformRegistrySpecBuilder(IntegrationPlatformRegistrySpecFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationPlatformRegistrySpecBuilder(IntegrationPlatformRegistrySpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IntegrationPlatformRegistrySpec(), validationEnabled);
    }

    public IntegrationPlatformRegistrySpecBuilder(IntegrationPlatformRegistrySpecFluent<?> fluent,IntegrationPlatformRegistrySpec instance) {
        this(fluent, instance, true);
    }

    public IntegrationPlatformRegistrySpecBuilder(IntegrationPlatformRegistrySpecFluent<?> fluent,IntegrationPlatformRegistrySpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAddress(instance.getAddress()); 
        fluent.withCa(instance.getCa()); 
        fluent.withInsecure(instance.getInsecure()); 
        fluent.withOrganization(instance.getOrganization()); 
        fluent.withSecret(instance.getSecret()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationPlatformRegistrySpecBuilder(IntegrationPlatformRegistrySpec instance) {
        this(instance,true);
    }

    public IntegrationPlatformRegistrySpecBuilder(IntegrationPlatformRegistrySpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAddress(instance.getAddress()); 
        this.withCa(instance.getCa()); 
        this.withInsecure(instance.getInsecure()); 
        this.withOrganization(instance.getOrganization()); 
        this.withSecret(instance.getSecret()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationPlatformRegistrySpec build() {
        EditableIntegrationPlatformRegistrySpec buildable = new EditableIntegrationPlatformRegistrySpec(fluent.getAddress(),fluent.getCa(),fluent.getInsecure(),fluent.getOrganization(),fluent.getSecret());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationPlatformRegistrySpecBuilder that = (IntegrationPlatformRegistrySpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
