package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageTaskBuilder extends ImageTaskFluentImpl<ImageTaskBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ImageTask,ImageTaskBuilder> {

    ImageTaskFluent<?> fluent;
    Boolean validationEnabled;

    public ImageTaskBuilder() {
        this(true);
    }

    public ImageTaskBuilder(Boolean validationEnabled) {
        this(new ImageTask(), validationEnabled);
    }

    public ImageTaskBuilder(ImageTaskFluent<?> fluent) {
        this(fluent, true);
    }

    public ImageTaskBuilder(ImageTaskFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ImageTask(), validationEnabled);
    }

    public ImageTaskBuilder(ImageTaskFluent<?> fluent,ImageTask instance) {
        this(fluent, instance, true);
    }

    public ImageTaskBuilder(ImageTaskFluent<?> fluent,ImageTask instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAffinity(instance.getAffinity()); 
        fluent.withArgs(instance.getArgs()); 
        fluent.withBuiltImage(instance.getBuiltImage()); 
        fluent.withCommand(instance.getCommand()); 
        fluent.withEnv(instance.getEnv()); 
        fluent.withImage(instance.getImage()); 
        fluent.withName(instance.getName()); 
        fluent.withSecurityContext(instance.getSecurityContext()); 
        fluent.withVolumeMounts(instance.getVolumeMounts()); 
        fluent.withVolumes(instance.getVolumes()); 
        fluent.withWorkingDir(instance.getWorkingDir()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImageTaskBuilder(ImageTask instance) {
        this(instance,true);
    }

    public ImageTaskBuilder(ImageTask instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAffinity(instance.getAffinity()); 
        this.withArgs(instance.getArgs()); 
        this.withBuiltImage(instance.getBuiltImage()); 
        this.withCommand(instance.getCommand()); 
        this.withEnv(instance.getEnv()); 
        this.withImage(instance.getImage()); 
        this.withName(instance.getName()); 
        this.withSecurityContext(instance.getSecurityContext()); 
        this.withVolumeMounts(instance.getVolumeMounts()); 
        this.withVolumes(instance.getVolumes()); 
        this.withWorkingDir(instance.getWorkingDir()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableImageTask build() {
        EditableImageTask buildable = new EditableImageTask(fluent.getAffinity(),fluent.getArgs(),fluent.getBuiltImage(),fluent.getCommand(),fluent.getEnv(),fluent.getImage(),fluent.getName(),fluent.getSecurityContext(),fluent.getVolumeMounts(),fluent.getVolumes(),fluent.getWorkingDir());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImageTaskBuilder that = (ImageTaskBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
