package io.fabric8.camelk.v1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class FailureRecoveryFluentImpl<A extends FailureRecoveryFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements FailureRecoveryFluent<A> {

    private Integer attempt;
    private Integer attemptMax;
    private String attemptTime;

    public FailureRecoveryFluentImpl() {
    }

    public FailureRecoveryFluentImpl(FailureRecovery instance) {
        this.withAttempt(instance.getAttempt()); 
        this.withAttemptMax(instance.getAttemptMax()); 
        this.withAttemptTime(instance.getAttemptTime()); 
    }

    public Integer getAttempt() {
        return this.attempt;
    }

    public A withAttempt(Integer attempt) {
        this.attempt=attempt; return (A) this;
    }

    public Boolean hasAttempt() {
        return this.attempt != null;
    }

    public A withNewAttempt(int arg0) {
        return (A)withAttempt(new Integer(arg0));
    }

    public Integer getAttemptMax() {
        return this.attemptMax;
    }

    public A withAttemptMax(Integer attemptMax) {
        this.attemptMax=attemptMax; return (A) this;
    }

    public Boolean hasAttemptMax() {
        return this.attemptMax != null;
    }

    public A withNewAttemptMax(int arg0) {
        return (A)withAttemptMax(new Integer(arg0));
    }

    public String getAttemptTime() {
        return this.attemptTime;
    }

    public A withAttemptTime(String attemptTime) {
        this.attemptTime=attemptTime; return (A) this;
    }

    public Boolean hasAttemptTime() {
        return this.attemptTime != null;
    }

    public A withNewAttemptTime(StringBuilder arg1) {
        return (A)withAttemptTime(new String(arg1));
    }

    public A withNewAttemptTime(int[] arg1,int arg2,int arg3) {
        return (A)withAttemptTime(new String(arg1, arg2, arg3));
    }

    public A withNewAttemptTime(char[] arg1) {
        return (A)withAttemptTime(new String(arg1));
    }

    public A withNewAttemptTime(StringBuffer arg1) {
        return (A)withAttemptTime(new String(arg1));
    }

    public A withNewAttemptTime(byte[] arg1,int arg2) {
        return (A)withAttemptTime(new String(arg1, arg2));
    }

    public A withNewAttemptTime(byte[] arg1) {
        return (A)withAttemptTime(new String(arg1));
    }

    public A withNewAttemptTime(char[] arg1,int arg2,int arg3) {
        return (A)withAttemptTime(new String(arg1, arg2, arg3));
    }

    public A withNewAttemptTime(byte[] arg1,int arg2,int arg3) {
        return (A)withAttemptTime(new String(arg1, arg2, arg3));
    }

    public A withNewAttemptTime(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withAttemptTime(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewAttemptTime(String arg1) {
        return (A)withAttemptTime(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FailureRecoveryFluentImpl that = (FailureRecoveryFluentImpl) o;
        if (attempt != null ? !attempt.equals(that.attempt) :that.attempt != null) return false;
        if (attemptMax != null ? !attemptMax.equals(that.attemptMax) :that.attemptMax != null) return false;
        if (attemptTime != null ? !attemptTime.equals(that.attemptTime) :that.attemptTime != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(attempt,  attemptMax,  attemptTime,  super.hashCode());
    }

}
