package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CapabilityFluent<A extends CapabilityFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToDependencies(int index,MavenArtifact item);
    public A setToDependencies(int index,MavenArtifact item);
    public A addToDependencies(MavenArtifact... items);
    public A addAllToDependencies(Collection<MavenArtifact> items);
    public A removeFromDependencies(MavenArtifact... items);
    public A removeAllFromDependencies(Collection<MavenArtifact> items);
    public A removeMatchingFromDependencies(Predicate<MavenArtifactBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildDependencies instead.
 * @return The buildable object.
 */
@Deprecated public List<MavenArtifact> getDependencies();
    public List<MavenArtifact> buildDependencies();
    public MavenArtifact buildDependency(int index);
    public MavenArtifact buildFirstDependency();
    public MavenArtifact buildLastDependency();
    public MavenArtifact buildMatchingDependency(Predicate<MavenArtifactBuilder> predicate);
    public Boolean hasMatchingDependency(Predicate<MavenArtifactBuilder> predicate);
    public A withDependencies(List<MavenArtifact> dependencies);
    public A withDependencies(MavenArtifact... dependencies);
    public Boolean hasDependencies();
    public A addNewDependency(String artifactId,String groupId,String version);
    public io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<A> addNewDependency();
    public io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<A> addNewDependencyLike(MavenArtifact item);
    public io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<A> setNewDependencyLike(int index,MavenArtifact item);
    public io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<A> editDependency(int index);
    public io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<A> editFirstDependency();
    public io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<A> editLastDependency();
    public io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<A> editMatchingDependency(Predicate<MavenArtifactBuilder> predicate);
    public A addToMetadata(String key,String value);
    public A addToMetadata(java.util.Map<String,String> map);
    public A removeFromMetadata(String key);
    public A removeFromMetadata(java.util.Map<String,String> map);
    public java.util.Map<String,String> getMetadata();
    public <K extends Object,V extends Object>A withMetadata(java.util.Map<String,String> metadata);
    public Boolean hasMetadata();
    public interface DependenciesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,MavenArtifactFluent<io.fabric8.camelk.v1.CapabilityFluent.DependenciesNested<N>> {

            public N and();
            public N endDependency();    }


}
