package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CapabilityBuilder extends CapabilityFluentImpl<CapabilityBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Capability,CapabilityBuilder> {

    CapabilityFluent<?> fluent;
    Boolean validationEnabled;

    public CapabilityBuilder() {
        this(true);
    }

    public CapabilityBuilder(Boolean validationEnabled) {
        this(new Capability(), validationEnabled);
    }

    public CapabilityBuilder(CapabilityFluent<?> fluent) {
        this(fluent, true);
    }

    public CapabilityBuilder(CapabilityFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Capability(), validationEnabled);
    }

    public CapabilityBuilder(CapabilityFluent<?> fluent,Capability instance) {
        this(fluent, instance, true);
    }

    public CapabilityBuilder(CapabilityFluent<?> fluent,Capability instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDependencies(instance.getDependencies()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public CapabilityBuilder(Capability instance) {
        this(instance,true);
    }

    public CapabilityBuilder(Capability instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDependencies(instance.getDependencies()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableCapability build() {
        EditableCapability buildable = new EditableCapability(fluent.getDependencies(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CapabilityBuilder that = (CapabilityBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
