package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CamelSchemeScopeFluentImpl<A extends CamelSchemeScopeFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CamelSchemeScopeFluent<A> {

    private List<CamelArtifactDependencyBuilder> dependencies;

    public CamelSchemeScopeFluentImpl() {
    }

    public CamelSchemeScopeFluentImpl(CamelSchemeScope instance) {
        this.withDependencies(instance.getDependencies()); 
    }

    public A addToDependencies(int index,CamelArtifactDependency item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<CamelArtifactDependencyBuilder>();}
        CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").add(index >= 0 ? index : _visitables.get("dependencies").size(), builder);this.dependencies.add(index >= 0 ? index : dependencies.size(), builder); return (A)this;
    }

    public A setToDependencies(int index,CamelArtifactDependency item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<CamelArtifactDependencyBuilder>();}
        CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);
        if (index < 0 || index >= _visitables.get("dependencies").size()) { _visitables.get("dependencies").add(builder); } else { _visitables.get("dependencies").set(index, builder);}
        if (index < 0 || index >= dependencies.size()) { dependencies.add(builder); } else { dependencies.set(index, builder);}
         return (A)this;
    }

    public A addToDependencies(CamelArtifactDependency... items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<CamelArtifactDependencyBuilder>();}
        for (CamelArtifactDependency item : items) {CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
    }

    public A addAllToDependencies(Collection<CamelArtifactDependency> items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<CamelArtifactDependencyBuilder>();}
        for (CamelArtifactDependency item : items) {CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
    }

    public A removeFromDependencies(CamelArtifactDependency... items) {
        for (CamelArtifactDependency item : items) {CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
    }

    public A removeAllFromDependencies(Collection<CamelArtifactDependency> items) {
        for (CamelArtifactDependency item : items) {CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromDependencies(Predicate<CamelArtifactDependencyBuilder> predicate) {
        if (dependencies == null) return (A) this;
        final Iterator<CamelArtifactDependencyBuilder> each = dependencies.iterator();
        final List visitables = _visitables.get("dependencies");
        while (each.hasNext()) {
          CamelArtifactDependencyBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildDependencies instead.
 * @return The buildable object.
 */
@Deprecated public List<CamelArtifactDependency> getDependencies() {
        return build(dependencies);
    }

    public List<CamelArtifactDependency> buildDependencies() {
        return build(dependencies);
    }

    public CamelArtifactDependency buildDependency(int index) {
        return this.dependencies.get(index).build();
    }

    public CamelArtifactDependency buildFirstDependency() {
        return this.dependencies.get(0).build();
    }

    public CamelArtifactDependency buildLastDependency() {
        return this.dependencies.get(dependencies.size() - 1).build();
    }

    public CamelArtifactDependency buildMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate) {
        for (CamelArtifactDependencyBuilder item: dependencies) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate) {
        for (CamelArtifactDependencyBuilder item: dependencies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDependencies(List<CamelArtifactDependency> dependencies) {
        if (this.dependencies != null) { _visitables.get("dependencies").removeAll(this.dependencies);}
        if (dependencies != null) {this.dependencies = new ArrayList<CamelArtifactDependencyBuilder>(); for (CamelArtifactDependency item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
    }

    public A withDependencies(CamelArtifactDependency... dependencies) {
        if (this.dependencies != null) {this.dependencies.clear();}
        if (dependencies != null) {for (CamelArtifactDependency item :dependencies){ this.addToDependencies(item);}} return (A) this;
    }

    public Boolean hasDependencies() {
        return dependencies != null && !dependencies.isEmpty();
    }

    public io.fabric8.camelk.v1.CamelSchemeScopeFluent.DependenciesNested<A> addNewDependency() {
        return new DependenciesNestedImpl();
    }

    public io.fabric8.camelk.v1.CamelSchemeScopeFluent.DependenciesNested<A> addNewDependencyLike(CamelArtifactDependency item) {
        return new DependenciesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.CamelSchemeScopeFluent.DependenciesNested<A> setNewDependencyLike(int index,CamelArtifactDependency item) {
        return new DependenciesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.CamelSchemeScopeFluent.DependenciesNested<A> editDependency(int index) {
        if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
        return setNewDependencyLike(index, buildDependency(index));
    }

    public io.fabric8.camelk.v1.CamelSchemeScopeFluent.DependenciesNested<A> editFirstDependency() {
        if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
        return setNewDependencyLike(0, buildDependency(0));
    }

    public io.fabric8.camelk.v1.CamelSchemeScopeFluent.DependenciesNested<A> editLastDependency() {
        int index = dependencies.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
        return setNewDependencyLike(index, buildDependency(index));
    }

    public io.fabric8.camelk.v1.CamelSchemeScopeFluent.DependenciesNested<A> editMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate) {
        int index = -1;
        for (int i=0;i<dependencies.size();i++) { 
        if (predicate.test(dependencies.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
        return setNewDependencyLike(index, buildDependency(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CamelSchemeScopeFluentImpl that = (CamelSchemeScopeFluentImpl) o;
        if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(dependencies,  super.hashCode());
    }

    public class DependenciesNestedImpl<N> extends CamelArtifactDependencyFluentImpl<io.fabric8.camelk.v1.CamelSchemeScopeFluent.DependenciesNested<N>> implements io.fabric8.camelk.v1.CamelSchemeScopeFluent.DependenciesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CamelArtifactDependencyBuilder builder;
        private final int index;

            DependenciesNestedImpl(int index,CamelArtifactDependency item) {
                this.index = index;
                this.builder = new CamelArtifactDependencyBuilder(this, item);
                        
            }

            DependenciesNestedImpl() {
                this.index = -1;
                this.builder = new CamelArtifactDependencyBuilder(this);
                        
            }

            public N and() {
                return (N) CamelSchemeScopeFluentImpl.this.setToDependencies(index,builder.build());
            }

            public N endDependency() {
                return and();
            }
    }


}
