package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CamelCatalogStatusBuilder extends CamelCatalogStatusFluentImpl<CamelCatalogStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<CamelCatalogStatus,CamelCatalogStatusBuilder> {

    CamelCatalogStatusFluent<?> fluent;
    Boolean validationEnabled;

    public CamelCatalogStatusBuilder() {
        this(true);
    }

    public CamelCatalogStatusBuilder(Boolean validationEnabled) {
        this(new CamelCatalogStatus(), validationEnabled);
    }

    public CamelCatalogStatusBuilder(CamelCatalogStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public CamelCatalogStatusBuilder(CamelCatalogStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CamelCatalogStatus(), validationEnabled);
    }

    public CamelCatalogStatusBuilder(CamelCatalogStatusFluent<?> fluent,CamelCatalogStatus instance) {
        this(fluent, instance, true);
    }

    public CamelCatalogStatusBuilder(CamelCatalogStatusFluent<?> fluent,CamelCatalogStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public CamelCatalogStatusBuilder(CamelCatalogStatus instance) {
        this(instance,true);
    }

    public CamelCatalogStatusBuilder(CamelCatalogStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableCamelCatalogStatus build() {
        EditableCamelCatalogStatus buildable = new EditableCamelCatalogStatus();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CamelCatalogStatusBuilder that = (CamelCatalogStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
