package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface CamelArtifactFluent<A extends CamelArtifactFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getArtifactId();
    public A withArtifactId(String artifactId);
    public Boolean hasArtifactId();
    public A withNewArtifactId(StringBuilder arg1);
    public A withNewArtifactId(int[] arg1,int arg2,int arg3);
    public A withNewArtifactId(char[] arg1);
    public A withNewArtifactId(StringBuffer arg1);
    public A withNewArtifactId(byte[] arg1,int arg2);
    public A withNewArtifactId(byte[] arg1);
    public A withNewArtifactId(char[] arg1,int arg2,int arg3);
    public A withNewArtifactId(byte[] arg1,int arg2,int arg3);
    public A withNewArtifactId(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewArtifactId(String arg1);
    public A addToDataformats(int index,String item);
    public A setToDataformats(int index,String item);
    public A addToDataformats(String... items);
    public A addAllToDataformats(Collection<String> items);
    public A removeFromDataformats(String... items);
    public A removeAllFromDataformats(Collection<String> items);
    public List<String> getDataformats();
    public String getDataformat(int index);
    public String getFirstDataformat();
    public String getLastDataformat();
    public String getMatchingDataformat(Predicate<String> predicate);
    public Boolean hasMatchingDataformat(Predicate<String> predicate);
    public A withDataformats(List<String> dataformats);
    public A withDataformats(String... dataformats);
    public Boolean hasDataformats();
    public A addNewDataformat(StringBuilder arg1);
    public A addNewDataformat(int[] arg1,int arg2,int arg3);
    public A addNewDataformat(char[] arg1);
    public A addNewDataformat(StringBuffer arg1);
    public A addNewDataformat(byte[] arg1,int arg2);
    public A addNewDataformat(byte[] arg1);
    public A addNewDataformat(char[] arg1,int arg2,int arg3);
    public A addNewDataformat(byte[] arg1,int arg2,int arg3);
    public A addNewDataformat(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewDataformat(String arg1);
    public A addToDependencies(int index,CamelArtifactDependency item);
    public A setToDependencies(int index,CamelArtifactDependency item);
    public A addToDependencies(CamelArtifactDependency... items);
    public A addAllToDependencies(Collection<CamelArtifactDependency> items);
    public A removeFromDependencies(CamelArtifactDependency... items);
    public A removeAllFromDependencies(Collection<CamelArtifactDependency> items);
    public A removeMatchingFromDependencies(Predicate<CamelArtifactDependencyBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildDependencies instead.
 * @return The buildable object.
 */
@Deprecated public List<CamelArtifactDependency> getDependencies();
    public List<CamelArtifactDependency> buildDependencies();
    public CamelArtifactDependency buildDependency(int index);
    public CamelArtifactDependency buildFirstDependency();
    public CamelArtifactDependency buildLastDependency();
    public CamelArtifactDependency buildMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate);
    public Boolean hasMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate);
    public A withDependencies(List<CamelArtifactDependency> dependencies);
    public A withDependencies(CamelArtifactDependency... dependencies);
    public Boolean hasDependencies();
    public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> addNewDependency();
    public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> addNewDependencyLike(CamelArtifactDependency item);
    public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> setNewDependencyLike(int index,CamelArtifactDependency item);
    public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> editDependency(int index);
    public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> editFirstDependency();
    public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> editLastDependency();
    public io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<A> editMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate);
    public A addToExclusions(int index,CamelArtifactExclusion item);
    public A setToExclusions(int index,CamelArtifactExclusion item);
    public A addToExclusions(CamelArtifactExclusion... items);
    public A addAllToExclusions(Collection<CamelArtifactExclusion> items);
    public A removeFromExclusions(CamelArtifactExclusion... items);
    public A removeAllFromExclusions(Collection<CamelArtifactExclusion> items);
    public A removeMatchingFromExclusions(Predicate<CamelArtifactExclusionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildExclusions instead.
 * @return The buildable object.
 */
@Deprecated public List<CamelArtifactExclusion> getExclusions();
    public List<CamelArtifactExclusion> buildExclusions();
    public CamelArtifactExclusion buildExclusion(int index);
    public CamelArtifactExclusion buildFirstExclusion();
    public CamelArtifactExclusion buildLastExclusion();
    public CamelArtifactExclusion buildMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate);
    public Boolean hasMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate);
    public A withExclusions(List<CamelArtifactExclusion> exclusions);
    public A withExclusions(CamelArtifactExclusion... exclusions);
    public Boolean hasExclusions();
    public A addNewExclusion(String artifactId,String groupId);
    public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> addNewExclusion();
    public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> addNewExclusionLike(CamelArtifactExclusion item);
    public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> setNewExclusionLike(int index,CamelArtifactExclusion item);
    public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> editExclusion(int index);
    public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> editFirstExclusion();
    public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> editLastExclusion();
    public io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<A> editMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate);
    public String getGroupId();
    public A withGroupId(String groupId);
    public Boolean hasGroupId();
    public A withNewGroupId(StringBuilder arg1);
    public A withNewGroupId(int[] arg1,int arg2,int arg3);
    public A withNewGroupId(char[] arg1);
    public A withNewGroupId(StringBuffer arg1);
    public A withNewGroupId(byte[] arg1,int arg2);
    public A withNewGroupId(byte[] arg1);
    public A withNewGroupId(char[] arg1,int arg2,int arg3);
    public A withNewGroupId(byte[] arg1,int arg2,int arg3);
    public A withNewGroupId(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewGroupId(String arg1);
    public A addToJavaTypes(int index,String item);
    public A setToJavaTypes(int index,String item);
    public A addToJavaTypes(String... items);
    public A addAllToJavaTypes(Collection<String> items);
    public A removeFromJavaTypes(String... items);
    public A removeAllFromJavaTypes(Collection<String> items);
    public List<String> getJavaTypes();
    public String getJavaType(int index);
    public String getFirstJavaType();
    public String getLastJavaType();
    public String getMatchingJavaType(Predicate<String> predicate);
    public Boolean hasMatchingJavaType(Predicate<String> predicate);
    public A withJavaTypes(List<String> javaTypes);
    public A withJavaTypes(String... javaTypes);
    public Boolean hasJavaTypes();
    public A addNewJavaType(StringBuilder arg1);
    public A addNewJavaType(int[] arg1,int arg2,int arg3);
    public A addNewJavaType(char[] arg1);
    public A addNewJavaType(StringBuffer arg1);
    public A addNewJavaType(byte[] arg1,int arg2);
    public A addNewJavaType(byte[] arg1);
    public A addNewJavaType(char[] arg1,int arg2,int arg3);
    public A addNewJavaType(byte[] arg1,int arg2,int arg3);
    public A addNewJavaType(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewJavaType(String arg1);
    public A addToLanguages(int index,String item);
    public A setToLanguages(int index,String item);
    public A addToLanguages(String... items);
    public A addAllToLanguages(Collection<String> items);
    public A removeFromLanguages(String... items);
    public A removeAllFromLanguages(Collection<String> items);
    public List<String> getLanguages();
    public String getLanguage(int index);
    public String getFirstLanguage();
    public String getLastLanguage();
    public String getMatchingLanguage(Predicate<String> predicate);
    public Boolean hasMatchingLanguage(Predicate<String> predicate);
    public A withLanguages(List<String> languages);
    public A withLanguages(String... languages);
    public Boolean hasLanguages();
    public A addNewLanguage(StringBuilder arg1);
    public A addNewLanguage(int[] arg1,int arg2,int arg3);
    public A addNewLanguage(char[] arg1);
    public A addNewLanguage(StringBuffer arg1);
    public A addNewLanguage(byte[] arg1,int arg2);
    public A addNewLanguage(byte[] arg1);
    public A addNewLanguage(char[] arg1,int arg2,int arg3);
    public A addNewLanguage(byte[] arg1,int arg2,int arg3);
    public A addNewLanguage(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewLanguage(String arg1);
    public A addToSchemes(int index,CamelScheme item);
    public A setToSchemes(int index,CamelScheme item);
    public A addToSchemes(CamelScheme... items);
    public A addAllToSchemes(Collection<CamelScheme> items);
    public A removeFromSchemes(CamelScheme... items);
    public A removeAllFromSchemes(Collection<CamelScheme> items);
    public A removeMatchingFromSchemes(Predicate<CamelSchemeBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildSchemes instead.
 * @return The buildable object.
 */
@Deprecated public List<CamelScheme> getSchemes();
    public List<CamelScheme> buildSchemes();
    public CamelScheme buildScheme(int index);
    public CamelScheme buildFirstScheme();
    public CamelScheme buildLastScheme();
    public CamelScheme buildMatchingScheme(Predicate<CamelSchemeBuilder> predicate);
    public Boolean hasMatchingScheme(Predicate<CamelSchemeBuilder> predicate);
    public A withSchemes(List<CamelScheme> schemes);
    public A withSchemes(CamelScheme... schemes);
    public Boolean hasSchemes();
    public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> addNewScheme();
    public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> addNewSchemeLike(CamelScheme item);
    public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> setNewSchemeLike(int index,CamelScheme item);
    public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> editScheme(int index);
    public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> editFirstScheme();
    public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> editLastScheme();
    public io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<A> editMatchingScheme(Predicate<CamelSchemeBuilder> predicate);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(int[] arg1,int arg2,int arg3);
    public A withNewVersion(char[] arg1);
    public A withNewVersion(StringBuffer arg1);
    public A withNewVersion(byte[] arg1,int arg2);
    public A withNewVersion(byte[] arg1);
    public A withNewVersion(char[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewVersion(String arg1);
    public interface DependenciesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CamelArtifactDependencyFluent<io.fabric8.camelk.v1.CamelArtifactFluent.DependenciesNested<N>> {

            public N and();
            public N endDependency();    }


    public interface ExclusionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CamelArtifactExclusionFluent<io.fabric8.camelk.v1.CamelArtifactFluent.ExclusionsNested<N>> {

            public N and();
            public N endExclusion();    }


    public interface SchemesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CamelSchemeFluent<io.fabric8.camelk.v1.CamelArtifactFluent.SchemesNested<N>> {

            public N and();
            public N endScheme();    }


}
