package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.List;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.StringBuffer;

public interface BuilderTaskFluent<A extends BuilderTaskFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Affinity getAffinity();
    public A withAffinity(Affinity affinity);
    public Boolean hasAffinity();
    public String getBaseImage();
    public A withBaseImage(String baseImage);
    public Boolean hasBaseImage();
    public A withNewBaseImage(StringBuilder arg1);
    public A withNewBaseImage(int[] arg1,int arg2,int arg3);
    public A withNewBaseImage(char[] arg1);
    public A withNewBaseImage(StringBuffer arg1);
    public A withNewBaseImage(byte[] arg1,int arg2);
    public A withNewBaseImage(byte[] arg1);
    public A withNewBaseImage(char[] arg1,int arg2,int arg3);
    public A withNewBaseImage(byte[] arg1,int arg2,int arg3);
    public A withNewBaseImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewBaseImage(String arg1);
    public String getBuildDir();
    public A withBuildDir(String buildDir);
    public Boolean hasBuildDir();
    public A withNewBuildDir(StringBuilder arg1);
    public A withNewBuildDir(int[] arg1,int arg2,int arg3);
    public A withNewBuildDir(char[] arg1);
    public A withNewBuildDir(StringBuffer arg1);
    public A withNewBuildDir(byte[] arg1,int arg2);
    public A withNewBuildDir(byte[] arg1);
    public A withNewBuildDir(char[] arg1,int arg2,int arg3);
    public A withNewBuildDir(byte[] arg1,int arg2,int arg3);
    public A withNewBuildDir(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewBuildDir(String arg1);
    public A addToDependencies(int index,String item);
    public A setToDependencies(int index,String item);
    public A addToDependencies(String... items);
    public A addAllToDependencies(Collection<String> items);
    public A removeFromDependencies(String... items);
    public A removeAllFromDependencies(Collection<String> items);
    public List<String> getDependencies();
    public String getDependency(int index);
    public String getFirstDependency();
    public String getLastDependency();
    public String getMatchingDependency(Predicate<String> predicate);
    public Boolean hasMatchingDependency(Predicate<String> predicate);
    public A withDependencies(List<String> dependencies);
    public A withDependencies(String... dependencies);
    public Boolean hasDependencies();
    public A addNewDependency(StringBuilder arg1);
    public A addNewDependency(int[] arg1,int arg2,int arg3);
    public A addNewDependency(char[] arg1);
    public A addNewDependency(StringBuffer arg1);
    public A addNewDependency(byte[] arg1,int arg2);
    public A addNewDependency(byte[] arg1);
    public A addNewDependency(char[] arg1,int arg2,int arg3);
    public A addNewDependency(byte[] arg1,int arg2,int arg3);
    public A addNewDependency(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewDependency(String arg1);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(int[] arg1,int arg2,int arg3);
    public A withNewImage(char[] arg1);
    public A withNewImage(StringBuffer arg1);
    public A withNewImage(byte[] arg1,int arg2);
    public A withNewImage(byte[] arg1);
    public A withNewImage(char[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImage(String arg1);
    
/**
 * This method has been deprecated, please use method buildMaven instead.
 * @return The buildable object.
 */
@Deprecated public MavenSpec getMaven();
    public MavenSpec buildMaven();
    public A withMaven(MavenSpec maven);
    public Boolean hasMaven();
    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> withNewMaven();
    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> withNewMavenLike(MavenSpec item);
    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> editMaven();
    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> editOrNewMaven();
    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> editOrNewMavenLike(MavenSpec item);
    
/**
 * This method has been deprecated, please use method buildMeta instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMeta();
    public ObjectMeta buildMeta();
    public A withMeta(ObjectMeta meta);
    public Boolean hasMeta();
    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> withNewMeta();
    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> withNewMetaLike(ObjectMeta item);
    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> editMeta();
    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> editOrNewMeta();
    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> editOrNewMetaLike(ObjectMeta item);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(StringBuilder arg1);
    public A withNewName(int[] arg1,int arg2,int arg3);
    public A withNewName(char[] arg1);
    public A withNewName(StringBuffer arg1);
    public A withNewName(byte[] arg1,int arg2);
    public A withNewName(byte[] arg1);
    public A withNewName(char[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewName(String arg1);
    public A addToProperties(String key,String value);
    public A addToProperties(java.util.Map<String,String> map);
    public A removeFromProperties(String key);
    public A removeFromProperties(java.util.Map<String,String> map);
    public java.util.Map<String,String> getProperties();
    public <K extends Object,V extends Object>A withProperties(java.util.Map<String,String> properties);
    public Boolean hasProperties();
    public A addToResources(int index,ResourceSpec item);
    public A setToResources(int index,ResourceSpec item);
    public A addToResources(ResourceSpec... items);
    public A addAllToResources(Collection<ResourceSpec> items);
    public A removeFromResources(ResourceSpec... items);
    public A removeAllFromResources(Collection<ResourceSpec> items);
    public A removeMatchingFromResources(Predicate<ResourceSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<ResourceSpec> getResources();
    public List<ResourceSpec> buildResources();
    public ResourceSpec buildResource(int index);
    public ResourceSpec buildFirstResource();
    public ResourceSpec buildLastResource();
    public ResourceSpec buildMatchingResource(Predicate<ResourceSpecBuilder> predicate);
    public Boolean hasMatchingResource(Predicate<ResourceSpecBuilder> predicate);
    public A withResources(List<ResourceSpec> resources);
    public A withResources(ResourceSpec... resources);
    public Boolean hasResources();
    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> addNewResource();
    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> addNewResourceLike(ResourceSpec item);
    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> setNewResourceLike(int index,ResourceSpec item);
    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editResource(int index);
    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editFirstResource();
    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editLastResource();
    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editMatchingResource(Predicate<ResourceSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildRuntime instead.
 * @return The buildable object.
 */
@Deprecated public RuntimeSpec getRuntime();
    public RuntimeSpec buildRuntime();
    public A withRuntime(RuntimeSpec runtime);
    public Boolean hasRuntime();
    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> withNewRuntime();
    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> withNewRuntimeLike(RuntimeSpec item);
    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> editRuntime();
    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> editOrNewRuntime();
    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> editOrNewRuntimeLike(RuntimeSpec item);
    public A addToSources(int index,SourceSpec item);
    public A setToSources(int index,SourceSpec item);
    public A addToSources(SourceSpec... items);
    public A addAllToSources(Collection<SourceSpec> items);
    public A removeFromSources(SourceSpec... items);
    public A removeAllFromSources(Collection<SourceSpec> items);
    public A removeMatchingFromSources(Predicate<SourceSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildSources instead.
 * @return The buildable object.
 */
@Deprecated public List<SourceSpec> getSources();
    public List<SourceSpec> buildSources();
    public SourceSpec buildSource(int index);
    public SourceSpec buildFirstSource();
    public SourceSpec buildLastSource();
    public SourceSpec buildMatchingSource(Predicate<SourceSpecBuilder> predicate);
    public Boolean hasMatchingSource(Predicate<SourceSpecBuilder> predicate);
    public A withSources(List<SourceSpec> sources);
    public A withSources(SourceSpec... sources);
    public Boolean hasSources();
    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> addNewSource();
    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> addNewSourceLike(SourceSpec item);
    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> setNewSourceLike(int index,SourceSpec item);
    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editSource(int index);
    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editFirstSource();
    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editLastSource();
    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editMatchingSource(Predicate<SourceSpecBuilder> predicate);
    public A addToSteps(int index,String item);
    public A setToSteps(int index,String item);
    public A addToSteps(String... items);
    public A addAllToSteps(Collection<String> items);
    public A removeFromSteps(String... items);
    public A removeAllFromSteps(Collection<String> items);
    public List<String> getSteps();
    public String getStep(int index);
    public String getFirstStep();
    public String getLastStep();
    public String getMatchingStep(Predicate<String> predicate);
    public Boolean hasMatchingStep(Predicate<String> predicate);
    public A withSteps(List<String> steps);
    public A withSteps(String... steps);
    public Boolean hasSteps();
    public A addNewStep(StringBuilder arg1);
    public A addNewStep(int[] arg1,int arg2,int arg3);
    public A addNewStep(char[] arg1);
    public A addNewStep(StringBuffer arg1);
    public A addNewStep(byte[] arg1,int arg2);
    public A addNewStep(byte[] arg1);
    public A addNewStep(char[] arg1,int arg2,int arg3);
    public A addNewStep(byte[] arg1,int arg2,int arg3);
    public A addNewStep(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewStep(String arg1);
    public Duration getTimeout();
    public A withTimeout(Duration timeout);
    public Boolean hasTimeout();
    public A addToVolumeMounts(int index,VolumeMount item);
    public A setToVolumeMounts(int index,VolumeMount item);
    public A addToVolumeMounts(VolumeMount... items);
    public A addAllToVolumeMounts(Collection<VolumeMount> items);
    public A removeFromVolumeMounts(VolumeMount... items);
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items);
    public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumeMounts instead.
 * @return The buildable object.
 */
@Deprecated public List<VolumeMount> getVolumeMounts();
    public List<VolumeMount> buildVolumeMounts();
    public VolumeMount buildVolumeMount(int index);
    public VolumeMount buildFirstVolumeMount();
    public VolumeMount buildLastVolumeMount();
    public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate);
    public Boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate);
    public A withVolumeMounts(List<VolumeMount> volumeMounts);
    public A withVolumeMounts(VolumeMount... volumeMounts);
    public Boolean hasVolumeMounts();
    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> addNewVolumeMount();
    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item);
    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index,VolumeMount item);
    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> editVolumeMount(int index);
    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> editFirstVolumeMount();
    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> editLastVolumeMount();
    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate);
    public A addToVolumes(int index,Volume item);
    public A setToVolumes(int index,Volume item);
    public A addToVolumes(Volume... items);
    public A addAllToVolumes(Collection<Volume> items);
    public A removeFromVolumes(Volume... items);
    public A removeAllFromVolumes(Collection<Volume> items);
    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<Volume> getVolumes();
    public List<Volume> buildVolumes();
    public Volume buildVolume(int index);
    public Volume buildFirstVolume();
    public Volume buildLastVolume();
    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate);
    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate);
    public A withVolumes(List<Volume> volumes);
    public A withVolumes(Volume... volumes);
    public Boolean hasVolumes();
    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> addNewVolume();
    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> addNewVolumeLike(Volume item);
    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> setNewVolumeLike(int index,Volume item);
    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> editVolume(int index);
    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> editFirstVolume();
    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> editLastVolume();
    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate);
    public interface MavenNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,MavenSpecFluent<io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<N>> {

            public N and();
            public N endMaven();    }


    public interface MetaNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<N>> {

            public N and();
            public N endMeta();    }


    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceSpecFluent<io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<N>> {

            public N and();
            public N endResource();    }


    public interface RuntimeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RuntimeSpecFluent<io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<N>> {

            public N and();
            public N endRuntime();    }


    public interface SourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SourceSpecFluent<io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<N>> {

            public N and();
            public N endSource();    }


    public interface VolumeMountsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeMountFluent<io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<N>> {

            public N and();
            public N endVolumeMount();    }


    public interface VolumesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeFluent<io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<N>> {

            public N and();
            public N endVolume();    }


}
