package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuilderTaskBuilder extends BuilderTaskFluentImpl<BuilderTaskBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<BuilderTask,BuilderTaskBuilder> {

    BuilderTaskFluent<?> fluent;
    Boolean validationEnabled;

    public BuilderTaskBuilder() {
        this(true);
    }

    public BuilderTaskBuilder(Boolean validationEnabled) {
        this(new BuilderTask(), validationEnabled);
    }

    public BuilderTaskBuilder(BuilderTaskFluent<?> fluent) {
        this(fluent, true);
    }

    public BuilderTaskBuilder(BuilderTaskFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new BuilderTask(), validationEnabled);
    }

    public BuilderTaskBuilder(BuilderTaskFluent<?> fluent,BuilderTask instance) {
        this(fluent, instance, true);
    }

    public BuilderTaskBuilder(BuilderTaskFluent<?> fluent,BuilderTask instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAffinity(instance.getAffinity()); 
        fluent.withBaseImage(instance.getBaseImage()); 
        fluent.withBuildDir(instance.getBuildDir()); 
        fluent.withDependencies(instance.getDependencies()); 
        fluent.withImage(instance.getImage()); 
        fluent.withMaven(instance.getMaven()); 
        fluent.withMeta(instance.getMeta()); 
        fluent.withName(instance.getName()); 
        fluent.withProperties(instance.getProperties()); 
        fluent.withResources(instance.getResources()); 
        fluent.withRuntime(instance.getRuntime()); 
        fluent.withSources(instance.getSources()); 
        fluent.withSteps(instance.getSteps()); 
        fluent.withTimeout(instance.getTimeout()); 
        fluent.withVolumeMounts(instance.getVolumeMounts()); 
        fluent.withVolumes(instance.getVolumes()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuilderTaskBuilder(BuilderTask instance) {
        this(instance,true);
    }

    public BuilderTaskBuilder(BuilderTask instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAffinity(instance.getAffinity()); 
        this.withBaseImage(instance.getBaseImage()); 
        this.withBuildDir(instance.getBuildDir()); 
        this.withDependencies(instance.getDependencies()); 
        this.withImage(instance.getImage()); 
        this.withMaven(instance.getMaven()); 
        this.withMeta(instance.getMeta()); 
        this.withName(instance.getName()); 
        this.withProperties(instance.getProperties()); 
        this.withResources(instance.getResources()); 
        this.withRuntime(instance.getRuntime()); 
        this.withSources(instance.getSources()); 
        this.withSteps(instance.getSteps()); 
        this.withTimeout(instance.getTimeout()); 
        this.withVolumeMounts(instance.getVolumeMounts()); 
        this.withVolumes(instance.getVolumes()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableBuilderTask build() {
        EditableBuilderTask buildable = new EditableBuilderTask(fluent.getAffinity(),fluent.getBaseImage(),fluent.getBuildDir(),fluent.getDependencies(),fluent.getImage(),fluent.getMaven(),fluent.getMeta(),fluent.getName(),fluent.getProperties(),fluent.getResources(),fluent.getRuntime(),fluent.getSources(),fluent.getSteps(),fluent.getTimeout(),fluent.getVolumeMounts(),fluent.getVolumes());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuilderTaskBuilder that = (BuilderTaskBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
