package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SourceSpecBuilder extends SourceSpecFluentImpl<SourceSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<SourceSpec,SourceSpecBuilder> {

    SourceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SourceSpecBuilder() {
        this(true);
    }

    public SourceSpecBuilder(Boolean validationEnabled) {
        this(new SourceSpec(), validationEnabled);
    }

    public SourceSpecBuilder(SourceSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public SourceSpecBuilder(SourceSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SourceSpec(), validationEnabled);
    }

    public SourceSpecBuilder(SourceSpecFluent<?> fluent,SourceSpec instance) {
        this(fluent, instance, true);
    }

    public SourceSpecBuilder(SourceSpecFluent<?> fluent,SourceSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCompression(instance.getCompression()); 
        fluent.withContent(instance.getContent()); 
        fluent.withContentKey(instance.getContentKey()); 
        fluent.withContentRef(instance.getContentRef()); 
        fluent.withInterceptors(instance.getInterceptors()); 
        fluent.withLanguage(instance.getLanguage()); 
        fluent.withLoader(instance.getLoader()); 
        fluent.withName(instance.getName()); 
        fluent.withPropertyNames(instance.getPropertyNames()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public SourceSpecBuilder(SourceSpec instance) {
        this(instance,true);
    }

    public SourceSpecBuilder(SourceSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCompression(instance.getCompression()); 
        this.withContent(instance.getContent()); 
        this.withContentKey(instance.getContentKey()); 
        this.withContentRef(instance.getContentRef()); 
        this.withInterceptors(instance.getInterceptors()); 
        this.withLanguage(instance.getLanguage()); 
        this.withLoader(instance.getLoader()); 
        this.withName(instance.getName()); 
        this.withPropertyNames(instance.getPropertyNames()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableSourceSpec build() {
        EditableSourceSpec buildable = new EditableSourceSpec(fluent.getCompression(),fluent.getContent(),fluent.getContentKey(),fluent.getContentRef(),fluent.getInterceptors(),fluent.getLanguage(),fluent.getLoader(),fluent.getName(),fluent.getPropertyNames(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SourceSpecBuilder that = (SourceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
