package io.fabric8.camelk.v1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ResourceSpecFluentImpl<A extends ResourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ResourceSpecFluent<A> {

    private Boolean compression;
    private String content;
    private String contentKey;
    private String contentRef;
    private String mountPath;
    private String name;
    private String type;

    public ResourceSpecFluentImpl() {
    }

    public ResourceSpecFluentImpl(ResourceSpec instance) {
        this.withCompression(instance.getCompression()); 
        this.withContent(instance.getContent()); 
        this.withContentKey(instance.getContentKey()); 
        this.withContentRef(instance.getContentRef()); 
        this.withMountPath(instance.getMountPath()); 
        this.withName(instance.getName()); 
        this.withType(instance.getType()); 
    }

    public Boolean getCompression() {
        return this.compression;
    }

    public A withCompression(Boolean compression) {
        this.compression=compression; return (A) this;
    }

    public Boolean hasCompression() {
        return this.compression != null;
    }

    public A withNewCompression(String arg1) {
        return (A)withCompression(new Boolean(arg1));
    }

    public A withNewCompression(boolean arg1) {
        return (A)withCompression(new Boolean(arg1));
    }

    public String getContent() {
        return this.content;
    }

    public A withContent(String content) {
        this.content=content; return (A) this;
    }

    public Boolean hasContent() {
        return this.content != null;
    }

    public A withNewContent(StringBuilder arg1) {
        return (A)withContent(new String(arg1));
    }

    public A withNewContent(int[] arg1,int arg2,int arg3) {
        return (A)withContent(new String(arg1, arg2, arg3));
    }

    public A withNewContent(char[] arg1) {
        return (A)withContent(new String(arg1));
    }

    public A withNewContent(StringBuffer arg1) {
        return (A)withContent(new String(arg1));
    }

    public A withNewContent(byte[] arg1,int arg2) {
        return (A)withContent(new String(arg1, arg2));
    }

    public A withNewContent(byte[] arg1) {
        return (A)withContent(new String(arg1));
    }

    public A withNewContent(char[] arg1,int arg2,int arg3) {
        return (A)withContent(new String(arg1, arg2, arg3));
    }

    public A withNewContent(byte[] arg1,int arg2,int arg3) {
        return (A)withContent(new String(arg1, arg2, arg3));
    }

    public A withNewContent(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withContent(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewContent(String arg1) {
        return (A)withContent(new String(arg1));
    }

    public String getContentKey() {
        return this.contentKey;
    }

    public A withContentKey(String contentKey) {
        this.contentKey=contentKey; return (A) this;
    }

    public Boolean hasContentKey() {
        return this.contentKey != null;
    }

    public A withNewContentKey(StringBuilder arg1) {
        return (A)withContentKey(new String(arg1));
    }

    public A withNewContentKey(int[] arg1,int arg2,int arg3) {
        return (A)withContentKey(new String(arg1, arg2, arg3));
    }

    public A withNewContentKey(char[] arg1) {
        return (A)withContentKey(new String(arg1));
    }

    public A withNewContentKey(StringBuffer arg1) {
        return (A)withContentKey(new String(arg1));
    }

    public A withNewContentKey(byte[] arg1,int arg2) {
        return (A)withContentKey(new String(arg1, arg2));
    }

    public A withNewContentKey(byte[] arg1) {
        return (A)withContentKey(new String(arg1));
    }

    public A withNewContentKey(char[] arg1,int arg2,int arg3) {
        return (A)withContentKey(new String(arg1, arg2, arg3));
    }

    public A withNewContentKey(byte[] arg1,int arg2,int arg3) {
        return (A)withContentKey(new String(arg1, arg2, arg3));
    }

    public A withNewContentKey(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withContentKey(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewContentKey(String arg1) {
        return (A)withContentKey(new String(arg1));
    }

    public String getContentRef() {
        return this.contentRef;
    }

    public A withContentRef(String contentRef) {
        this.contentRef=contentRef; return (A) this;
    }

    public Boolean hasContentRef() {
        return this.contentRef != null;
    }

    public A withNewContentRef(StringBuilder arg1) {
        return (A)withContentRef(new String(arg1));
    }

    public A withNewContentRef(int[] arg1,int arg2,int arg3) {
        return (A)withContentRef(new String(arg1, arg2, arg3));
    }

    public A withNewContentRef(char[] arg1) {
        return (A)withContentRef(new String(arg1));
    }

    public A withNewContentRef(StringBuffer arg1) {
        return (A)withContentRef(new String(arg1));
    }

    public A withNewContentRef(byte[] arg1,int arg2) {
        return (A)withContentRef(new String(arg1, arg2));
    }

    public A withNewContentRef(byte[] arg1) {
        return (A)withContentRef(new String(arg1));
    }

    public A withNewContentRef(char[] arg1,int arg2,int arg3) {
        return (A)withContentRef(new String(arg1, arg2, arg3));
    }

    public A withNewContentRef(byte[] arg1,int arg2,int arg3) {
        return (A)withContentRef(new String(arg1, arg2, arg3));
    }

    public A withNewContentRef(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withContentRef(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewContentRef(String arg1) {
        return (A)withContentRef(new String(arg1));
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public A withMountPath(String mountPath) {
        this.mountPath=mountPath; return (A) this;
    }

    public Boolean hasMountPath() {
        return this.mountPath != null;
    }

    public A withNewMountPath(StringBuilder arg1) {
        return (A)withMountPath(new String(arg1));
    }

    public A withNewMountPath(int[] arg1,int arg2,int arg3) {
        return (A)withMountPath(new String(arg1, arg2, arg3));
    }

    public A withNewMountPath(char[] arg1) {
        return (A)withMountPath(new String(arg1));
    }

    public A withNewMountPath(StringBuffer arg1) {
        return (A)withMountPath(new String(arg1));
    }

    public A withNewMountPath(byte[] arg1,int arg2) {
        return (A)withMountPath(new String(arg1, arg2));
    }

    public A withNewMountPath(byte[] arg1) {
        return (A)withMountPath(new String(arg1));
    }

    public A withNewMountPath(char[] arg1,int arg2,int arg3) {
        return (A)withMountPath(new String(arg1, arg2, arg3));
    }

    public A withNewMountPath(byte[] arg1,int arg2,int arg3) {
        return (A)withMountPath(new String(arg1, arg2, arg3));
    }

    public A withNewMountPath(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withMountPath(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewMountPath(String arg1) {
        return (A)withMountPath(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ResourceSpecFluentImpl that = (ResourceSpecFluentImpl) o;
        if (compression != null ? !compression.equals(that.compression) :that.compression != null) return false;
        if (content != null ? !content.equals(that.content) :that.content != null) return false;
        if (contentKey != null ? !contentKey.equals(that.contentKey) :that.contentKey != null) return false;
        if (contentRef != null ? !contentRef.equals(that.contentRef) :that.contentRef != null) return false;
        if (mountPath != null ? !mountPath.equals(that.mountPath) :that.mountPath != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(compression,  content,  contentKey,  contentRef,  mountPath,  name,  type,  super.hashCode());
    }

}
