package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationPlatformStatusBuilder extends IntegrationPlatformStatusFluentImpl<IntegrationPlatformStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IntegrationPlatformStatus,IntegrationPlatformStatusBuilder> {

    IntegrationPlatformStatusFluent<?> fluent;
    Boolean validationEnabled;

    public IntegrationPlatformStatusBuilder() {
        this(true);
    }

    public IntegrationPlatformStatusBuilder(Boolean validationEnabled) {
        this(new IntegrationPlatformStatus(), validationEnabled);
    }

    public IntegrationPlatformStatusBuilder(IntegrationPlatformStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationPlatformStatusBuilder(IntegrationPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IntegrationPlatformStatus(), validationEnabled);
    }

    public IntegrationPlatformStatusBuilder(IntegrationPlatformStatusFluent<?> fluent,IntegrationPlatformStatus instance) {
        this(fluent, instance, true);
    }

    public IntegrationPlatformStatusBuilder(IntegrationPlatformStatusFluent<?> fluent,IntegrationPlatformStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBuild(instance.getBuild()); 
        fluent.withCluster(instance.getCluster()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withConfiguration(instance.getConfiguration()); 
        fluent.withKamelet(instance.getKamelet()); 
        fluent.withPhase(instance.getPhase()); 
        fluent.withProfile(instance.getProfile()); 
        fluent.withResources(instance.getResources()); 
        fluent.withTraits(instance.getTraits()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationPlatformStatusBuilder(IntegrationPlatformStatus instance) {
        this(instance,true);
    }

    public IntegrationPlatformStatusBuilder(IntegrationPlatformStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withBuild(instance.getBuild()); 
        this.withCluster(instance.getCluster()); 
        this.withConditions(instance.getConditions()); 
        this.withConfiguration(instance.getConfiguration()); 
        this.withKamelet(instance.getKamelet()); 
        this.withPhase(instance.getPhase()); 
        this.withProfile(instance.getProfile()); 
        this.withResources(instance.getResources()); 
        this.withTraits(instance.getTraits()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationPlatformStatus build() {
        EditableIntegrationPlatformStatus buildable = new EditableIntegrationPlatformStatus(fluent.getBuild(),fluent.getCluster(),fluent.getConditions(),fluent.getConfiguration(),fluent.getKamelet(),fluent.getPhase(),fluent.getProfile(),fluent.getResources(),fluent.getTraits(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationPlatformStatusBuilder that = (IntegrationPlatformStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
