package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class IntegrationPlatformSpecFluentImpl<A extends IntegrationPlatformSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IntegrationPlatformSpecFluent<A> {

    private IntegrationPlatformBuildSpecBuilder build;
    private String cluster;
    private List<ConfigurationSpecBuilder> configuration;
    private IntegrationPlatformKameletSpecBuilder kamelet;
    private String profile;
    private IntegrationPlatformResourcesSpecBuilder resources;
    private java.util.Map<String,TraitSpec> traits;

    public IntegrationPlatformSpecFluentImpl() {
    }

    public IntegrationPlatformSpecFluentImpl(IntegrationPlatformSpec instance) {
        this.withBuild(instance.getBuild()); 
        this.withCluster(instance.getCluster()); 
        this.withConfiguration(instance.getConfiguration()); 
        this.withKamelet(instance.getKamelet()); 
        this.withProfile(instance.getProfile()); 
        this.withResources(instance.getResources()); 
        this.withTraits(instance.getTraits()); 
    }

    
/**
 * This method has been deprecated, please use method buildBuild instead.
 * @return The buildable object.
 */
@Deprecated public IntegrationPlatformBuildSpec getBuild() {
        return this.build!=null?this.build.build():null;
    }

    public IntegrationPlatformBuildSpec buildBuild() {
        return this.build!=null?this.build.build():null;
    }

    public A withBuild(IntegrationPlatformBuildSpec build) {
        _visitables.get("build").remove(this.build);
        if (build!=null){ this.build= new IntegrationPlatformBuildSpecBuilder(build); _visitables.get("build").add(this.build);} return (A) this;
    }

    public Boolean hasBuild() {
        return this.build != null;
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.BuildNested<A> withNewBuild() {
        return new BuildNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.BuildNested<A> withNewBuildLike(IntegrationPlatformBuildSpec item) {
        return new BuildNestedImpl(item);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.BuildNested<A> editBuild() {
        return withNewBuildLike(getBuild());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.BuildNested<A> editOrNewBuild() {
        return withNewBuildLike(getBuild() != null ? getBuild(): new IntegrationPlatformBuildSpecBuilder().build());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.BuildNested<A> editOrNewBuildLike(IntegrationPlatformBuildSpec item) {
        return withNewBuildLike(getBuild() != null ? getBuild(): item);
    }

    public String getCluster() {
        return this.cluster;
    }

    public A withCluster(String cluster) {
        this.cluster=cluster; return (A) this;
    }

    public Boolean hasCluster() {
        return this.cluster != null;
    }

    public A withNewCluster(StringBuilder arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A withNewCluster(int[] arg1,int arg2,int arg3) {
        return (A)withCluster(new String(arg1, arg2, arg3));
    }

    public A withNewCluster(char[] arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A withNewCluster(StringBuffer arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A withNewCluster(byte[] arg1,int arg2) {
        return (A)withCluster(new String(arg1, arg2));
    }

    public A withNewCluster(byte[] arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A withNewCluster(char[] arg1,int arg2,int arg3) {
        return (A)withCluster(new String(arg1, arg2, arg3));
    }

    public A withNewCluster(byte[] arg1,int arg2,int arg3) {
        return (A)withCluster(new String(arg1, arg2, arg3));
    }

    public A withNewCluster(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withCluster(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewCluster(String arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A addToConfiguration(int index,ConfigurationSpec item) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(index >= 0 ? index : _visitables.get("configuration").size(), builder);this.configuration.add(index >= 0 ? index : configuration.size(), builder); return (A)this;
    }

    public A setToConfiguration(int index,ConfigurationSpec item) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("configuration").size()) { _visitables.get("configuration").add(builder); } else { _visitables.get("configuration").set(index, builder);}
        if (index < 0 || index >= configuration.size()) { configuration.add(builder); } else { configuration.set(index, builder);}
         return (A)this;
    }

    public A addToConfiguration(ConfigurationSpec... items) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
    }

    public A addAllToConfiguration(Collection<ConfigurationSpec> items) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
    }

    public A removeFromConfiguration(ConfigurationSpec... items) {
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
    }

    public A removeAllFromConfiguration(Collection<ConfigurationSpec> items) {
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        if (configuration == null) return (A) this;
        final Iterator<ConfigurationSpecBuilder> each = configuration.iterator();
        final List visitables = _visitables.get("configuration");
        while (each.hasNext()) {
          ConfigurationSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public List<ConfigurationSpec> getConfiguration() {
        return build(configuration);
    }

    public List<ConfigurationSpec> buildConfiguration() {
        return build(configuration);
    }

    public ConfigurationSpec buildConfiguration(int index) {
        return this.configuration.get(index).build();
    }

    public ConfigurationSpec buildFirstConfiguration() {
        return this.configuration.get(0).build();
    }

    public ConfigurationSpec buildLastConfiguration() {
        return this.configuration.get(configuration.size() - 1).build();
    }

    public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConfiguration(List<ConfigurationSpec> configuration) {
        if (this.configuration != null) { _visitables.get("configuration").removeAll(this.configuration);}
        if (configuration != null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>(); for (ConfigurationSpec item : configuration){this.addToConfiguration(item);}} else { this.configuration = null;} return (A) this;
    }

    public A withConfiguration(ConfigurationSpec... configuration) {
        if (this.configuration != null) {this.configuration.clear();}
        if (configuration != null) {for (ConfigurationSpec item :configuration){ this.addToConfiguration(item);}} return (A) this;
    }

    public Boolean hasConfiguration() {
        return configuration != null && !configuration.isEmpty();
    }

    public A addNewConfiguration(String type,String value) {
        return (A)addToConfiguration(new ConfigurationSpec(type, value));
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<A> addNewConfiguration() {
        return new ConfigurationNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item) {
        return new ConfigurationNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<A> setNewConfigurationLike(int index,ConfigurationSpec item) {
        return new ConfigurationNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<A> editConfiguration(int index) {
        if (configuration.size() <= index) throw new RuntimeException("Can't edit configuration. Index exceeds size.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<A> editFirstConfiguration() {
        if (configuration.size() == 0) throw new RuntimeException("Can't edit first configuration. The list is empty.");
        return setNewConfigurationLike(0, buildConfiguration(0));
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<A> editLastConfiguration() {
        int index = configuration.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last configuration. The list is empty.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<configuration.size();i++) { 
        if (predicate.test(configuration.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching configuration. No match found.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    
/**
 * This method has been deprecated, please use method buildKamelet instead.
 * @return The buildable object.
 */
@Deprecated public IntegrationPlatformKameletSpec getKamelet() {
        return this.kamelet!=null?this.kamelet.build():null;
    }

    public IntegrationPlatformKameletSpec buildKamelet() {
        return this.kamelet!=null?this.kamelet.build():null;
    }

    public A withKamelet(IntegrationPlatformKameletSpec kamelet) {
        _visitables.get("kamelet").remove(this.kamelet);
        if (kamelet!=null){ this.kamelet= new IntegrationPlatformKameletSpecBuilder(kamelet); _visitables.get("kamelet").add(this.kamelet);} return (A) this;
    }

    public Boolean hasKamelet() {
        return this.kamelet != null;
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.KameletNested<A> withNewKamelet() {
        return new KameletNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.KameletNested<A> withNewKameletLike(IntegrationPlatformKameletSpec item) {
        return new KameletNestedImpl(item);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.KameletNested<A> editKamelet() {
        return withNewKameletLike(getKamelet());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.KameletNested<A> editOrNewKamelet() {
        return withNewKameletLike(getKamelet() != null ? getKamelet(): new IntegrationPlatformKameletSpecBuilder().build());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.KameletNested<A> editOrNewKameletLike(IntegrationPlatformKameletSpec item) {
        return withNewKameletLike(getKamelet() != null ? getKamelet(): item);
    }

    public String getProfile() {
        return this.profile;
    }

    public A withProfile(String profile) {
        this.profile=profile; return (A) this;
    }

    public Boolean hasProfile() {
        return this.profile != null;
    }

    public A withNewProfile(StringBuilder arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(int[] arg1,int arg2,int arg3) {
        return (A)withProfile(new String(arg1, arg2, arg3));
    }

    public A withNewProfile(char[] arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(StringBuffer arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(byte[] arg1,int arg2) {
        return (A)withProfile(new String(arg1, arg2));
    }

    public A withNewProfile(byte[] arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(char[] arg1,int arg2,int arg3) {
        return (A)withProfile(new String(arg1, arg2, arg3));
    }

    public A withNewProfile(byte[] arg1,int arg2,int arg3) {
        return (A)withProfile(new String(arg1, arg2, arg3));
    }

    public A withNewProfile(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withProfile(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewProfile(String arg1) {
        return (A)withProfile(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public IntegrationPlatformResourcesSpec getResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public IntegrationPlatformResourcesSpec buildResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public A withResources(IntegrationPlatformResourcesSpec resources) {
        _visitables.get("resources").remove(this.resources);
        if (resources!=null){ this.resources= new IntegrationPlatformResourcesSpecBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
    }

    public Boolean hasResources() {
        return this.resources != null;
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ResourcesNested<A> withNewResourcesLike(IntegrationPlatformResourcesSpec item) {
        return new ResourcesNestedImpl(item);
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ResourcesNested<A> editResources() {
        return withNewResourcesLike(getResources());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ResourcesNested<A> editOrNewResources() {
        return withNewResourcesLike(getResources() != null ? getResources(): new IntegrationPlatformResourcesSpecBuilder().build());
    }

    public io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ResourcesNested<A> editOrNewResourcesLike(IntegrationPlatformResourcesSpec item) {
        return withNewResourcesLike(getResources() != null ? getResources(): item);
    }

    public A addToTraits(String key,TraitSpec value) {
        if(this.traits == null && key != null && value != null) { this.traits = new LinkedHashMap<String,TraitSpec>(); }
        if(key != null && value != null) {this.traits.put(key, value);} return (A)this;
    }

    public A addToTraits(java.util.Map<String,TraitSpec> map) {
        if(this.traits == null && map != null) { this.traits = new LinkedHashMap<String,TraitSpec>(); }
        if(map != null) { this.traits.putAll(map);} return (A)this;
    }

    public A removeFromTraits(String key) {
        if(this.traits == null) { return (A) this; }
        if(key != null && this.traits != null) {this.traits.remove(key);} return (A)this;
    }

    public A removeFromTraits(java.util.Map<String,TraitSpec> map) {
        if(this.traits == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.traits != null){this.traits.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,TraitSpec> getTraits() {
        return this.traits;
    }

    public <K extends Object,V extends Object>A withTraits(java.util.Map<String,TraitSpec> traits) {
        if (traits == null) { this.traits =  null;} else {this.traits = new LinkedHashMap<String,TraitSpec>(traits);} return (A) this;
    }

    public Boolean hasTraits() {
        return this.traits != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IntegrationPlatformSpecFluentImpl that = (IntegrationPlatformSpecFluentImpl) o;
        if (build != null ? !build.equals(that.build) :that.build != null) return false;
        if (cluster != null ? !cluster.equals(that.cluster) :that.cluster != null) return false;
        if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
        if (kamelet != null ? !kamelet.equals(that.kamelet) :that.kamelet != null) return false;
        if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (traits != null ? !traits.equals(that.traits) :that.traits != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(build,  cluster,  configuration,  kamelet,  profile,  resources,  traits,  super.hashCode());
    }

    public class BuildNestedImpl<N> extends IntegrationPlatformBuildSpecFluentImpl<io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.BuildNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.BuildNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntegrationPlatformBuildSpecBuilder builder;

            BuildNestedImpl(IntegrationPlatformBuildSpec item) {
                this.builder = new IntegrationPlatformBuildSpecBuilder(this, item);
                        
            }

            BuildNestedImpl() {
                this.builder = new IntegrationPlatformBuildSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformSpecFluentImpl.this.withBuild(builder.build());
            }

            public N endBuild() {
                return and();
            }
    }


    public class ConfigurationNestedImpl<N> extends ConfigurationSpecFluentImpl<io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigurationSpecBuilder builder;
        private final int index;

            ConfigurationNestedImpl(int index,ConfigurationSpec item) {
                this.index = index;
                this.builder = new ConfigurationSpecBuilder(this, item);
                        
            }

            ConfigurationNestedImpl() {
                this.index = -1;
                this.builder = new ConfigurationSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformSpecFluentImpl.this.setToConfiguration(index,builder.build());
            }

            public N endConfiguration() {
                return and();
            }
    }


    public class KameletNestedImpl<N> extends IntegrationPlatformKameletSpecFluentImpl<io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.KameletNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.KameletNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntegrationPlatformKameletSpecBuilder builder;

            KameletNestedImpl(IntegrationPlatformKameletSpec item) {
                this.builder = new IntegrationPlatformKameletSpecBuilder(this, item);
                        
            }

            KameletNestedImpl() {
                this.builder = new IntegrationPlatformKameletSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformSpecFluentImpl.this.withKamelet(builder.build());
            }

            public N endKamelet() {
                return and();
            }
    }


    public class ResourcesNestedImpl<N> extends IntegrationPlatformResourcesSpecFluentImpl<io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ResourcesNested<N>> implements io.fabric8.camelk.v1.IntegrationPlatformSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntegrationPlatformResourcesSpecBuilder builder;

            ResourcesNestedImpl(IntegrationPlatformResourcesSpec item) {
                this.builder = new IntegrationPlatformResourcesSpecBuilder(this, item);
                        
            }

            ResourcesNestedImpl() {
                this.builder = new IntegrationPlatformResourcesSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformSpecFluentImpl.this.withResources(builder.build());
            }

            public N endResources() {
                return and();
            }
    }


}
