package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationPlatformConditionBuilder extends IntegrationPlatformConditionFluentImpl<IntegrationPlatformConditionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IntegrationPlatformCondition,IntegrationPlatformConditionBuilder> {

    IntegrationPlatformConditionFluent<?> fluent;
    Boolean validationEnabled;

    public IntegrationPlatformConditionBuilder() {
        this(true);
    }

    public IntegrationPlatformConditionBuilder(Boolean validationEnabled) {
        this(new IntegrationPlatformCondition(), validationEnabled);
    }

    public IntegrationPlatformConditionBuilder(IntegrationPlatformConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationPlatformConditionBuilder(IntegrationPlatformConditionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IntegrationPlatformCondition(), validationEnabled);
    }

    public IntegrationPlatformConditionBuilder(IntegrationPlatformConditionFluent<?> fluent,IntegrationPlatformCondition instance) {
        this(fluent, instance, true);
    }

    public IntegrationPlatformConditionBuilder(IntegrationPlatformConditionFluent<?> fluent,IntegrationPlatformCondition instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationPlatformConditionBuilder(IntegrationPlatformCondition instance) {
        this(instance,true);
    }

    public IntegrationPlatformConditionBuilder(IntegrationPlatformCondition instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withLastUpdateTime(instance.getLastUpdateTime()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationPlatformCondition build() {
        EditableIntegrationPlatformCondition buildable = new EditableIntegrationPlatformCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationPlatformConditionBuilder that = (IntegrationPlatformConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
